/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands;

import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.limits.Limits;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class AcceptInviteSubCmd
extends SubCommandBuilder {
    public AcceptInviteSubCmd() {
        super("accept");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            PlayerUtils.sendMessage(player, 0);
            return true;
        }
        String regionName = args[1];
        Region region = RegionsManager.findRegion(regionName);
        if (region == null) {
            PlayerUtils.sendMessage(player, 9);
            return false;
        }
        if (!region.isPlayerInvited((OfflinePlayer)player)) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            PlayerUtils.sendMessage(player, 45, replacements);
            return true;
        }
        if (Limits.hasReachedLimit(null, region, Limits.LimitType.MEMBERS_PER_REGION)) {
            PlayerUtils.sendMessage(player, 116);
            return true;
        }
        region.removePlayerInvite((OfflinePlayer)player);
        region.addMember((OfflinePlayer)player);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", region.getName());
        replacements.put("{playername}", player.getName());
        PlayerUtils.sendMessage(player, 46, replacements);
        PlayerUtils.sendMessage(region.getOwner().getPlayer(), 138, replacements);
        return true;
    }
}

