/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle.BMUtils;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class Cheese {
    private static final Vector2d CHUNK_CELL_SIZE = Vector2d.from((double)16.0, (double)16.0);
    private final Shape shape;
    private final Collection<Shape> holes;

    public Cheese(Shape shape) {
        this.shape = shape;
        this.holes = Collections.emptyList();
    }

    public Cheese(Shape shape, Shape ... holes) {
        this.shape = shape;
        this.holes = Arrays.asList(holes);
    }

    public Cheese(Shape shape, Collection<Shape> holes) {
        this.shape = shape;
        this.holes = holes;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Collection<Shape> getHoles() {
        return this.holes;
    }

    public static Collection<Cheese> createPlatterFromChunks(Vector2i ... chunks) {
        return Cheese.createPlatterFromCells(CHUNK_CELL_SIZE, chunks);
    }

    public static Cheese createSingleFromChunks(Vector2i ... chunks) {
        return Cheese.createSingleFromCells(CHUNK_CELL_SIZE, chunks);
    }

    public static Collection<Cheese> createPlatterFromCells(Vector2d cellSize, Vector2i ... cells) {
        HashSet<Vector2i> remainingCells = new HashSet<Vector2i>(List.of(cells));
        ArrayList<Cheese> platter = new ArrayList<Cheese>();
        while (!remainingCells.isEmpty()) {
            HashSet<Vector2i> connectedCells = new HashSet<Vector2i>();
            Stack<Vector2i> toVisit = new Stack<Vector2i>();
            Vector2i start = (Vector2i)remainingCells.iterator().next();
            toVisit.push(start);
            while (!toVisit.isEmpty()) {
                Vector2i current = (Vector2i)toVisit.pop();
                if (!remainingCells.contains(current)) continue;
                remainingCells.remove(current);
                connectedCells.add(current);
                for (Direction direction : Direction.values()) {
                    Vector2i neighbour = current.add(direction.vector);
                    if (!remainingCells.contains(neighbour)) continue;
                    toVisit.add(neighbour);
                }
            }
            platter.add(Cheese.createSingleFromCells(cellSize, (Vector2i[])connectedCells.toArray(Vector2i[]::new)));
        }
        return platter;
    }

    public static Cheese createSingleFromCells(Vector2d cellSize, Vector2i ... cells) {
        Set<Edge> edges = Cheese.createEdgesFromCells(cells);
        TreeMap<Vector2i, EnumMap<Direction, Edge>> borders = new TreeMap<Vector2i, EnumMap<Direction, Edge>>((a, b) -> {
            int c = a.getX() - b.getX();
            return c != 0 ? c : a.getY() - b.getY();
        });
        edges.stream().filter(edge -> !edges.contains(edge.flip)).forEach(edge -> borders.computeIfAbsent(edge.from, k -> new EnumMap(Direction.class)).put(edge.direction, edge));
        Shape outline = Cheese.createShape(Cheese.trace(borders, true), cellSize);
        LinkedList<Shape> holes = new LinkedList<Shape>();
        while (!borders.isEmpty()) {
            holes.add(Cheese.createShape(Cheese.trace(borders, false), cellSize));
        }
        return new Cheese(outline, holes);
    }

    private static Set<Edge> createEdgesFromCells(Vector2i ... cells) {
        HashSet<Edge> edges = new HashSet<Edge>(cells.length * 4);
        for (Vector2i cell : cells) {
            Vector2i[] corners = new Vector2i[]{cell, cell.add(1, 0), cell.add(1, 1), cell.add(0, 1)};
            edges.add(new Edge(corners[0], corners[1]));
            edges.add(new Edge(corners[1], corners[2]));
            edges.add(new Edge(corners[2], corners[3]));
            edges.add(new Edge(corners[3], corners[0]));
        }
        return edges;
    }

    private static List<Vector2i> trace(TreeMap<Vector2i, EnumMap<Direction, Edge>> borders, boolean clockwiseFirst) {
        Vector2i start;
        LinkedList<Vector2i> line = new LinkedList<Vector2i>();
        Vector2i position = start = borders.firstKey();
        Direction direction = Direction.UP;
        do {
            EnumMap<Direction, Edge> connectingEdges;
            if ((connectingEdges = borders.get(position)) == null || connectingEdges.isEmpty()) {
                throw new IllegalStateException("Loose end");
            }
            Direction d = direction.opposite;
            Edge edge = null;
            while (edge == null) {
                d = clockwiseFirst ? d.counterClockwise : d.clockwise;
                edge = connectingEdges.remove((Object)d);
            }
            line.add(position);
            position = edge.to;
            direction = edge.direction;
            Cheese.optimizeEnd(line);
        } while (!position.equals((Object)start));
        line.add((Vector2i)line.removeFirst());
        Cheese.optimizeEnd(line);
        borders.values().removeIf(Map::isEmpty);
        return line;
    }

    private static void optimizeEnd(List<Vector2i> line) {
        int s2 = line.size();
        if (s2 >= 3) {
            Vector2i from = line.get(s2 - 3);
            Vector2i middle = line.get(s2 - 2);
            Vector2i to = line.get(s2 - 1);
            if (from.getX() == middle.getX() && to.getX() == middle.getX() || from.getY() == middle.getY() && to.getY() == middle.getY()) {
                line.remove(s2 - 2);
            }
        }
    }

    private static Shape createShape(List<Vector2i> cellPositions, Vector2d cellSize) {
        return new Shape((Vector2d[])cellPositions.stream().map(position -> position.toDouble().mul(cellSize)).toArray(Vector2d[]::new));
    }

    private static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

        private Direction clockwise;
        private Direction counterClockwise;
        private Direction opposite;
        public Vector2i vector;

        static {
            Direction.UP.clockwise = RIGHT;
            Direction.RIGHT.clockwise = DOWN;
            Direction.DOWN.clockwise = LEFT;
            Direction.LEFT.clockwise = UP;
            Direction.UP.counterClockwise = LEFT;
            Direction.LEFT.counterClockwise = DOWN;
            Direction.DOWN.counterClockwise = RIGHT;
            Direction.RIGHT.counterClockwise = UP;
            Direction.UP.opposite = DOWN;
            Direction.LEFT.opposite = RIGHT;
            Direction.DOWN.opposite = UP;
            Direction.RIGHT.opposite = LEFT;
            Direction.UP.vector = Vector2i.from((int)0, (int)1);
            Direction.RIGHT.vector = Vector2i.from((int)1, (int)0);
            Direction.DOWN.vector = Vector2i.from((int)0, (int)-1);
            Direction.LEFT.vector = Vector2i.from((int)-1, (int)0);
        }
    }

    private static class Edge {
        private final Vector2i from;
        private final Vector2i to;
        private final Direction direction;
        private final Edge flip;

        public Edge(Vector2i from, Vector2i to) {
            if (from.equals((Object)to)) {
                throw new IllegalArgumentException("from and to can not be the same");
            }
            this.from = from;
            this.to = to;
            this.direction = from.getX() == to.getX() ? (from.getY() > to.getY() ? Direction.DOWN : Direction.UP) : (from.getX() > to.getX() ? Direction.LEFT : Direction.RIGHT);
            this.flip = new Edge(this);
        }

        private Edge(Edge flip) {
            this.from = flip.to;
            this.to = flip.from;
            this.direction = flip.direction.opposite;
            this.flip = flip;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            if (!this.from.equals((Object)edge.from)) {
                return false;
            }
            return this.to.equals((Object)edge.to);
        }

        public int hashCode() {
            int result = this.from.hashCode();
            result = 31 * result + this.to.hashCode();
            return result;
        }
    }
}

