/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.SubAreaSettingsMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;

public class SubAreasMenu {
    List<SerializableSubArea> subAreas;

    public SubAreasMenu(Player player, Region region) {
        this.subAreas = region.getSubAreas();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(14), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region), (_player, event) -> new RegionMenu(player, region), (_player, context) -> {
            if (context.getIndex() >= this.subAreas.size()) {
                return;
            }
            SerializableSubArea subArea = this.subAreas.get(context.getIndex());
            if (context.getEvent().isLeftClick()) {
                new SubAreaSettingsMenu(player, region, subArea);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.subAreas.size(); ++i) {
            SerializableSubArea subArea = this.subAreas.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{subarea}", subArea.getName());
            replacements.put("{subarea-volume}", String.valueOf(subArea.getVolume()));
            replacements.put("{subarea-createdat}", Formatters.formatDate(subArea.getCreatedAt()));
            items.add(MenuUtils.getButton(42, replacements, new OfflinePlayer[0]));
        }
        return items;
    }
}

