/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;

public class MySQL {
    private final String TABLE_PREFIX;
    private static final String JDBC_URL = "jdbc:mysql://";
    private Connection connection;

    public MySQL(String username, String password, String host, int port, String database, String tablePrefix) {
        this(username, password, host, port, database, tablePrefix, false);
    }

    public MySQL(String username, String password, String host, int port, String database, String tablePrefix, boolean handleError) {
        block4: {
            this.TABLE_PREFIX = tablePrefix.replaceAll("[^A-Za-z0-9_]", "");
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                String connectionUrl = JDBC_URL + host + ":" + port + "/" + database;
                this.connection = DriverManager.getConnection(connectionUrl, username, password);
                Logger.info("New database connection established.");
                this.createTablesIfNotExists();
            }
            catch (ClassNotFoundException e) {
                Logger.error("MySQL JDBC Driver not found.");
                e.printStackTrace();
                if (!handleError) {
                    Homestead.getInstance().endInstance();
                }
            }
            catch (SQLException e) {
                Logger.error("Unable to establish a connection for MySQL.");
                e.printStackTrace();
                if (handleError) break block4;
                Homestead.getInstance().endInstance();
            }
        }
    }

    public void createTablesIfNotExists() {
        String sql1 = "CREATE TABLE IF NOT EXISTS " + this.TABLE_PREFIX + "regions (id VARCHAR(36) PRIMARY KEY, displayName TINYTEXT NOT NULL, name TINYTEXT NOT NULL, description MEDIUMTEXT NOT NULL, ownerId TINYTEXT NOT NULL, location MEDIUMTEXT, createdAt BIGINT NOT NULL, playerFlags BIGINT NOT NULL, worldFlags BIGINT NOT NULL, bank DOUBLE NOT NULL, mapColor INT NOT NULL, chunks LONGTEXT NOT NULL, members LONGTEXT NOT NULL, rates LONGTEXT NOT NULL, invitedPlayers LONGTEXT NOT NULL, bannedPlayers LONGTEXT NOT NULL, subAreas LONGTEXT NOT NULL, logs LONGTEXT NOT NULL, rent LONGTEXT, upkeepAt BIGINT NOT NULL, taxesAmount DOUBLE NOT NULL, weather INT NOT NULL, time INT NOT NULL, welcomeSign MEDIUMTEXT,icon LONGTEXT)";
        String sql2 = "CREATE TABLE IF NOT EXISTS " + this.TABLE_PREFIX + "wars (id VARCHAR(36) PRIMARY KEY, displayName TINYTEXT NOT NULL, name TINYTEXT NOT NULL, description MEDIUMTEXT NOT NULL, regions LONGTEXT NOT NULL, prize DOUBLE NOT NULL, startedAt BIGINT NOT NULL)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql1);
            stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
    }

    public void importRegions() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.regionsCache.clear();
            while (rs.next()) {
                String icon;
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("displayName");
                String name = rs.getString("name");
                String description = rs.getString("description");
                OfflinePlayer owner = Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(rs.getString("ownerId")));
                SerializableLocation location = SerializableLocation.fromString(rs.getString("location"));
                long createdAt = rs.getLong("createdAt");
                long playerFlags = rs.getLong("playerFlags");
                long worldFlags = rs.getLong("worldFlags");
                double bank = rs.getDouble("bank");
                int mapColor = rs.getInt("mapColor");
                ArrayList<SerializableChunk> chunks = rs.getString("chunks").length() > 0 ? Arrays.asList(rs.getString("chunks").split("\u00a7")).stream().map(SerializableChunk::fromString).collect(Collectors.toList()) : new ArrayList<SerializableChunk>();
                ArrayList<SerializableMember> members = rs.getString("members").length() > 0 ? Arrays.asList(rs.getString("members").split("\u00a7")).stream().map(SerializableMember::fromString).collect(Collectors.toList()) : new ArrayList<SerializableMember>();
                ArrayList<SerializableRate> rates = rs.getString("rates").length() > 0 ? Arrays.asList(rs.getString("rates").split("\u00a7")).stream().map(SerializableRate::fromString).collect(Collectors.toList()) : new ArrayList<SerializableRate>();
                ArrayList invitedPlayers = rs.getString("invitedPlayers").length() > 0 ? Arrays.asList(rs.getString("invitedPlayers").split("\u00a7")).stream().map(uuidString -> Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(uuidString))).collect(Collectors.toList()) : new ArrayList();
                ArrayList<SerializableBannedPlayer> bannedPlayers = rs.getString("bannedPlayers").length() > 0 ? Arrays.asList(rs.getString("bannedPlayers").split("\u00a7")).stream().map(SerializableBannedPlayer::fromString).collect(Collectors.toList()) : new ArrayList<SerializableBannedPlayer>();
                ArrayList<SerializableLog> logs = rs.getString("logs").length() > 0 ? Arrays.asList(rs.getString("logs").split("\u00b5")).stream().map(SerializableLog::fromString).collect(Collectors.toList()) : new ArrayList<SerializableLog>();
                ArrayList<SerializableSubArea> subAreas = rs.getString("subAreas").length() > 0 ? Arrays.asList(rs.getString("subAreas").split("\u00a7")).stream().map(SerializableSubArea::fromString).collect(Collectors.toList()) : new ArrayList<SerializableSubArea>();
                SerializableRent rent = SerializableRent.fromString(rs.getString("rent"));
                long upkeepAt = rs.getLong("upkeepAt");
                double taxesAmount = rs.getDouble("taxesAmount");
                int weather = rs.getInt("weather");
                int time = rs.getInt("time");
                SerializableLocation welcomeSign = rs.getString("welcomeSign") == null ? null : SerializableLocation.fromString(rs.getString("welcomeSign"));
                String string = icon = rs.getString("icon") == null ? null : rs.getString("icon");
                if (owner == null) continue;
                Region region = new Region(name, owner);
                region.id = id;
                region.displayName = displayName;
                region.description = description;
                region.location = location;
                region.createdAt = createdAt;
                region.playerFlags = playerFlags;
                region.worldFlags = worldFlags;
                region.bank = bank;
                region.mapColor = mapColor;
                region.setChunks(chunks);
                region.setMembers(members);
                region.setRates(rates);
                region.setInvitedPlayers(ListUtils.removeNullElements(invitedPlayers));
                region.setBannedPlayers(bannedPlayers);
                region.setLogs(logs);
                region.setSubAreas(subAreas);
                region.rent = rent;
                region.upkeepAt = upkeepAt;
                region.taxesAmount = taxesAmount;
                region.weather = weather;
                region.time = time;
                region.welcomeSign = welcomeSign;
                region.icon = icon;
                Homestead.regionsCache.putOrUpdate(region);
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.regionsCache.size() + " regions.");
    }

    public void importWars() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.warsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("displayName");
                String name = rs.getString("name");
                String description = rs.getString("description");
                ArrayList<UUID> regions = rs.getString("regions").length() > 0 ? Arrays.asList(rs.getString("regions").split("\u00a7")).stream().map(UUID::fromString).collect(Collectors.toList()) : new ArrayList<UUID>();
                double prize = rs.getDouble("prize");
                long startedAt = rs.getLong("startedAt");
                War war = new War(name, regions);
                war.id = id;
                war.displayName = displayName;
                war.description = description;
                war.prize = prize;
                war.startedAt = startedAt;
                Homestead.warsCache.putOrUpdate(war);
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.warsCache.size() + " wars.");
    }

    public void exportRegions() {
        HashSet<UUID> dbRegionIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbRegionIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
            return;
        }
        String upsertSql = "INSERT INTO " + this.TABLE_PREFIX + "regions (id, displayName, name, description, ownerId, location, createdAt, playerFlags, worldFlags, bank, mapColor, chunks, members, rates, invitedPlayers, bannedPlayers, subAreas, logs, rent, upkeepAt, taxesAmount, weather, time, welcomeSign, icon) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE displayName = VALUES(displayName), name = VALUES(name), description = VALUES(description), ownerId = VALUES(ownerId), location = VALUES(location), createdAt = VALUES(createdAt), playerFlags = VALUES(playerFlags), worldFlags = VALUES(worldFlags), bank = VALUES(bank), mapColor = VALUES(mapColor), chunks = VALUES(chunks), members = VALUES(members), rates = VALUES(rates), invitedPlayers = VALUES(invitedPlayers), bannedPlayers = VALUES(bannedPlayers), subAreas = VALUES(subAreas), logs = VALUES(logs), rent = VALUES(rent), upkeepAt = VALUES(upkeepAt), taxesAmount = VALUES(taxesAmount), weather = VALUES(weather), time = VALUES(time), welcomeSign = VALUES(welcomeSign), icon = VALUES(icon)";
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "regions WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheRegionIds = new HashSet<UUID>();
            for (Region region : Homestead.regionsCache.getAll()) {
                UUID regionId = region.id;
                cacheRegionIds.add(regionId);
                String chunksStr = String.join((CharSequence)"\u00a7", region.chunks.stream().map(SerializableChunk::toString).collect(Collectors.toList()));
                String membersStr = String.join((CharSequence)"\u00a7", region.members.stream().map(SerializableMember::toString).collect(Collectors.toList()));
                String ratesStr = String.join((CharSequence)"\u00a7", region.rates.stream().map(SerializableRate::toString).collect(Collectors.toList()));
                String invitedStr = String.join((CharSequence)"\u00a7", region.getInvitedPlayers().stream().map(OfflinePlayer::getUniqueId).map(UUID::toString).collect(Collectors.toList()));
                String bannedStr = String.join((CharSequence)"\u00a7", region.bannedPlayers.stream().map(SerializableBannedPlayer::toString).collect(Collectors.toList()));
                String logsStr = String.join((CharSequence)"\u00b5", region.logs.stream().map(SerializableLog::toString).collect(Collectors.toList()));
                String subAreasStr = String.join((CharSequence)"\u00a7", region.subAreas.stream().map(SerializableSubArea::toString).collect(Collectors.toList()));
                upsertStmt.setString(1, regionId.toString());
                upsertStmt.setString(2, region.displayName);
                upsertStmt.setString(3, region.name);
                upsertStmt.setString(4, region.description);
                upsertStmt.setString(5, region.getOwner().getUniqueId().toString());
                upsertStmt.setString(6, region.location != null ? region.location.toString() : null);
                upsertStmt.setLong(7, region.createdAt);
                upsertStmt.setLong(8, region.playerFlags);
                upsertStmt.setLong(9, region.worldFlags);
                upsertStmt.setDouble(10, region.bank);
                upsertStmt.setInt(11, region.mapColor);
                upsertStmt.setString(12, chunksStr);
                upsertStmt.setString(13, membersStr);
                upsertStmt.setString(14, ratesStr);
                upsertStmt.setString(15, invitedStr);
                upsertStmt.setString(16, bannedStr);
                upsertStmt.setString(17, subAreasStr);
                upsertStmt.setString(18, logsStr);
                upsertStmt.setString(19, region.rent != null ? region.rent.toString() : null);
                upsertStmt.setLong(20, region.upkeepAt);
                upsertStmt.setDouble(21, region.taxesAmount);
                upsertStmt.setInt(22, region.weather);
                upsertStmt.setInt(23, region.time);
                upsertStmt.setString(24, region.welcomeSign != null ? region.welcomeSign.toString() : null);
                upsertStmt.setString(25, region.icon != null ? region.icon : null);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbRegionIds.removeAll(cacheRegionIds);
            for (UUID deletedId : dbRegionIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheRegionIds.size() + " regions and deleted " + dbRegionIds.size() + " regions.");
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
    }

    public void exportWars() {
        HashSet<UUID> dbWarIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbWarIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
            return;
        }
        String upsertSql = "INSERT INTO " + this.TABLE_PREFIX + "wars (id, displayName, name, description, regions, prize, startedAt) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE displayName = VALUES(displayName), name = VALUES(name), description = VALUES(description), regions = VALUES(regions), prize = VALUES(prize), startedAt = VALUES(startedAt)";
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "wars WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheWarIds = new HashSet<UUID>();
            for (War war : Homestead.warsCache.getAll()) {
                UUID warId = war.id;
                cacheWarIds.add(warId);
                String regionsStr = String.join((CharSequence)"\u00a7", war.regions.stream().map(UUID::toString).collect(Collectors.toList()));
                upsertStmt.setString(1, warId.toString());
                upsertStmt.setString(2, war.displayName);
                upsertStmt.setString(3, war.name);
                upsertStmt.setString(4, war.description);
                upsertStmt.setString(5, regionsStr);
                upsertStmt.setDouble(6, war.prize);
                upsertStmt.setLong(7, war.startedAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbWarIds.removeAll(cacheWarIds);
            for (UUID deletedId : dbWarIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheWarIds.size() + " wars and deleted " + dbWarIds.size() + " wars.");
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Logger.warning("Connection for MySQL has been closed.");
            }
        }
        catch (SQLException e) {
            Logger.error("An unexpected error occurred for the provider: " + Homestead.database.getSelectedProvider());
            e.printStackTrace();
        }
    }

    public long getLatency() {
        long before = System.currentTimeMillis();
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
            }
        }
        catch (SQLException e) {
            return -1L;
        }
        long after = System.currentTimeMillis();
        return after - before;
    }
}

