/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;

public class MariaDB {
    private final String TABLE_PREFIX;
    private static final String JDBC_URL = "jdbc:mariadb://";
    private Connection connection;

    public MariaDB(String username, String password, String host, int port, String database, String tablePrefix) {
        this(username, password, host, port, database, tablePrefix, false);
    }

    public MariaDB(String username, String password, String host, int port, String database, String tablePrefix, boolean handleError) {
        block4: {
            this.TABLE_PREFIX = tablePrefix.replaceAll("[^A-Za-z0-9_]", "");
            try {
                Class.forName("org.mariadb.jdbc.Driver");
                String connectionUrl = JDBC_URL + host + ":" + port + "/" + database + "?allowPublicKeyRetrieval=true&useSSL=false&serverTimezone=UTC";
                this.connection = DriverManager.getConnection(connectionUrl, username, password);
                Logger.info("MariaDB database connection established.");
                this.createTablesIfNotExists();
                this.createWarsTableIfNotExists();
            }
            catch (ClassNotFoundException e) {
                Logger.error("MariaDB JDBC Driver not found.");
                e.printStackTrace();
                if (!handleError) {
                    Homestead.getInstance().endInstance();
                }
            }
            catch (SQLException e) {
                Logger.error("Unable to establish connection to MariaDB.");
                e.printStackTrace();
                if (handleError) break block4;
                Homestead.getInstance().endInstance();
            }
        }
    }

    public void createTablesIfNotExists() {
        String sql = "    CREATE TABLE IF NOT EXISTS `%sregions` (\n        id              CHAR(36) PRIMARY KEY,\n        display_name    TEXT NOT NULL,\n        name            TEXT NOT NULL,\n        description     TEXT NOT NULL,\n        owner_id        CHAR(36) NOT NULL,\n        location        TEXT,\n        created_at      BIGINT NOT NULL,\n        player_flags    BIGINT NOT NULL,\n        world_flags     BIGINT NOT NULL,\n        bank            DOUBLE PRECISION NOT NULL,\n        map_color       INT NOT NULL,\n        chunks          TEXT NOT NULL,\n        members         TEXT NOT NULL,\n        rates           TEXT NOT NULL,\n        invited_players TEXT NOT NULL,\n        banned_players  TEXT NOT NULL,\n        sub_areas       TEXT NOT NULL,\n        logs            TEXT NOT NULL,\n        rent            TEXT,\n        upkeep_at       BIGINT NOT NULL,\n        taxes_amount    DOUBLE NOT NULL,\n        weather         INT NOT NULL,\n        time            INT NOT NULL,\n        welcome_sign    TEXT,\n        icon            TEXT\n    )\n".formatted(this.TABLE_PREFIX);
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void importRegions() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.regionsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                OfflinePlayer owner = Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(rs.getString("owner_id")));
                SerializableLocation location = Optional.ofNullable(rs.getString("location")).map(SerializableLocation::fromString).orElse(null);
                long createdAt = rs.getLong("created_at");
                long playerFlags = rs.getLong("player_flags");
                long worldFlags = rs.getLong("world_flags");
                double bank = rs.getDouble("bank");
                int mapColor = rs.getInt("map_color");
                ArrayList<SerializableChunk> chunks = !rs.getString("chunks").isEmpty() ? Arrays.stream(rs.getString("chunks").split("\u00a7")).map(SerializableChunk::fromString).collect(Collectors.toList()) : new ArrayList<SerializableChunk>();
                ArrayList<SerializableMember> members = !rs.getString("members").isEmpty() ? Arrays.stream(rs.getString("members").split("\u00a7")).map(SerializableMember::fromString).collect(Collectors.toList()) : new ArrayList<SerializableMember>();
                ArrayList<SerializableRate> rates = !rs.getString("rates").isEmpty() ? Arrays.stream(rs.getString("rates").split("\u00a7")).map(SerializableRate::fromString).collect(Collectors.toList()) : new ArrayList<SerializableRate>();
                ArrayList invitedPlayers = !rs.getString("invited_players").isEmpty() ? Arrays.stream(rs.getString("invited_players").split("\u00a7")).map(uuidString -> Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(uuidString))).collect(Collectors.toList()) : new ArrayList();
                ArrayList<SerializableBannedPlayer> bannedPlayers = !rs.getString("banned_players").isEmpty() ? Arrays.stream(rs.getString("banned_players").split("\u00a7")).map(SerializableBannedPlayer::fromString).collect(Collectors.toList()) : new ArrayList<SerializableBannedPlayer>();
                ArrayList<SerializableLog> logs = !rs.getString("logs").isEmpty() ? Arrays.stream(rs.getString("logs").split("\u00b5")).map(SerializableLog::fromString).collect(Collectors.toList()) : new ArrayList<SerializableLog>();
                ArrayList<SerializableSubArea> subAreas = !rs.getString("sub_areas").isEmpty() ? Arrays.stream(rs.getString("sub_areas").split("\u00a7")).map(SerializableSubArea::fromString).collect(Collectors.toList()) : new ArrayList<SerializableSubArea>();
                SerializableRent rent = SerializableRent.fromString(rs.getString("rent"));
                long upkeepAt = rs.getLong("upkeep_at");
                double taxesAmount = rs.getDouble("taxes_amount");
                int weather = rs.getInt("weather");
                int time = rs.getInt("time");
                SerializableLocation welcomeSign = Optional.ofNullable(rs.getString("welcome_sign")).map(SerializableLocation::fromString).orElse(null);
                String icon = rs.getString("icon");
                if (owner == null) continue;
                Region region = new Region(name, owner);
                region.id = id;
                region.displayName = displayName;
                region.description = description;
                region.location = location;
                region.createdAt = createdAt;
                region.playerFlags = playerFlags;
                region.worldFlags = worldFlags;
                region.bank = bank;
                region.mapColor = mapColor;
                region.setChunks(chunks);
                region.setMembers(members);
                region.setRates(rates);
                region.setInvitedPlayers(ListUtils.removeNullElements(invitedPlayers));
                region.setBannedPlayers(bannedPlayers);
                region.setLogs(logs);
                region.setSubAreas(subAreas);
                region.rent = rent;
                region.upkeepAt = upkeepAt;
                region.taxesAmount = taxesAmount;
                region.weather = weather;
                region.time = time;
                region.welcomeSign = welcomeSign;
                region.icon = icon;
                Homestead.regionsCache.putOrUpdate(region);
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to import regions from MariaDB.");
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.regionsCache.size() + " regions from MariaDB.");
    }

    public void createWarsTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS `%swars` (\n    id          CHAR(36) PRIMARY KEY,\n    display_name TEXT NOT NULL,\n    name        TEXT NOT NULL,\n    description TEXT NOT NULL,\n    regions     TEXT NOT NULL,\n    prize       DOUBLE PRECISION NOT NULL,\n    started_at  BIGINT NOT NULL\n)\n".formatted(this.TABLE_PREFIX);
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            Logger.error("Unable to create wars table in MariaDB.");
            e.printStackTrace();
        }
    }

    public void importWars() {
        String sql = "SELECT * FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            Homestead.warsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                ArrayList<UUID> regions = !rs.getString("regions").isEmpty() ? Arrays.stream(rs.getString("regions").split("\u00a7")).map(UUID::fromString).collect(Collectors.toList()) : new ArrayList<UUID>();
                double prize = rs.getDouble("prize");
                long startedAt = rs.getLong("started_at");
                War war = new War(name, regions);
                war.id = id;
                war.displayName = displayName;
                war.description = description;
                war.prize = prize;
                war.startedAt = startedAt;
                Homestead.warsCache.putOrUpdate(war);
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to import wars from MariaDB.");
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.warsCache.size() + " wars from MariaDB.");
    }

    public void exportRegions() {
        HashSet<UUID> dbRegionIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbRegionIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to fetch region IDs from MariaDB.");
            e.printStackTrace();
            return;
        }
        String upsertSql = "    INSERT INTO `%sregions` (\n        id, display_name, name, description, owner_id, location, created_at,\n        player_flags, world_flags, bank, map_color, chunks, members, rates,\n        invited_players, banned_players, sub_areas, logs, rent, upkeep_at,\n        taxes_amount, weather, time, welcome_sign, icon\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        display_name = VALUES(display_name),\n        name = VALUES(name),\n        description = VALUES(description),\n        owner_id = VALUES(owner_id),\n        location = VALUES(location),\n        created_at = VALUES(created_at),\n        player_flags = VALUES(player_flags),\n        world_flags = VALUES(world_flags),\n        bank = VALUES(bank),\n        map_color = VALUES(map_color),\n        chunks = VALUES(chunks),\n        members = VALUES(members),\n        rates = VALUES(rates),\n        invited_players = VALUES(invited_players),\n        banned_players = VALUES(banned_players),\n        sub_areas = VALUES(sub_areas),\n        logs = VALUES(logs),\n        rent = VALUES(rent),\n        upkeep_at = VALUES(upkeep_at),\n        taxes_amount = VALUES(taxes_amount),\n        weather = VALUES(weather),\n        time = VALUES(time),\n        welcome_sign = VALUES(welcome_sign),\n        icon = VALUES(icon)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "regions WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheRegionIds = new HashSet<UUID>();
            for (Region region : Homestead.regionsCache.getAll()) {
                UUID regionId = region.id;
                cacheRegionIds.add(regionId);
                upsertStmt.setString(1, regionId.toString());
                upsertStmt.setString(2, region.displayName);
                upsertStmt.setString(3, region.name);
                upsertStmt.setString(4, region.description);
                upsertStmt.setString(5, region.getOwnerId().toString());
                upsertStmt.setString(6, region.location == null ? null : region.location.toString());
                upsertStmt.setLong(7, region.createdAt);
                upsertStmt.setLong(8, region.playerFlags);
                upsertStmt.setLong(9, region.worldFlags);
                upsertStmt.setDouble(10, region.bank);
                upsertStmt.setInt(11, region.mapColor);
                String chunksStr = String.join((CharSequence)"\u00a7", region.chunks.stream().map(SerializableChunk::toString).collect(Collectors.toList()));
                String membersStr = String.join((CharSequence)"\u00a7", region.members.stream().map(SerializableMember::toString).collect(Collectors.toList()));
                String ratesStr = String.join((CharSequence)"\u00a7", region.rates.stream().map(SerializableRate::toString).collect(Collectors.toList()));
                String invitedStr = String.join((CharSequence)"\u00a7", region.getInvitedPlayers().stream().map(OfflinePlayer::getUniqueId).map(UUID::toString).collect(Collectors.toList()));
                String bannedStr = String.join((CharSequence)"\u00a7", region.bannedPlayers.stream().map(SerializableBannedPlayer::toString).collect(Collectors.toList()));
                String logsStr = String.join((CharSequence)"\u00b5", region.logs.stream().map(SerializableLog::toString).collect(Collectors.toList()));
                String subAreasStr = String.join((CharSequence)"\u00a7", region.subAreas.stream().map(SerializableSubArea::toString).collect(Collectors.toList()));
                upsertStmt.setString(12, chunksStr);
                upsertStmt.setString(13, membersStr);
                upsertStmt.setString(14, ratesStr);
                upsertStmt.setString(15, invitedStr);
                upsertStmt.setString(16, bannedStr);
                upsertStmt.setString(17, subAreasStr);
                upsertStmt.setString(18, logsStr);
                upsertStmt.setString(19, region.rent == null ? null : region.rent.toString());
                upsertStmt.setLong(20, region.upkeepAt);
                upsertStmt.setDouble(21, region.taxesAmount);
                upsertStmt.setInt(22, region.weather);
                upsertStmt.setInt(23, region.time);
                upsertStmt.setString(24, region.welcomeSign == null ? null : region.welcomeSign.toString());
                upsertStmt.setString(25, region.icon);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbRegionIds.removeAll(cacheRegionIds);
            for (UUID deletedId : dbRegionIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheRegionIds.size() + " regions and deleted " + dbRegionIds.size() + " regions from MariaDB.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to export regions to MariaDB.");
            e.printStackTrace();
        }
    }

    public void exportWars() {
        HashSet<UUID> dbWarIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM " + this.TABLE_PREFIX + "wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSql);){
            while (rs.next()) {
                dbWarIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to fetch war IDs from MariaDB.");
            e.printStackTrace();
            return;
        }
        String upsertSql = "INSERT INTO `%swars` (\n    id, display_name, name, description, regions, prize, started_at\n) VALUES (?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    display_name = VALUES(display_name),\n    name = VALUES(name),\n    description = VALUES(description),\n    regions = VALUES(regions),\n    prize = VALUES(prize),\n    started_at = VALUES(started_at)\n".formatted(this.TABLE_PREFIX);
        String deleteSql = "DELETE FROM " + this.TABLE_PREFIX + "wars WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement(upsertSql);
             PreparedStatement deleteStmt = this.connection.prepareStatement(deleteSql);){
            HashSet<UUID> cacheWarIds = new HashSet<UUID>();
            for (War war : Homestead.warsCache.getAll()) {
                UUID warId = war.id;
                cacheWarIds.add(warId);
                String regionsStr = String.join((CharSequence)"\u00a7", war.regions.stream().map(UUID::toString).collect(Collectors.toList()));
                upsertStmt.setString(1, warId.toString());
                upsertStmt.setString(2, war.displayName);
                upsertStmt.setString(3, war.name);
                upsertStmt.setString(4, war.description);
                upsertStmt.setString(5, regionsStr);
                upsertStmt.setDouble(6, war.prize);
                upsertStmt.setLong(7, war.startedAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbWarIds.removeAll(cacheWarIds);
            for (UUID deletedId : dbWarIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheWarIds.size() + " wars and deleted " + dbWarIds.size() + " wars from MariaDB.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to export wars to MariaDB.");
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Logger.warning("MariaDB connection has been closed.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to close MariaDB connection.");
            e.printStackTrace();
        }
    }

    public long getLatency() {
        long before = System.currentTimeMillis();
        String sql = "SELECT 1 FROM `%sregions` LIMIT 1".formatted(this.TABLE_PREFIX);
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
            }
        }
        catch (SQLException e) {
            return -1L;
        }
        return System.currentTimeMillis() - before;
    }
}

