/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.postgresql.core.FixedLengthOutputStream;
import org.postgresql.core.v3.SqlSerializationContext;
import org.postgresql.util.ByteStreamWriter;
import org.postgresql.util.GT;
import org.postgresql.util.StreamWrapper;

public class PGbytea {
    private static final int MAX_3_BUFF_SIZE = 0x200000;
    private static final int[] HEX_VALS;

    public static byte @PolyNull [] toBytes(byte @PolyNull [] s2) throws SQLException {
        if (s2 == null) {
            return null;
        }
        if (s2.length < 2 || s2[0] != 92 || s2[1] != 120) {
            return PGbytea.toBytesOctalEscaped(s2);
        }
        return PGbytea.toBytesHexEscaped(s2);
    }

    private static byte[] toBytesHexEscaped(byte[] s2) {
        int realLength = s2.length - 2;
        byte[] output = new byte[realLength >>> 1];
        for (int i = 0; i < realLength; i += 2) {
            int val = PGbytea.getHex(s2[2 + i]) << 4;
            output[i >>> 1] = (byte)(val |= PGbytea.getHex(s2[3 + i]));
        }
        return output;
    }

    private static int getHex(byte b) {
        return HEX_VALS[b - 48];
    }

    private static byte[] toBytesOctalEscaped(byte[] s2) {
        int slength = s2.length;
        byte[] buf = null;
        int correctSize = slength;
        if (slength > 0x200000) {
            for (int i = 0; i < slength; ++i) {
                byte next;
                byte current = s2[i];
                if (current != 92) continue;
                if ((next = s2[++i]) == 92) {
                    --correctSize;
                    continue;
                }
                correctSize -= 3;
            }
            buf = new byte[correctSize];
        } else {
            buf = new byte[slength];
        }
        int bufpos = 0;
        for (int i = 0; i < slength; ++i) {
            byte nextbyte = s2[i];
            if (nextbyte == 92) {
                int thebyte;
                byte secondbyte;
                if ((secondbyte = s2[++i]) == 92) {
                    buf[bufpos++] = 92;
                    continue;
                }
                if ((thebyte = (secondbyte - 48) * 64 + (s2[++i] - 48) * 8 + (s2[++i] - 48)) > 127) {
                    thebyte -= 256;
                }
                buf[bufpos++] = (byte)thebyte;
                continue;
            }
            buf[bufpos++] = nextbyte;
        }
        if (bufpos == correctSize) {
            return buf;
        }
        byte[] result = new byte[bufpos];
        System.arraycopy(buf, 0, result, 0, bufpos);
        return result;
    }

    public static @PolyNull String toPGString(byte @PolyNull [] buf) {
        if (buf == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 + 2 * buf.length);
        stringBuilder.append("\\x");
        PGbytea.appendHexString(stringBuilder, buf, 0, buf.length);
        return stringBuilder.toString();
    }

    public static void appendHexString(StringBuilder sb, byte[] buf, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            byte element = buf[i];
            sb.append(Character.forDigit(element >> 4 & 0xF, 16));
            sb.append(Character.forDigit(element & 0xF, 16));
        }
    }

    @Deprecated
    public static String toPGLiteral(Object value) throws IOException {
        return PGbytea.toPGLiteral(value, SqlSerializationContext.of(true, true));
    }

    public static String toPGLiteral(Object value, SqlSerializationContext context) throws IOException {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            StringBuilder sb = new StringBuilder(bytes.length * 2 + 11);
            sb.append("'\\x");
            PGbytea.appendHexString(sb, bytes, 0, bytes.length);
            sb.append("'::bytea");
            return sb.toString();
        }
        if (value instanceof StreamWrapper) {
            int length;
            StreamWrapper sw = (StreamWrapper)value;
            byte[] bytes = sw.getBytes();
            if (context.getIdempotent() && bytes == null) {
                return "?";
            }
            StringBuilder sb = new StringBuilder(length * 2 + 11);
            sb.append("'\\x");
            if (bytes != null) {
                PGbytea.appendHexString(sb, bytes, sw.getOffset(), length);
            } else if (length > 0) {
                int read;
                InputStream str = sw.getStream();
                byte[] streamBuffer = new byte[8192];
                for (length = sw.getLength(); length > 0 && (read = str.read(streamBuffer, 0, Math.min(length, streamBuffer.length))) != -1; length -= read) {
                    PGbytea.appendHexString(sb, streamBuffer, 0, read);
                }
                if (length > 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", sw.getLength(), sw.getLength() - length));
                }
            }
            sb.append("'::bytea");
            return sb.toString();
        }
        if (value instanceof ByteStreamWriter) {
            ByteStreamWriter bsw = (ByteStreamWriter)value;
            int len = bsw.getLength();
            final StringBuilder sb = new StringBuilder(len * 2 + 11);
            sb.append("'\\x");
            FixedLengthOutputStream str = new FixedLengthOutputStream(len, new OutputStream(){

                @Override
                public void write(int b) {
                    sb.append(Character.forDigit(b >> 4 & 0xF, 16));
                    sb.append(Character.forDigit(b & 0xF, 16));
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    PGbytea.appendHexString(sb, b, off, len);
                }
            });
            bsw.writeTo(() -> str);
            for (int i = 0; i < str.remaining(); ++i) {
                sb.append("00");
            }
            sb.append("'::bytea");
            return sb.toString();
        }
        throw new IllegalArgumentException(GT.tr("Can't convert {0} to {1} literal", value.getClass(), "bytea"));
    }

    static {
        int i;
        HEX_VALS = new int[55];
        for (i = 0; i < 10; ++i) {
            PGbytea.HEX_VALS[i] = (byte)i;
        }
        for (i = 0; i < 6; ++i) {
            PGbytea.HEX_VALS[65 + i - 48] = (byte)(10 + i);
            PGbytea.HEX_VALS[97 + i - 48] = (byte)(10 + i);
        }
    }
}

