/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle.BMUtils.BMNative;

import com.technicjelle.BMUtils.BMNative.BMNMetadata;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BMNConfigDirectory {
    private BMNConfigDirectory() {
        throw new IllegalStateException("Utility class");
    }

    public static Path getAllocatedDirectory(BlueMapAPI api, ClassLoader classLoader) throws IOException {
        return BMNConfigDirectory.getServerConfigDirectory(api).resolve(BMNMetadata.getAddonID(classLoader));
    }

    public static Path getServerConfigDirectory(BlueMapAPI api) {
        BlueMapAPIImpl apiImpl = (BlueMapAPIImpl)api;
        @Nullable Plugin plugin = apiImpl.plugin();
        if (plugin == null) {
            return Path.of(".", new String[0]);
        }
        return plugin.getServerInterface().getConfigFolder().getParent();
    }

    public static Path getPacksDirectory(BlueMapAPI api) {
        BlueMapAPIImpl apiImpl = (BlueMapAPIImpl)api;
        @Nullable Plugin plugin = apiImpl.plugin();
        if (plugin == null) {
            return Path.of(".", "config", "packs");
        }
        return plugin.getServerInterface().getConfigFolder().resolve("packs");
    }

    public static class BMNCopy {
        private BMNCopy() {
            throw new IllegalStateException("Utility class");
        }

        public static void fromStream(@NotNull BlueMapAPI blueMapAPI, @NotNull ClassLoader classLoader, @NotNull InputStream in, @NotNull String toFile, boolean overwrite) throws IOException {
            Path configDirectory = BMNConfigDirectory.getAllocatedDirectory(blueMapAPI, classLoader);
            Path toPath = configDirectory.resolve(toFile);
            if (Files.exists(toPath, new LinkOption[0]) && !overwrite) {
                return;
            }
            Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(toPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                in.transferTo(out);
            }
        }

        public static void fromFile(@NotNull BlueMapAPI blueMapAPI, @NotNull ClassLoader classLoader, @NotNull Path from, @NotNull String toFile, boolean overwrite) throws IOException {
            try (InputStream in = Files.newInputStream(from, new OpenOption[0]);){
                BMNCopy.fromStream(blueMapAPI, classLoader, in, toFile, overwrite);
            }
        }

        public static void fromJarResource(@NotNull BlueMapAPI blueMapAPI, @NotNull ClassLoader classLoader, @NotNull String fromResource, @NotNull String toFile, boolean overwrite) throws IOException {
            try (InputStream in = classLoader.getResourceAsStream(fromResource);){
                if (in == null) {
                    throw new IOException("Resource not found: " + fromResource);
                }
                BMNCopy.fromStream(blueMapAPI, classLoader, in, toFile, overwrite);
            }
        }
    }
}

