/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.chunks;

import java.lang.runtime.SwitchBootstraps;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.borders.BorderBlockRenderer;
import tfagaming.projects.minecraft.homestead.borders.ChunkParticlesSpawner;
import tfagaming.projects.minecraft.homestead.borders.SelectedAreaParticlesSpawner;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;

public class ChunkBorder {
    public static BorderType getMethod() {
        String type;
        boolean isEnabled = (Boolean)Homestead.config.get("borders.enabled");
        if (!isEnabled) {
            return null;
        }
        return switch (type = (String)Homestead.config.get("borders.type")) {
            case "particles" -> BorderType.PARTICLES;
            case "blocks" -> BorderType.BLOCKS;
            default -> null;
        };
    }

    public static Material getBlockType() {
        String blockType = (String)Homestead.config.get("borders.block-type");
        return Material.getMaterial((String)blockType) == null ? Material.GOLD_BLOCK : Material.getMaterial((String)blockType);
    }

    public static void stop(Player player) {
        BorderBlockRenderer.removeAll(player);
        ChunkParticlesSpawner.cancelTask(player);
        SelectedAreaParticlesSpawner.cancelTask(player);
    }

    public static void show(Player player) {
        BorderType borderType;
        Region region = ChunksManager.getRegionOwnsTheChunk(player.getLocation().getChunk());
        SerializableSubArea subArea = null;
        if (region != null) {
            subArea = region.findSubAreaHasLocationInside(player.getLocation());
        }
        ChunkBorder.stop(player);
        BorderType borderType2 = borderType = ChunkBorder.getMethod();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"PARTICLES", "BLOCKS"}, (BorderType)borderType2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                if (region == null) {
                    new ChunkParticlesSpawner(player);
                    break;
                }
                if (subArea != null) {
                    new SelectedAreaParticlesSpawner(player, subArea.getFirstPoint(), subArea.getSecondPoint());
                    break;
                }
                new ChunkParticlesSpawner(player);
                break;
            }
            case 1: {
                if (region == null) break;
                if (subArea != null) {
                    new SelectedAreaParticlesSpawner(player, subArea.getFirstPoint(), subArea.getSecondPoint());
                    break;
                }
                BorderBlockRenderer.show(player, region);
            }
            case -1: 
        }
    }

    public static enum BorderType {
        PARTICLES,
        BLOCKS;

    }
}

