/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure.serializable;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;

public class SerializableRate {
    private UUID playerId;
    private int rate;
    private final long ratedAt;

    public SerializableRate(OfflinePlayer player) {
        this.playerId = player.getUniqueId();
        this.rate = 0;
        this.ratedAt = System.currentTimeMillis();
    }

    public SerializableRate(OfflinePlayer player, int rate) {
        this.playerId = player.getUniqueId();
        this.rate = rate;
        this.ratedAt = System.currentTimeMillis();
    }

    public SerializableRate(OfflinePlayer player, int rate, long ratedAt) {
        this.playerId = player.getUniqueId();
        this.rate = rate;
        this.ratedAt = ratedAt;
    }

    public SerializableRate(UUID playerId, int rate, long ratedAt) {
        this.playerId = playerId;
        this.rate = rate;
        this.ratedAt = ratedAt;
    }

    public static SerializableRate fromString(String string) {
        String[] splitted = string.split(",");
        return new SerializableRate(UUID.fromString(splitted[0]), Integer.parseInt(splitted[1]), Long.parseLong(splitted[2]));
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public long getRatedAt() {
        return this.ratedAt;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public String toString() {
        return String.valueOf(this.playerId) + "," + this.rate + "," + this.ratedAt;
    }

    public OfflinePlayer getBukkitOfflinePlayer() {
        return Homestead.getInstance().getOfflinePlayerSync(this.playerId);
    }
}

