/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public final class WorldFlags {
    public static final long PASSIVE_ENTITIES_SPAWN = 1L;
    public static final long HOSTILE_ENTITIES_SPAWN = 2L;
    public static final long ENTITIES_GRIEF = 4L;
    public static final long ENTITIES_DAMAGE_ENTITIES = 8L;
    public static final long LEAVES_DECAY = 16L;
    public static final long FIRE_SPREAD = 32L;
    public static final long LIQUID_FLOW = 64L;
    public static final long EXPLOSIONS_DAMAGE = 128L;
    public static final long WITHER_DAMAGE = 256L;
    public static final long WILDERNESS_PISTONS = 512L;
    public static final long WILDERNESS_DISPENSERS = 1024L;
    public static final long WILDERNESS_MINECARTS = 2048L;
    public static final long PLANT_GROWTH = 4096L;
    public static final long GRASS_GROWTH = 8192L;
    public static final long SCULK_SPREAD = 16384L;
    public static final long PLAYER_GLOWING = 32768L;
    public static final long SNOW_MELTING = 65536L;
    public static final long ICE_MELTING = 131072L;
    public static final long SNOWMAN_TRAILS = 262144L;
    public static final long WINDCHARGE_BURST = 524288L;
    public static final long WILDERNESS_COPPER_GOLEMS = 0x100000L;
    public static final long WARS = 0x200000L;
    public static final Map<String, Long> MAPPED_FLAGS = new LinkedHashMap<String, Long>();

    public static List<String> getFlags() {
        ArrayList<String> flags = new ArrayList<String>(MAPPED_FLAGS.keySet());
        Collections.sort(flags);
        return flags;
    }

    public static long valueOf(String name) {
        Long val = MAPPED_FLAGS.get(name.toLowerCase(Locale.ROOT));
        return val != null ? val : 0L;
    }

    public static String from(long flag) {
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (e.getValue() != flag) continue;
            return e.getKey();
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (!FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            enabled.add(e.getKey());
        }
        return enabled;
    }

    public static List<String> getUnset(long flags) {
        ArrayList<String> disabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            disabled.add(e.getKey());
        }
        return disabled;
    }

    static {
        MAPPED_FLAGS.put("passive-entities-spawn", 1L);
        MAPPED_FLAGS.put("hostile-entities-spawn", 2L);
        MAPPED_FLAGS.put("entities-grief", 4L);
        MAPPED_FLAGS.put("entities-damage-entities", 8L);
        MAPPED_FLAGS.put("leaves-decay", 16L);
        MAPPED_FLAGS.put("fire-spread", 32L);
        MAPPED_FLAGS.put("liquid-flow", 64L);
        MAPPED_FLAGS.put("explosions-damage", 128L);
        MAPPED_FLAGS.put("wither-damage", 256L);
        MAPPED_FLAGS.put("wilderness-pistons", 512L);
        MAPPED_FLAGS.put("wilderness-dispensers", 1024L);
        MAPPED_FLAGS.put("wilderness-minecarts", 2048L);
        MAPPED_FLAGS.put("plant-growth", 4096L);
        MAPPED_FLAGS.put("grass-growth", 8192L);
        MAPPED_FLAGS.put("sculk-spread", 16384L);
        MAPPED_FLAGS.put("player-glowing", 32768L);
        MAPPED_FLAGS.put("snow-melting", 65536L);
        MAPPED_FLAGS.put("ice-melting", 131072L);
        MAPPED_FLAGS.put("snowman-trails", 262144L);
        MAPPED_FLAGS.put("windcharge-burst", 524288L);
        MAPPED_FLAGS.put("wilderness-copper-golems", 0x100000L);
        MAPPED_FLAGS.put("wars", 0x200000L);
    }
}

