/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public final class RegionControlFlags {
    public static final long TRUST_PLAYERS = 1L;
    public static final long UNTRUST_PLAYERS = 2L;
    public static final long BAN_PLAYERS = 4L;
    public static final long UNBAN_PLAYERS = 8L;
    public static final long CLAIM_CHUNKS = 16L;
    public static final long UNCLAIM_CHUNKS = 32L;
    public static final long DEPOSIT_MONEY = 64L;
    public static final long WITHDRAW_MONEY = 128L;
    public static final long SET_GLOBAL_FLAGS = 256L;
    public static final long SET_WORLD_FLAGS = 512L;
    public static final long SET_MEMBER_FLAGS = 1024L;
    public static final long SET_SPAWN = 2048L;
    public static final long MANAGE_SUBAREAS = 4096L;
    public static final long RENAME_REGION = 8192L;
    public static final long SET_DESCRIPTION = 16384L;
    public static final long MANAGE_LOGS = 32768L;
    public static final long KICK_PLAYERS = 65536L;
    public static final long SET_WEATHER_AND_TIME = 131072L;
    public static final Map<String, Long> MAPPED_FLAGS = new LinkedHashMap<String, Long>();

    public static List<String> getFlags() {
        ArrayList<String> flags = new ArrayList<String>(MAPPED_FLAGS.keySet());
        Collections.sort(flags);
        return flags;
    }

    public static long valueOf(String name) {
        Long val = MAPPED_FLAGS.get(name.toLowerCase(Locale.ROOT));
        return val != null ? val : 0L;
    }

    public static String from(long flag) {
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (e.getValue() != flag) continue;
            return e.getKey();
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (!FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            enabled.add(e.getKey());
        }
        return enabled;
    }

    public static List<String> getUnset(long flags) {
        ArrayList<String> disabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            disabled.add(e.getKey());
        }
        return disabled;
    }

    static {
        MAPPED_FLAGS.put("trust-players", 1L);
        MAPPED_FLAGS.put("untrust-players", 2L);
        MAPPED_FLAGS.put("ban-players", 4L);
        MAPPED_FLAGS.put("unban-players", 8L);
        MAPPED_FLAGS.put("claim-chunks", 16L);
        MAPPED_FLAGS.put("unclaim-chunks", 32L);
        MAPPED_FLAGS.put("deposit-money", 64L);
        MAPPED_FLAGS.put("withdraw-money", 128L);
        MAPPED_FLAGS.put("set-global-flags", 256L);
        MAPPED_FLAGS.put("set-world-flags", 512L);
        MAPPED_FLAGS.put("set-member-flags", 1024L);
        MAPPED_FLAGS.put("set-spawn", 2048L);
        MAPPED_FLAGS.put("manage-subareas", 4096L);
        MAPPED_FLAGS.put("rename-region", 8192L);
        MAPPED_FLAGS.put("set-description", 16384L);
        MAPPED_FLAGS.put("manage-logs", 32768L);
        MAPPED_FLAGS.put("kick-players", 65536L);
        MAPPED_FLAGS.put("set-weather-and-time", 131072L);
    }
}

