/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public final class PlayerFlags {
    public static final long BREAK_BLOCKS = 1L;
    public static final long PLACE_BLOCKS = 2L;
    public static final long CONTAINERS = 4L;
    public static final long DOORS = 8L;
    public static final long TRAP_DOORS = 16L;
    public static final long FENCE_GATES = 32L;
    public static final long USE_ANVIL = 64L;
    public static final long REDSTONE = 128L;
    public static final long LEVERS = 256L;
    public static final long BUTTONS = 512L;
    public static final long PRESSURE_PLATES = 1024L;
    public static final long USE_BELLS = 2048L;
    public static final long TRIGGER_TRIPWIRE = 4096L;
    public static final long FROST_WALKER = 8192L;
    public static final long HARVEST_CROPS = 16384L;
    public static final long BLOCK_TRAMPLING = 32768L;
    public static final long GENERAL_INTERACTION = 65536L;
    public static final long ARMOR_STANDS = 131072L;
    public static final long INTERACT_ENTITIES = 262144L;
    public static final long ITEM_FRAME_ROTATION = 524288L;
    public static final long DAMAGE_PASSIVE_ENTITIES = 0x100000L;
    public static final long DAMAGE_HOSTILE_ENTITIES = 0x200000L;
    public static final long TRADE_VILLAGERS = 0x400000L;
    public static final long IGNITE = 0x800000L;
    public static final long VEHICLES = 0x1000000L;
    public static final long TELEPORT_SPAWN = 0x2000000L;
    public static final long PASSTHROUGH = 0x4000000L;
    public static final long PVP = 0x8000000L;
    public static final long TAKE_FALL_DAMAGE = 0x10000000L;
    public static final long TELEPORT = 0x20000000L;
    public static final long THROW_POTIONS = 0x40000000L;
    public static final long PICKUP_ITEMS = 0x80000000L;
    public static final long SLEEP = 0x100000000L;
    public static final long TRIGGER_RAID = 0x200000000L;
    public static final long ELYTRA = 0x400000000L;
    public static final long SPAWN_ENTITIES = 0x800000000L;
    public static final Map<String, Long> MAPPED_FLAGS = new HashMap<String, Long>();

    public static List<String> getFlags() {
        ArrayList<String> flags = new ArrayList<String>(MAPPED_FLAGS.keySet());
        Collections.sort(flags);
        return flags;
    }

    public static long valueOf(String name) {
        Long val = MAPPED_FLAGS.get(name.toLowerCase());
        return val != null ? val : 0L;
    }

    public static String from(long flag) {
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (e.getValue() != flag) continue;
            return e.getKey();
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (!FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            enabled.add(e.getKey());
        }
        return enabled;
    }

    public static List<String> getUnset(long flags) {
        ArrayList<String> disabled = new ArrayList<String>();
        for (Map.Entry<String, Long> e : MAPPED_FLAGS.entrySet()) {
            if (FlagsCalculator.isFlagSet(flags, e.getValue())) continue;
            disabled.add(e.getKey());
        }
        return disabled;
    }

    static {
        MAPPED_FLAGS.put("pvp", 0x8000000L);
        MAPPED_FLAGS.put("passthrough", 0x4000000L);
        MAPPED_FLAGS.put("break-blocks", 1L);
        MAPPED_FLAGS.put("place-blocks", 2L);
        MAPPED_FLAGS.put("containers", 4L);
        MAPPED_FLAGS.put("doors", 8L);
        MAPPED_FLAGS.put("trap-doors", 16L);
        MAPPED_FLAGS.put("fence-gates", 32L);
        MAPPED_FLAGS.put("use-anvil", 64L);
        MAPPED_FLAGS.put("redstone", 128L);
        MAPPED_FLAGS.put("levers", 256L);
        MAPPED_FLAGS.put("buttons", 512L);
        MAPPED_FLAGS.put("pressure-plates", 1024L);
        MAPPED_FLAGS.put("use-bells", 2048L);
        MAPPED_FLAGS.put("trigger-tripwire", 4096L);
        MAPPED_FLAGS.put("frost-walker", 8192L);
        MAPPED_FLAGS.put("harvest-crops", 16384L);
        MAPPED_FLAGS.put("block-trampling", 32768L);
        MAPPED_FLAGS.put("general-interaction", 65536L);
        MAPPED_FLAGS.put("armor-stands", 131072L);
        MAPPED_FLAGS.put("interact-entities", 262144L);
        MAPPED_FLAGS.put("item-frame-rotation", 524288L);
        MAPPED_FLAGS.put("damage-passive-entities", 0x100000L);
        MAPPED_FLAGS.put("damage-hostile-entities", 0x200000L);
        MAPPED_FLAGS.put("trade-villagers", 0x400000L);
        MAPPED_FLAGS.put("ignite", 0x800000L);
        MAPPED_FLAGS.put("vehicles", 0x1000000L);
        MAPPED_FLAGS.put("teleport-spawn", 0x2000000L);
        MAPPED_FLAGS.put("take-fall-damage", 0x10000000L);
        MAPPED_FLAGS.put("teleport", 0x20000000L);
        MAPPED_FLAGS.put("throw-potions", 0x40000000L);
        MAPPED_FLAGS.put("pickup-items", 0x80000000L);
        MAPPED_FLAGS.put("sleep", 0x100000000L);
        MAPPED_FLAGS.put("trigger-raid", 0x200000000L);
        MAPPED_FLAGS.put("elytra", 0x400000000L);
        MAPPED_FLAGS.put("spawn-entities", 0x800000000L);
    }
}

