/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle.BMUtils;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.plugin.SkinProvider;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public class BMSkin {
    private static final String FALLBACK_ICON = "assets/steve.png";

    private BMSkin() {
        throw new IllegalStateException("Utility class");
    }

    public static String getPlayerHeadIconAddress(@NotNull BlueMapAPI blueMapAPI, @NotNull UUID playerUUID, @NotNull BlueMapMap blueMapMap) {
        String assetName = "playerheads/" + String.valueOf(playerUUID) + ".png";
        try {
            if (!blueMapMap.getAssetStorage().assetExists(assetName)) {
                BMSkin.createPlayerHead(blueMapAPI, playerUUID, assetName, blueMapMap);
            }
        }
        catch (IOException e) {
            return FALLBACK_ICON;
        }
        return blueMapMap.getAssetStorage().getAssetUrl(assetName);
    }

    private static void createPlayerHead(@NotNull BlueMapAPI blueMapAPI, @NotNull UUID playerUUID, @NotNull String assetName, @NotNull BlueMapMap map) throws IOException {
        SkinProvider skinProvider = blueMapAPI.getPlugin().getSkinProvider();
        try {
            Optional oImgSkin = skinProvider.load(playerUUID);
            if (oImgSkin.isEmpty()) {
                throw new IOException(String.valueOf(playerUUID) + " doesn't have a skin");
            }
            try (OutputStream out = map.getAssetStorage().writeAsset(assetName);){
                BufferedImage head = blueMapAPI.getPlugin().getPlayerMarkerIconFactory().apply(playerUUID, (BufferedImage)oImgSkin.get());
                ImageIO.write((RenderedImage)head, "png", out);
            }
            catch (IOException e) {
                throw new IOException("Failed to write " + String.valueOf(playerUUID) + "'s head to asset-storage", e);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to load skin for player " + String.valueOf(playerUUID), e);
        }
    }
}

