/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class DelayedTeleport {
    public static ConcurrentHashMap<UUID, BukkitTask> tasks = new ConcurrentHashMap();

    public DelayedTeleport(final Player player, final Location location) {
        if (tasks.containsKey(player.getUniqueId())) {
            return;
        }
        boolean delayedTeleportEnabled = (Boolean)Homestead.config.get("delayed-teleport.enabled");
        if (!delayedTeleportEnabled) {
            this.teleportPlayer(player, location);
            return;
        }
        boolean ignoreOperators = (Boolean)Homestead.config.get("delayed-teleport.ignore-operators");
        if (ignoreOperators && PlayerUtils.isOperator(player)) {
            this.teleportPlayer(player, location);
            return;
        }
        PlayerUtils.sendMessage(player, 53);
        int delay = (Integer)Homestead.config.get("delayed-teleport.delay");
        long ticks = (long)delay * 1000L / 50L;
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                DelayedTeleport.this.teleportPlayer(player, location);
                BukkitTask playerTask = tasks.get(player.getUniqueId());
                if (playerTask != null) {
                    playerTask.cancel();
                    tasks.remove(player.getUniqueId());
                }
            }
        }.runTaskLater((Plugin)Homestead.getInstance(), ticks);
        tasks.put(player.getUniqueId(), task);
    }

    private void teleportPlayer(Player player, Location location) {
        if (location == null) {
            PlayerUtils.sendMessage(player, 52);
            return;
        }
        player.teleport(location);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 500.0f, 1.0f);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{location}", Formatters.formatLocation(location));
        PlayerUtils.sendMessage(player, 51, replacements);
    }
}

