/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.players;

import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;

public class PlayerRewards {
    public static int getChunksByEachMember(OfflinePlayer player) {
        Region region = TargetRegionSession.getRegion(player);
        if (region == null) {
            return 0;
        }
        int chunksPerMember = (Integer)Homestead.config.get("rewards.for-each-member.chunks");
        return region.getMembers().size() * chunksPerMember;
    }

    public static int getChunksByPlayTime(OfflinePlayer player) {
        if (!player.hasPlayedBefore() && !player.isOnline()) {
            return 0;
        }
        long playerMinutes = (long)player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 1200L;
        List rewards = Homestead.config.getConfig().getMapList("rewards.by-playtime");
        int maxChunks = 0;
        for (Map entry : rewards) {
            int min2 = PlayerRewards.getInt(entry, "minutes");
            int hrs = PlayerRewards.getInt(entry, "hours");
            int days = PlayerRewards.getInt(entry, "days");
            int chunks = PlayerRewards.getInt(entry, "chunks");
            long requiredMinutes = (long)min2 + (long)hrs * 60L + (long)days * 24L * 60L;
            if (playerMinutes < requiredMinutes || chunks <= maxChunks) continue;
            maxChunks = chunks;
        }
        return maxChunks;
    }

    private static int getInt(Map<?, ?> map, String key) {
        Object val = map.get(key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return 0;
    }
}

