/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.players;

import java.util.Objects;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerRewards;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class PlayerLimits {
    public static String getString(LimitType limit) {
        switch (limit.ordinal()) {
            case 0: {
                return "regions";
            }
            case 1: {
                return "chunks-per-region";
            }
            case 2: {
                return "members-per-region";
            }
            case 3: {
                return "subareas-per-region";
            }
            case 4: {
                return "max-subarea-volume";
            }
            case 5: {
                return "commands-cooldown";
            }
        }
        return null;
    }

    public static LimitMethod getLimitsMethod() {
        switch ((String)Homestead.config.get("limits.method")) {
            case "static": {
                return LimitMethod.STATIC;
            }
            case "groups": {
                return LimitMethod.GROUPS;
            }
        }
        return LimitMethod.STATIC;
    }

    private static Object getLimitValueByPlayername(OfflinePlayer player, LimitType limit) {
        return Homestead.config.get("player-limits." + player.getName() + "." + PlayerLimits.getString(limit));
    }

    public static int getDefaultLimitValue(OfflinePlayer player, LimitType limit) {
        Object playerLimitByName = PlayerLimits.getLimitValueByPlayername(player, limit);
        if (playerLimitByName != null) {
            return (Integer)playerLimitByName;
        }
        switch (PlayerLimits.getLimitsMethod().ordinal()) {
            case 1: {
                if (PlayerUtils.isOperator(player)) {
                    Object value = Homestead.config.get("limits.static.op." + PlayerLimits.getString(limit));
                    return value == null ? 0 : (Integer)value;
                }
                Object value = Homestead.config.get("limits.static.non-op." + PlayerLimits.getString(limit));
                return value == null ? 0 : (Integer)value;
            }
            case 0: {
                Object value;
                String group = PlayerUtils.getPlayerGroup(player);
                if (group == null) {
                    group = "default";
                }
                return (value = Homestead.config.get("limits.groups." + group + "." + PlayerLimits.getString(limit))) == null ? 0 : (Integer)value;
            }
        }
        return 0;
    }

    public static int getLimitOfPlayer(OfflinePlayer player, LimitType limit) {
        if (Objects.requireNonNull(limit) == LimitType.CHUNKS_PER_REGION) {
            int defChunks = PlayerLimits.getDefaultLimitValue(player, limit);
            boolean rewardsEnabled = (Boolean)Homestead.config.get("rewards.enabled");
            if (rewardsEnabled) {
                return PlayerRewards.getChunksByEachMember(player) + PlayerRewards.getChunksByPlayTime(player) + defChunks;
            }
            return defChunks;
        }
        return PlayerLimits.getDefaultLimitValue(player, limit);
    }

    public static boolean hasPlayerReachedLimit(OfflinePlayer player, LimitType limit) {
        switch (limit.ordinal()) {
            case 0: {
                int current = RegionsManager.getRegionsOwnedByPlayer(player).size();
                int max = PlayerLimits.getLimitOfPlayer(player, limit);
                return current >= max;
            }
            case 1: {
                int max;
                Region region = TargetRegionSession.getRegion(player);
                if (region == null) {
                    return false;
                }
                int current = region.getChunks().size();
                return current >= (max = PlayerLimits.getLimitOfPlayer(player, limit));
            }
            case 2: {
                int max;
                Region region = TargetRegionSession.getRegion(player);
                if (region == null) {
                    return false;
                }
                int current = region.getMembers().size();
                return current >= (max = PlayerLimits.getLimitOfPlayer(player, limit));
            }
            case 3: {
                int max;
                Region region = TargetRegionSession.getRegion(player);
                if (region == null) {
                    return false;
                }
                int current = region.getSubAreas().size();
                return current >= (max = PlayerLimits.getLimitOfPlayer(player, limit));
            }
        }
        return true;
    }

    public static enum LimitType {
        REGIONS,
        CHUNKS_PER_REGION,
        MEMBERS_PER_REGION,
        SUBAREAS_PER_REGION,
        MAX_SUBAREA_VOLUME,
        COMMANDS_COOLDOWN;

    }

    public static enum LimitMethod {
        GROUPS,
        STATIC;

    }
}

