/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.items;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;

public class ItemUtils {
    public static ItemStack getItem(MenuUtils.ButtonData data) {
        return ItemUtils.getItem(data.getName(), data.getLore(), data.getType());
    }

    public static ItemStack getItem(MenuUtils.ButtonData data, Map<String, String> replacements) {
        return ItemUtils.getItem(data.getName(), data.getLore(), data.getType(), replacements);
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack getItem(String displayname, List<String> lore, Material material) {
        ArrayList<String> loreCopy;
        ArrayList<String> arrayList = loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        if (material == null) {
            material = Material.BARRIER;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColorTranslator.translate(displayname));
        if (loreCopy != null) {
            ArrayList<String> lorelist = new ArrayList<String>();
            for (String each : loreCopy) {
                String[] lines;
                for (String string : lines = each.split("\\n")) {
                    void var13_13;
                    if (!string.contains("&")) {
                        String string2 = "&f" + string;
                    }
                    lorelist.add(ChatColorTranslator.translate((String)var13_13));
                }
            }
            meta.setLore(lorelist);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack getItem(String displayname, List<String> lore, Material material, Map<String, String> replacements) {
        ArrayList<String> loreCopy;
        displayname = Formatters.replace(displayname, replacements);
        ArrayList<String> arrayList = loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        if (loreCopy != null) {
            for (int i = 0; i < loreCopy.size(); ++i) {
                String string = (String)loreCopy.get(i);
                string = Formatters.replace(string, replacements);
                loreCopy.set(i, string);
            }
        }
        return ItemUtils.getItem(displayname, loreCopy, material);
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack getPlayerHead(String displayname, List<String> lore, String texture) {
        ArrayList<String> loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        ItemStack item = ItemUtils.getCustomHeadTexture(texture);
        if (item == null || item.getType() != Material.PLAYER_HEAD) {
            throw new IllegalStateException("Failed to create a valid Player Head!");
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColorTranslator.translate(displayname));
        if (loreCopy != null) {
            ArrayList<String> lorelist = new ArrayList<String>();
            for (String each : loreCopy) {
                String[] lines;
                for (String string : lines = each.split("\\n")) {
                    void var13_13;
                    if (!string.contains("&")) {
                        String string2 = "&f" + string;
                    }
                    lorelist.add(ChatColorTranslator.translate((String)var13_13));
                }
            }
            meta.setLore(lorelist);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack getPlayerHead(String displayname, List<String> lore, String texture, Map<String, String> replacements) {
        ArrayList<String> loreCopy;
        displayname = Formatters.replace(displayname, replacements);
        ArrayList<String> arrayList = loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        if (loreCopy != null) {
            for (int i = 0; i < loreCopy.size(); ++i) {
                String string = (String)loreCopy.get(i);
                string = Formatters.replace(string, replacements);
                loreCopy.set(i, string);
            }
        }
        return ItemUtils.getPlayerHead(displayname, loreCopy, texture);
    }

    private static ItemStack getCustomHeadTexture(String texture) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwnerProfile(ItemUtils.getProfile("https://textures.minecraft.net/texture/" + texture));
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private static PlayerProfile getProfile(String url) {
        URL urlobject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        PlayerTextures textures = profile.getTextures();
        try {
            urlobject = URI.create(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlobject);
        profile.setTextures(textures);
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack getPlayerHead(String displayname, List<String> lore, UUID playerId) {
        ArrayList<String> loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        ItemStack item = ItemUtils.getPlayerHeadById(playerId);
        if (item == null || item.getType() != Material.PLAYER_HEAD) {
            throw new IllegalStateException("Failed to create a valid Player Head!");
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColorTranslator.translate(displayname));
        if (loreCopy != null) {
            ArrayList<String> lorelist = new ArrayList<String>();
            for (String string : loreCopy) {
                void var8_8;
                if (!string.contains("&")) {
                    String string2 = "&f" + string;
                }
                lorelist.add(ChatColorTranslator.translate((String)var8_8));
            }
            meta.setLore(lorelist);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack getPlayerHead(String displayname, List<String> lore, UUID playerId, Map<String, String> replacements) {
        ArrayList<String> loreCopy;
        displayname = Formatters.replace(displayname, replacements);
        ArrayList<String> arrayList = loreCopy = lore != null ? new ArrayList<String>(lore) : null;
        if (loreCopy != null) {
            for (int i = 0; i < loreCopy.size(); ++i) {
                String string = (String)loreCopy.get(i);
                string = Formatters.replace(string, replacements);
                loreCopy.set(i, string);
            }
        }
        return ItemUtils.getPlayerHead(displayname, loreCopy, playerId);
    }

    private static ItemStack getPlayerHeadById(UUID playerId) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        OfflinePlayer player = Homestead.getInstance().getOfflinePlayerSync(playerId);
        if (player == null) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        meta.setOwningPlayer(player);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

