/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure.serializable;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class SerializableChunk {
    private String worldName;
    private int x;
    private int z;
    private final long claimedAt;

    public SerializableChunk(Chunk chunk) {
        this.worldName = chunk.getWorld() != null ? chunk.getWorld().getName() : null;
        this.x = chunk.getX();
        this.z = chunk.getZ();
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(String worldName, int x, int z) {
        this.worldName = worldName;
        this.x = x;
        this.z = z;
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(World world, int x, int z) {
        this.worldName = world != null ? world.getName() : null;
        this.x = x;
        this.z = z;
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(String worldName, int x, int z, long claimedAt) {
        this.worldName = worldName;
        this.x = x;
        this.z = z;
        this.claimedAt = claimedAt;
    }

    public static SerializableChunk fromString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            String[] split = string.split(",");
            if (split.length < 3) {
                return null;
            }
            String world = split[0].trim();
            int x = Integer.parseInt(split[1].trim());
            int z = Integer.parseInt(split[2].trim());
            long claimedAt = System.currentTimeMillis();
            if (split.length >= 4 && !split[3].trim().isEmpty()) {
                try {
                    claimedAt = Long.parseLong(split[3].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new SerializableChunk(world, x, z, claimedAt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertToString(Chunk chunk) {
        return chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ() + "," + System.currentTimeMillis();
    }

    public static String convertToString(Chunk chunk, boolean withoutClaimTime) {
        return chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public World getWorld() {
        return this.worldName == null ? null : Bukkit.getWorld((String)this.worldName);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public long getClaimedAt() {
        return this.claimedAt;
    }

    public String toString() {
        return this.worldName + "," + this.x + "," + this.z + "," + this.claimedAt;
    }

    public String toString(boolean withoutClaimTime) {
        return this.worldName + "," + this.x + "," + this.z;
    }

    public Location getBukkitLocation() {
        Location newLocation;
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return null;
        }
        Location location = new Location(world, (double)(this.x * 16 + 8), 64.0, (double)(this.z * 16 + 8));
        location.setY((double)(world.getHighestBlockYAt(location) + 2));
        if (world.getEnvironment() == World.Environment.NETHER && (newLocation = this.findSafeNetherLocation(world, this.x * 16 + 8, this.z * 16 + 8)) != null) {
            location = newLocation;
        }
        return location;
    }

    public Chunk getBukkitChunk() {
        Location loc = this.getBukkitLocation();
        return loc != null ? loc.getChunk() : null;
    }

    private Location findSafeNetherLocation(World world, int x, int z) {
        int maxY;
        int minY = 32;
        for (int y = maxY = 124; y >= minY; --y) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            Block aboveAbove = world.getBlockAt(x, y + 2, z);
            if (block.getType() == Material.AIR || block.getType() == Material.LAVA || above.getType() != Material.AIR || aboveAbove.getType() != Material.AIR) continue;
            return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SerializableChunk)) {
            return false;
        }
        SerializableChunk other = (SerializableChunk)obj;
        return this.x == other.x && this.z == other.z && this.worldName.equalsIgnoreCase(other.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.worldName.toLowerCase(), this.x, this.z);
    }
}

