/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.other.TaxesUtils;

public class Region {
    public UUID id;
    public String displayName;
    public String name;
    public String description;
    public UUID ownerId;
    public SerializableLocation location;
    public long createdAt;
    public long playerFlags;
    public long worldFlags;
    public double bank;
    public int mapColor;
    public List<SerializableChunk> chunks = new ArrayList<SerializableChunk>();
    public List<SerializableMember> members = new ArrayList<SerializableMember>();
    public List<SerializableRate> rates = new ArrayList<SerializableRate>();
    public List<UUID> invitedPlayers = new ArrayList<UUID>();
    public List<SerializableBannedPlayer> bannedPlayers = new ArrayList<SerializableBannedPlayer>();
    public List<SerializableLog> logs = new ArrayList<SerializableLog>();
    public List<SerializableSubArea> subAreas = new ArrayList<SerializableSubArea>();
    public SerializableRent rent;
    public long upkeepAt;
    public double taxesAmount;
    public int weather;
    public int time;
    public SerializableLocation welcomeSign;
    public String icon;

    public Region(String name, OfflinePlayer player) {
        this.id = UUID.randomUUID();
        this.displayName = name;
        this.name = name;
        this.description = ((String)Homestead.language.get("default.description")).replace("{owner}", player.getName() == null ? "Unknown" : player.getName());
        this.ownerId = player.getUniqueId();
        this.location = new SerializableLocation(player.getLocation());
        this.createdAt = System.currentTimeMillis();
        this.playerFlags = Homestead.config.getDefaultPlayerFlags();
        this.worldFlags = Homestead.config.getDefaultWorldFlags();
        this.upkeepAt = 0L;
        this.taxesAmount = 0.0;
        this.welcomeSign = null;
        this.mapColor = 0;
    }

    public UUID getUniqueId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updateCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateCache();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateCache();
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public OfflinePlayer getOwner() {
        return Homestead.getInstance().getOfflinePlayerSync(this.ownerId);
    }

    public void setOwner(OfflinePlayer player) {
        this.ownerId = player.getUniqueId();
        this.updateCache();
    }

    public SerializableLocation getLocation() {
        return this.location;
    }

    public void setLocation(SerializableLocation location) {
        this.location = location;
        this.updateCache();
    }

    public SerializableLocation getWelcomeSign() {
        return this.welcomeSign;
    }

    public void setWelcomeSign(SerializableLocation location) {
        this.welcomeSign = location;
        this.updateCache();
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpkeepAt() {
        return this.upkeepAt;
    }

    public void setUpkeepAt(long at) {
        this.upkeepAt = at;
        this.updateCache();
    }

    public double getTaxesAmount() {
        return this.taxesAmount;
    }

    public void setTaxesAmount(double amount) {
        this.taxesAmount = amount;
        this.updateCache();
    }

    public int getWeather() {
        return this.weather;
    }

    public void setWeather(int weather) {
        this.weather = weather;
        this.updateCache();
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
        this.updateCache();
    }

    public long getPlayerFlags() {
        return this.playerFlags;
    }

    public void setPlayerFlags(long flags) {
        this.playerFlags = flags;
        this.updateCache();
    }

    public boolean isPlayerFlagSet(long flag) {
        return FlagsCalculator.isFlagSet(this.playerFlags, flag);
    }

    public long getWorldFlags() {
        return this.worldFlags;
    }

    public void setWorldFlags(long flags) {
        this.worldFlags = flags;
        this.updateCache();
    }

    public boolean isWorldFlagSet(long flag) {
        return FlagsCalculator.isFlagSet(this.worldFlags, flag);
    }

    public double getBank() {
        return this.bank;
    }

    public void setBank(double money) {
        this.bank = money;
        this.updateCache();
    }

    public void addBalanceToBank(double money) {
        this.bank += money;
        this.updateCache();
    }

    public void removeBalanceFromBank(double money) {
        this.bank -= money;
        if (this.bank < 0.0) {
            this.bank = 0.0;
        }
        this.updateCache();
    }

    public int getMapColor() {
        return this.mapColor;
    }

    public void setMapColor(int hexColorCode) {
        this.mapColor = hexColorCode;
        this.updateCache();
    }

    public List<SerializableChunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<SerializableChunk> chunks) {
        this.chunks = chunks;
        this.updateCache();
    }

    public void addChunk(SerializableChunk chunk) {
        if (!this.chunks.contains(chunk)) {
            this.chunks.add(chunk);
            this.updateCache();
        }
    }

    public void removeChunk(SerializableChunk chunkToRemove) {
        for (int i = 0; i < this.chunks.size(); ++i) {
            SerializableChunk chunk = this.chunks.get(i);
            if (!chunk.toString(true).equals(chunkToRemove.toString(true))) continue;
            this.chunks.remove(i);
            this.updateCache();
            break;
        }
    }

    public List<SerializableMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<SerializableMember> players) {
        this.members = players;
        this.updateCache();
    }

    public void addMember(OfflinePlayer player) {
        if (!this.isPlayerMember(player)) {
            SerializableMember member = new SerializableMember(player, this.playerFlags, 0L);
            member.setTaxesAt(TaxesUtils.getNewTaxesAt());
            this.members.add(member);
            this.updateCache();
        }
    }

    public SerializableMember getMember(OfflinePlayer player) {
        for (SerializableMember member : this.members) {
            if (!member.getPlayerId().equals(player.getUniqueId())) continue;
            return member;
        }
        return null;
    }

    public void setMemberFlags(SerializableMember member, long flags) {
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember data = this.members.get(i);
            if (!data.getPlayerId().equals(member.getPlayerId())) continue;
            data.setFlags(flags);
            this.members.set(i, data);
            this.updateCache();
            break;
        }
    }

    public void setMemberRegionControlFlags(SerializableMember member, long flags) {
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember data = this.members.get(i);
            if (!data.getPlayerId().equals(member.getPlayerId())) continue;
            data.setRegionControlFlags(flags);
            this.members.set(i, data);
            this.updateCache();
            break;
        }
    }

    public void setMemberTaxesAt(SerializableMember member, long taxesAt) {
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember data = this.members.get(i);
            if (!data.getPlayerId().equals(member.getPlayerId())) continue;
            data.setTaxesAt(taxesAt);
            this.members.set(i, data);
            this.updateCache();
            break;
        }
    }

    public boolean isPlayerMember(OfflinePlayer player) {
        for (SerializableMember member : this.members) {
            if (!member.getPlayerId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public void removeMember(OfflinePlayer player) {
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember member = this.members.get(i);
            if (!member.getPlayerId().equals(player.getUniqueId())) continue;
            this.members.remove(i);
            this.updateCache();
            break;
        }
    }

    public void removeMember(SerializableMember player) {
        for (int i = 0; i < this.members.size(); ++i) {
            SerializableMember member = this.members.get(i);
            if (!member.getPlayerId().equals(player.getPlayerId())) continue;
            this.members.remove(i);
            this.updateCache();
            break;
        }
    }

    public List<SerializableRate> getRates() {
        return this.rates;
    }

    public void setRates(List<SerializableRate> rates) {
        this.rates = rates;
        this.updateCache();
    }

    public void addPlayerRate(OfflinePlayer player, int rate) {
        if (this.isPlayerRated(player)) {
            this.setPlayerRateValue(player, rate);
        } else {
            SerializableRate newRate = new SerializableRate(player, rate);
            this.rates.add(newRate);
            this.updateCache();
        }
    }

    public void removePlayerRate(OfflinePlayer player) {
        for (int i = 0; i < this.rates.size(); ++i) {
            SerializableRate data = this.rates.get(i);
            if (!data.getPlayerId().equals(player.getUniqueId())) continue;
            this.rates.remove(i);
            this.updateCache();
            break;
        }
    }

    public void removePlayerRate(UUID playerId) {
        for (int i = 0; i < this.rates.size(); ++i) {
            SerializableRate data = this.rates.get(i);
            if (!data.getPlayerId().equals(playerId)) continue;
            this.rates.remove(i);
            this.updateCache();
            break;
        }
    }

    public void setPlayerRateValue(OfflinePlayer player, int rate) {
        for (int i = 0; i < this.rates.size(); ++i) {
            SerializableRate data = this.rates.get(i);
            if (!data.getPlayerId().equals(player.getUniqueId())) continue;
            data.setRate(rate);
            this.rates.set(i, data);
            this.updateCache();
            break;
        }
    }

    public boolean isPlayerRated(OfflinePlayer player) {
        List<SerializableRate> rates = this.getRates();
        for (SerializableRate rate : rates) {
            if (!rate.getPlayerId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public SerializableRate getPlayerRate(OfflinePlayer player) {
        List<SerializableRate> rates = this.getRates();
        for (SerializableRate rate : rates) {
            if (!rate.getPlayerId().equals(player.getUniqueId())) continue;
            return rate;
        }
        return null;
    }

    public List<OfflinePlayer> getInvitedPlayers() {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        for (int i = 0; i < this.invitedPlayers.size(); ++i) {
            UUID playerId = this.invitedPlayers.get(i);
            OfflinePlayer player = Homestead.getInstance().getOfflinePlayerSync(playerId);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public void setInvitedPlayers(List<OfflinePlayer> players) {
        this.invitedPlayers = players.stream().map(player -> player.getUniqueId()).collect(Collectors.toList());
        this.updateCache();
    }

    public boolean isPlayerInvited(OfflinePlayer player) {
        List<OfflinePlayer> invitedPlayers = this.getInvitedPlayers();
        for (OfflinePlayer invitedPlayer : invitedPlayers) {
            if (!invitedPlayer.getUniqueId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public void addPlayerInvite(OfflinePlayer player) {
        if (!this.isPlayerInvited(player)) {
            this.invitedPlayers.add(player.getUniqueId());
            this.updateCache();
        }
    }

    public void removePlayerInvite(OfflinePlayer player) {
        for (int i = 0; i < this.invitedPlayers.size(); ++i) {
            UUID playerUuid = this.invitedPlayers.get(i);
            if (!playerUuid.equals(player.getUniqueId())) continue;
            this.invitedPlayers.remove(i);
            this.updateCache();
            break;
        }
    }

    public List<SerializableBannedPlayer> getBannedPlayers() {
        return this.bannedPlayers;
    }

    public void setBannedPlayers(List<SerializableBannedPlayer> bannedPlayers) {
        this.bannedPlayers = bannedPlayers;
        this.updateCache();
    }

    public SerializableBannedPlayer getBannedPlayer(OfflinePlayer player) {
        for (SerializableBannedPlayer bannedPlayer : this.bannedPlayers) {
            if (!bannedPlayer.getPlayerId().equals(player.getUniqueId())) continue;
            return bannedPlayer;
        }
        return null;
    }

    public boolean isPlayerBanned(OfflinePlayer player) {
        List<SerializableBannedPlayer> bannedPlayers = this.getBannedPlayers();
        for (SerializableBannedPlayer bannedPlayer : bannedPlayers) {
            if (!bannedPlayer.getPlayerId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public void banPlayer(OfflinePlayer player, String reason) {
        if (!this.isPlayerBanned(player)) {
            this.bannedPlayers.add(new SerializableBannedPlayer(player, reason));
            this.updateCache();
        }
    }

    public void banPlayer(OfflinePlayer player) {
        if (!this.isPlayerBanned(player)) {
            this.bannedPlayers.add(new SerializableBannedPlayer(player, (String)Homestead.language.get("default.reason")));
            this.updateCache();
        }
    }

    public void unbanPlayer(OfflinePlayer player) {
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            SerializableBannedPlayer playerData = this.bannedPlayers.get(i);
            if (!playerData.getPlayerId().equals(player.getUniqueId())) continue;
            this.bannedPlayers.remove(i);
            this.updateCache();
            break;
        }
    }

    public void unbanPlayer(UUID playerId) {
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            SerializableBannedPlayer playerData = this.bannedPlayers.get(i);
            if (!playerData.getPlayerId().equals(playerId)) continue;
            this.bannedPlayers.remove(i);
            this.updateCache();
            break;
        }
    }

    public List<SerializableLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<SerializableLog> logs) {
        this.logs = logs;
        this.updateCache();
    }

    public void addLog(SerializableLog log) {
        if (this.logs.stream().anyMatch(l -> l.getId().equals(log.getId()))) {
            return;
        }
        if (this.logs.size() >= 150) {
            this.removeOldestLog();
        }
        this.logs.add(log);
        this.updateCache();
    }

    public void setLogAsRead(UUID logId) {
        for (int i = 0; i < this.logs.size(); ++i) {
            SerializableLog log = this.logs.get(i);
            if (!log.getId().equals(logId)) continue;
            log.setRead(true);
            this.logs.set(i, log);
            this.updateCache();
            break;
        }
    }

    public void removeLog(UUID logId) {
        for (int i = 0; i < this.logs.size(); ++i) {
            SerializableLog log = this.logs.get(i);
            if (!log.getId().equals(logId)) continue;
            this.logs.remove(i);
            this.updateCache();
            break;
        }
    }

    private void removeOldestLog() {
        if (this.logs.isEmpty()) {
            return;
        }
        SerializableLog oldest = this.logs.stream().min(Comparator.comparingLong(SerializableLog::getSentAt)).orElse(null);
        if (oldest != null) {
            this.logs.remove(oldest);
        }
    }

    public List<SerializableSubArea> getSubAreas() {
        return this.subAreas;
    }

    public void setSubAreas(List<SerializableSubArea> subAreas) {
        this.subAreas = subAreas;
        this.updateCache();
    }

    public SerializableSubArea getSubArea(UUID subAreaId) {
        for (SerializableSubArea subArea : this.subAreas) {
            if (!subArea.getId().equals(subAreaId)) continue;
            return subArea;
        }
        return null;
    }

    public SerializableSubArea getSubArea(String name) {
        for (SerializableSubArea subArea : this.subAreas) {
            if (!subArea.getName().equalsIgnoreCase(name)) continue;
            return subArea;
        }
        return null;
    }

    public boolean isSubAreaNameUsed(String name) {
        for (SerializableSubArea subArea : this.subAreas) {
            if (!subArea.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public SerializableSubArea findSubAreaHasBlockInside(Block block) {
        return this.findSubAreaHasLocationInside(block.getLocation());
    }

    public SerializableSubArea findSubAreaHasLocationInside(Location location) {
        for (int i = 0; i < this.subAreas.size(); ++i) {
            SerializableSubArea subArea = this.subAreas.get(i);
            if (!subArea.isLocationInside(location)) continue;
            return subArea;
        }
        return null;
    }

    public void addSubArea(SerializableSubArea subArea) {
        if (!this.subAreas.stream().map(SerializableSubArea::getId).collect(Collectors.toList()).contains(subArea.getId())) {
            this.subAreas.add(subArea);
            this.updateCache();
        }
    }

    public void setSubAreaName(UUID subAreaId, String name) {
        for (int i = 0; i < this.subAreas.size(); ++i) {
            SerializableSubArea subArea = this.subAreas.get(i);
            if (!subArea.getId().equals(subAreaId)) continue;
            subArea.setName(name);
            this.subAreas.set(i, subArea);
            this.updateCache();
            break;
        }
    }

    public void setSubAreaFlags(UUID subAreaId, long flags) {
        for (int i = 0; i < this.subAreas.size(); ++i) {
            SerializableSubArea subArea = this.subAreas.get(i);
            if (!subArea.getId().equals(subAreaId)) continue;
            subArea.setFlags(flags);
            this.subAreas.set(i, subArea);
            this.updateCache();
            break;
        }
    }

    public void removeSubArea(UUID subAreaId) {
        for (int i = 0; i < this.subAreas.size(); ++i) {
            SerializableSubArea subArea = this.subAreas.get(i);
            if (!subArea.getId().equals(subAreaId)) continue;
            this.subAreas.remove(i);
            this.updateCache();
            break;
        }
    }

    public SerializableRent getRent() {
        return this.rent;
    }

    public void setRent(SerializableRent rent) {
        this.rent = rent;
        this.updateCache();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void updateCache() {
        Homestead.regionsCache.putOrUpdate(this);
    }
}

