/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bee;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Goat;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Wither;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class RegionProtectionListener
implements Listener {
    public static final Map<UUID, Location> lastLocations = new HashMap<UUID, Location>();

    public static void onEntityMove(Entity entity) {
        Location from = lastLocations.get(entity.getUniqueId());
        Location to = entity.getLocation();
        if (from == null) {
            from = entity.getLocation();
        }
        Chunk fromChunk = from.getChunk();
        Chunk toChunk = to.getChunk();
        lastLocations.put(entity.getUniqueId(), to.clone());
        if (fromChunk.equals((Object)toChunk)) {
            return;
        }
        if (ChunksManager.isChunkClaimed(toChunk) && entity.getType().name().contains("COPPER_GOLEM") && !(entity instanceof Player)) {
            Region fromRegion = ChunksManager.getRegionOwnsTheChunk(fromChunk);
            Region toRegion = ChunksManager.getRegionOwnsTheChunk(toChunk);
            if (fromRegion == null) {
                if (!toRegion.isWorldFlagSet(0x100000L)) {
                    entity.remove();
                }
            } else if (!fromRegion.getUniqueId().equals(toRegion.getUniqueId()) && !toRegion.isWorldFlagSet(0x100000L)) {
                entity.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player) && !event.getBlock().getType().equals((Object)Material.FIRE)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlock().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 2L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 2L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player) && !event.getBlock().getType().equals((Object)Material.FIRE)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlock().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 1L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 1L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Villager) {
            Villager villager = (Villager)holder;
            Player player = (Player)event.getPlayer();
            Chunk chunk = villager.getLocation().getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(villager.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x400000L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x400000L)) {
                    event.setCancelled(true);
                }
            }
        } else if (event.getInventory().getHolder() instanceof ChestBoat || event.getInventory().getHolder() instanceof ChestedHorse || event.getInventory().getHolder() instanceof StorageMinecart || event.getInventory().getHolder() instanceof HopperMinecart) {
            Player player = (Player)event.getPlayer();
            Chunk chunk = player.getLocation().getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 4L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 4L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Chunk chunk = event.getBlockClicked().getRelative(event.getBlockFace()).getChunk();
        Player player = event.getPlayer();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlockClicked().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 2L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 2L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Chunk chunk = event.getBlockClicked().getRelative(event.getBlockFace()).getChunk();
        Player player = event.getPlayer();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlock().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 1L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 1L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBreakCrop(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block clickedblock = event.getClickedBlock();
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && player.getTargetBlock(null, 5).getType().equals((Object)Material.FIRE)) {
            Chunk chunk = player.getTargetBlock(null, 5).getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getClickedBlock().getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x800000L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x800000L)) {
                    event.setCancelled(true);
                }
            }
        } else if (event.getAction().equals((Object)Action.PHYSICAL)) {
            if (clickedblock != null && (clickedblock.getType() == Material.FARMLAND || clickedblock.getType() == Material.TURTLE_EGG)) {
                Chunk chunk = event.getClickedBlock().getLocation().getChunk();
                if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                    Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                    SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getClickedBlock().getLocation());
                    if (subArea != null) {
                        if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 32768L)) {
                            event.setCancelled(true);
                        }
                    } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 32768L)) {
                        event.setCancelled(true);
                    }
                }
            }
        } else if (clickedblock != null && this.isCropBlock(clickedblock)) {
            Chunk chunk = event.getClickedBlock().getLocation().getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getClickedBlock().getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 16384L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 16384L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onSpawnEggPlace(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (item.getType().toString().endsWith("_SPAWN_EGG")) {
            if (event.getClickedBlock() == null) {
                return;
            }
            Chunk chunk = event.getClickedBlock().getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getClickedBlock().getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 2L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 2L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Material type;
        SerializableSubArea subArea;
        Chunk chunk;
        Player player = event.getPlayer();
        Block clicked = event.getClickedBlock();
        Chunk chunk2 = chunk = clicked != null ? clicked.getLocation().getChunk() : player.getLocation().getChunk();
        if (!ChunksManager.isChunkClaimed(chunk)) {
            return;
        }
        if (PlayerUtils.isOperator(player)) {
            return;
        }
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (region == null) {
            return;
        }
        boolean isOwner = player.getUniqueId().equals(region.getOwnerId());
        if (isOwner) {
            return;
        }
        SerializableSubArea serializableSubArea = subArea = clicked != null ? region.findSubAreaHasLocationInside(clicked.getLocation()) : region.findSubAreaHasLocationInside(player.getLocation());
        if (event.getItem() != null) {
            boolean placeSpawnItem;
            Material itemType = event.getItem().getType();
            String itn = itemType.name();
            boolean bl = placeSpawnItem = itn.contains("BOAT") || itn.contains("ARMOR_STAND") || itn.contains("MINECART") || itn.contains("PAINTING") || itemType == Material.BONE_MEAL;
            if (placeSpawnItem && !this.requireFlag(region, subArea, player, 2L, (Cancellable)event)) {
                return;
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && clicked != null) {
            type = clicked.getType();
            if (this.isShulkerBox(type) && !this.requireFlag(region, subArea, player, 4L, (Cancellable)event)) {
                return;
            }
            if (this.isAnySign(type) && !this.requireFlag(region, subArea, player, 65536L, (Cancellable)event)) {
                return;
            }
            if (this.isContainerLike(type)) {
                if (!this.requireFlag(region, subArea, player, 4L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (this.isAnvil(type)) {
                if (!this.requireFlag(region, subArea, player, 64L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (Tag.TRAPDOORS.isTagged((Keyed)type)) {
                if (!this.requireFlag(region, subArea, player, 16L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (Tag.DOORS.isTagged((Keyed)type) || type.name().contains("DOOR")) {
                if (!this.requireFlag(region, subArea, player, 8L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (this.isArchaeologyBlockWithBrush(type, player)) {
                if (!this.requireFlag(region, subArea, player, 1L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (Tag.BUTTONS.isTagged((Keyed)type)) {
                if (!this.requireFlag(region, subArea, player, 512L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (type.name().contains("FENCE_GATE")) {
                if (!this.requireFlag(region, subArea, player, 32L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (this.isSmallInteractable(type)) {
                if (!this.requireFlag(region, subArea, player, 65536L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (this.isLecternOrVaultWithKey(type, player)) {
                if (!this.requireFlag(region, subArea, player, 4L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (type.name().endsWith("_BED")) {
                if (!this.requireFlag(region, subArea, player, 0x100000000L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (type == Material.LEVER) {
                if (!this.requireFlag(region, subArea, player, 256L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (type == Material.BELL) {
                if (!this.requireFlag(region, subArea, player, 2048L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (this.isRedstoneInteraction(type) && !this.requireFlag(region, subArea, player, 128L, (Cancellable)event)) {
                return;
            }
            return;
        }
        if (event.getAction() == Action.PHYSICAL && clicked != null) {
            type = clicked.getType();
            if (Tag.PRESSURE_PLATES.isTagged((Keyed)type)) {
                if (!this.requireFlag(region, subArea, player, 1024L, (Cancellable)event)) {
                    return;
                }
                return;
            }
            if (type != Material.TRIPWIRE || !this.requireFlag(region, subArea, player, 4096L, (Cancellable)event)) {
                // empty if block
            }
        }
    }

    private boolean requireFlag(Region region, SerializableSubArea subArea, Player player, long flag, Cancellable event) {
        boolean allowed;
        boolean bl = allowed = subArea != null ? PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, flag) : PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, flag);
        if (!allowed) {
            event.setCancelled(true);
            return false;
        }
        return true;
    }

    private boolean isShulkerBox(Material type) {
        if (Tag.SHULKER_BOXES.isTagged((Keyed)type)) {
            return true;
        }
        String n = type.name();
        return n.endsWith("SHULKER_BOX");
    }

    private boolean isAnySign(Material type) {
        if (Tag.SIGNS.isTagged((Keyed)type)) {
            return true;
        }
        String n = type.name();
        return n.endsWith("_HANGING_SIGN") || n.endsWith("_WALL_HANGING_SIGN") || n.endsWith("_SIGN") || n.endsWith("_WALL_SIGN");
    }

    private boolean isContainerLike(Material type) {
        if (type == Material.ENDER_CHEST) {
            return false;
        }
        if (Tag.CAMPFIRES.isTagged((Keyed)type)) {
            return true;
        }
        if (this.isShulkerBox(type)) {
            return true;
        }
        switch (type) {
            case FURNACE: 
            case SMOKER: 
            case BLAST_FURNACE: 
            case BREWING_STAND: 
            case BARREL: 
            case BEACON: 
            case DROPPER: 
            case DISPENSER: 
            case CHISELED_BOOKSHELF: 
            case CAULDRON: 
            case LAVA_CAULDRON: 
            case WATER_CAULDRON: 
            case LODESTONE: 
            case HOPPER: {
                return true;
            }
        }
        String n = type.name();
        if (n.contains("CHEST")) {
            return true;
        }
        return n.contains("SHELF");
    }

    private boolean isAnvil(Material type) {
        return type.name().contains("ANVIL");
    }

    private boolean isArchaeologyBlockWithBrush(Material type, Player player) {
        if (type != Material.SUSPICIOUS_GRAVEL && type != Material.SUSPICIOUS_SAND) {
            return false;
        }
        return player.getInventory().getItemInMainHand().getType() == Material.BRUSH;
    }

    private boolean isSmallInteractable(Material type) {
        if (type == Material.CAKE) {
            return true;
        }
        if (type == Material.DECORATED_POT) {
            return true;
        }
        if (type == Material.FLOWER_POT) {
            return true;
        }
        String n = type.name();
        return n.contains("POTTED");
    }

    private boolean isLecternOrVaultWithKey(Material type, Player player) {
        if (type == Material.LECTERN) {
            Material inHand = player.getInventory().getItemInMainHand().getType();
            return inHand == Material.WRITTEN_BOOK || inHand == Material.WRITABLE_BOOK;
        }
        if (type == Material.VAULT) {
            return player.getInventory().getItemInMainHand().getType().name().contains("TRIAL_KEY");
        }
        return false;
    }

    private boolean isRedstoneInteraction(Material type) {
        switch (type) {
            case REPEATER: 
            case COMPARATOR: 
            case COMMAND_BLOCK: 
            case COMMAND_BLOCK_MINECART: 
            case REDSTONE: 
            case REDSTONE_WIRE: 
            case NOTE_BLOCK: 
            case JUKEBOX: 
            case COMPOSTER: 
            case DAYLIGHT_DETECTOR: {
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onPlayerPunchFrame(EntityDamageByEntityEvent event) {
        Entity entity;
        if ((event.getEntityType() == EntityType.ITEM_FRAME || event.getEntityType() == EntityType.GLOW_ITEM_FRAME) && (entity = event.getDamager()) instanceof Player) {
            Player player = (Player)entity;
            Chunk chunk = event.getEntity().getLocation().getChunk();
            if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getEntity().getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 4L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 4L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent event) {
        Player player = event.getPlayer();
        Block block = event.getLectern().getLocation().getBlock();
        Chunk chunk = block.getLocation().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getLectern().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 4L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 4L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Chunk chunk = event.getBlock().getChunk();
            ItemStack boots = player.getEquipment().getBoots();
            if (boots != null && boots.getEnchantments().containsKey(Enchantment.FROST_WALKER) && player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlock().getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 8192L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 8192L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (player == null) {
            event.setCancelled(true);
        } else if (ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getBlock().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x800000L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x800000L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        if (event.getEntity().getType().name().contains("PAINTING") || event.getEntity().getType().name().contains("ITEM_FRAME")) {
            Region region;
            Chunk chunk;
            Entity entity = event.getRemover();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                chunk = event.getEntity().getLocation().getChunk();
                if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                    Region region2 = ChunksManager.getRegionOwnsTheChunk(chunk);
                    SerializableSubArea subArea = region2.findSubAreaHasLocationInside(event.getEntity().getLocation());
                    if (subArea != null) {
                        if (!player.getUniqueId().equals(region2.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region2.getUniqueId(), subArea.getId(), player, 1L)) {
                            event.setCancelled(true);
                        }
                    } else if (!player.getUniqueId().equals(region2.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region2.getUniqueId(), player, 1L)) {
                        event.setCancelled(true);
                    }
                }
            } else if ((event.getRemover() instanceof Creeper || event.getRemover() instanceof TNTPrimed || event.getRemover() instanceof Fireball || event.getRemover() instanceof EnderCrystal || event.getRemover().getType() == EntityType.END_CRYSTAL || event.getRemover().getType() == EntityType.TNT_MINECART) && ChunksManager.isChunkClaimed(chunk = event.getEntity().getLocation().getChunk()) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(128L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Chunk chunk;
        Projectile entity = event.getEntity();
        ProjectileSource source = event.getEntity().getShooter();
        Block hitBlock = event.getHitBlock();
        if (hitBlock != null && hitBlock.getType().equals((Object)Material.DECORATED_POT) && ChunksManager.isChunkClaimed(chunk = hitBlock.getChunk()) && (entity instanceof Arrow || entity instanceof WindCharge || entity instanceof Egg || entity instanceof Snowball)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (source instanceof Player) {
                Player player = (Player)source;
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 1L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 1L)) {
                    event.setCancelled(true);
                }
            } else if (!region.isWorldFlagSet(1024L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        Chunk chunk = entity.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getEntity().getLocation());
            if (subArea != null) {
                if (damager instanceof Player && entity instanceof ArmorStand) {
                    if (!(PlayerUtils.isOperator((Player)damager) || damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.hasPermissionFlag(subArea.getId(), subArea.getId(), (Player)damager, 1L))) {
                        event.setCancelled(true);
                    }
                } else if (entity instanceof Player && damager instanceof Player) {
                    if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), (Player)damager, 0x8000000L)) {
                        event.setCancelled(true);
                    }
                } else if (damager instanceof Player && (entity instanceof Monster || entity instanceof IronGolem)) {
                    if (!(damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.isOperator((Player)damager) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), (Player)damager, 0x200000L))) {
                        event.setCancelled(true);
                    }
                } else if (damager instanceof Player && (entity instanceof Animals || entity instanceof Mob)) {
                    if (!(damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.isOperator((Player)damager) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), (Player)damager, 0x100000L))) {
                        event.setCancelled(true);
                    }
                } else if ((damager instanceof Creeper || damager instanceof TNTPrimed || damager instanceof Fireball || damager instanceof EnderCrystal || damager.getType() == EntityType.END_CRYSTAL || damager.getType() == EntityType.TNT_MINECART) && !region.isWorldFlagSet(128L)) {
                    event.setCancelled(true);
                }
            } else if (damager instanceof Player && entity instanceof ArmorStand) {
                if (!(PlayerUtils.isOperator((Player)damager) || damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), (Player)damager, 1L))) {
                    event.setCancelled(true);
                }
            } else if (entity instanceof Player && damager instanceof Player) {
                if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), (Player)damager, 0x8000000L)) {
                    event.setCancelled(true);
                }
            } else if (damager instanceof Player && (entity instanceof Monster || entity instanceof IronGolem)) {
                if (!(damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.isOperator((Player)damager) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), (Player)damager, 0x200000L))) {
                    event.setCancelled(true);
                }
            } else if (damager instanceof Player && (entity instanceof Animals || entity instanceof Mob)) {
                if (!(damager.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.isOperator((Player)damager) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), (Player)damager, 0x100000L))) {
                    event.setCancelled(true);
                }
            } else if ((damager instanceof Creeper || damager instanceof TNTPrimed || damager instanceof Fireball || damager instanceof EnderCrystal || damager.getType() == EntityType.END_CRYSTAL || damager.getType() == EntityType.TNT_MINECART) && !region.isWorldFlagSet(128L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getEntity().getLocation().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(event.getEntity().getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 262144L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 262144L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract2(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = player.getLocation().getChunk();
        if (event.getItem() != null) {
            if (event.getItem().getType().equals((Object)Material.ENDER_PEARL)) {
                if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                    Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                    SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
                    if (subArea != null) {
                        if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x20000000L)) {
                            event.setCancelled(true);
                        }
                    } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x20000000L)) {
                        event.setCancelled(true);
                    }
                }
            } else if ((event.getItem().getType().equals((Object)Material.SPLASH_POTION) || event.getItem().getType().equals((Object)Material.LINGERING_POTION)) && player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x40000000L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x40000000L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerEatChorusFruit(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = player.getLocation().getChunk();
        if (event.getItem() != null && event.getItem().getType().equals((Object)Material.CHORUS_FRUIT) && player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x20000000L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x20000000L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        if (shooter instanceof Player) {
            Chunk chunk;
            Player player = (Player)shooter;
            if (entity instanceof ThrownPotion && ChunksManager.isChunkClaimed(chunk = entity.getLocation().getChunk()) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x40000000L)) {
                        event.setCancelled(true);
                        entity.remove();
                    }
                } else if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x40000000L)) {
                    event.setCancelled(true);
                    entity.remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        ThrownPotion entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        if (shooter instanceof Player) {
            Chunk chunk;
            Player player = (Player)shooter;
            if (entity instanceof ThrownPotion && ChunksManager.isChunkClaimed(chunk = entity.getLocation().getChunk()) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x40000000L)) {
                        event.setCancelled(true);
                        event.getEntity().remove();
                    }
                } else if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x40000000L)) {
                    event.setCancelled(true);
                    event.getEntity().remove();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onProjectileHit2(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        Entity entityhit = event.getHitEntity();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (entity instanceof ThrownPotion) {
                Chunk chunk = entity.getLocation().getChunk();
                if (!ChunksManager.isChunkClaimed(chunk)) return;
                if (PlayerUtils.isOperator(player)) return;
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
                if (subArea != null) {
                    if (player.getUniqueId().equals(region.getOwnerId())) return;
                    if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x40000000L)) return;
                    event.setCancelled(true);
                    event.getEntity().remove();
                    return;
                }
                if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x40000000L)) return;
                event.setCancelled(true);
                event.getEntity().remove();
                return;
            }
        }
        if (!(shooter instanceof Player)) return;
        Player player = (Player)shooter;
        if (entityhit == null) return;
        Chunk chunk = entityhit.getLocation().getChunk();
        if (!ChunksManager.isChunkClaimed(chunk)) return;
        if (PlayerUtils.isOperator(player)) return;
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        SerializableSubArea subArea = region.findSubAreaHasLocationInside(entityhit.getLocation());
        if (entityhit instanceof Player) {
            if (subArea != null) {
                if (player.getUniqueId().equals(region.getOwnerId())) return;
                if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x8000000L)) return;
                event.setCancelled(true);
                event.getEntity().remove();
                return;
            }
            if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x8000000L)) return;
            event.setCancelled(true);
            event.getEntity().remove();
            return;
        }
        if (entityhit instanceof Monster || entityhit instanceof IronGolem) {
            if (subArea != null) {
                if (player.getUniqueId().equals(region.getOwnerId())) return;
                if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x200000L)) return;
                event.setCancelled(true);
                event.getEntity().remove();
                return;
            }
            if (player.getUniqueId().equals(region.getOwnerId())) return;
            if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x200000L)) return;
            event.setCancelled(true);
            event.getEntity().remove();
            return;
        }
        if (!(entityhit instanceof Animals)) {
            if (!(entityhit instanceof Mob)) return;
        }
        if (subArea != null) {
            if (player.getUniqueId().equals(region.getOwnerId())) return;
            if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x100000L)) return;
            event.setCancelled(true);
            event.getEntity().remove();
            return;
        }
        if (player.getUniqueId().equals(region.getOwnerId())) return;
        if (PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x100000L)) return;
        event.setCancelled(true);
        event.getEntity().remove();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (this.shouldCancelItemTransfer(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.shouldCancelItemTransfer(player)) {
            event.setCancelled(true);
        }
    }

    private boolean shouldCancelItemTransfer(Player player) {
        if (player == null) {
            return false;
        }
        if (PlayerUtils.isOperator(player)) {
            return false;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (!ChunksManager.isChunkClaimed(chunk)) {
            return false;
        }
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (region == null) {
            return false;
        }
        if (player.getUniqueId().equals(region.getOwnerId())) {
            return false;
        }
        SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
        boolean allowed = subArea != null ? PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x80000000L) : PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x80000000L);
        return !allowed;
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        Chunk chunk = vehicle.getLocation().getChunk();
        Entity entity = event.getEntered();
        if (vehicle != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator((Player)entity)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(vehicle.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x1000000L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x1000000L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent event) {
        Vehicle vehicle = event.getVehicle();
        Chunk chunk = vehicle.getLocation().getChunk();
        Entity entity = event.getAttacker();
        if (vehicle != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator((Player)entity)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(vehicle.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 1L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 1L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Chunk chunk = entity.getLocation().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 262144L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 262144L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onLeashEvent(PlayerLeashEntityEvent event) {
        Player player = event.getPlayer();
        Block block = event.getEntity().getLocation().getBlock();
        Chunk chunk = block.getLocation().getChunk();
        if (block.getType().name().contains("FENCE") && player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(block.getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 262144L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 262144L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerUnleashEntity(PlayerUnleashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Chunk chunk = entity.getLocation().getChunk();
        if (player != null && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
            if (subArea != null) {
                if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 262144L)) {
                    event.setCancelled(true);
                }
            } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 262144L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (this.shouldCancelEntityInteraction(player, entity = event.getRightClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (this.shouldCancelEntityInteraction(player, entity = event.getRightClicked())) {
            event.setCancelled(true);
        }
    }

    private boolean shouldCancelEntityInteraction(Player player, Entity entity) {
        if (player == null || entity == null) {
            return false;
        }
        if (PlayerUtils.isOperator(player)) {
            return false;
        }
        Chunk chunk = entity.getLocation().getChunk();
        if (!ChunksManager.isChunkClaimed(chunk)) {
            return false;
        }
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (region == null) {
            return false;
        }
        if (player.getUniqueId().equals(region.getOwnerId())) {
            return false;
        }
        EntityType type = entity.getType();
        long requiredFlag = type == EntityType.ITEM_FRAME || type == EntityType.GLOW_ITEM_FRAME ? 524288L : (entity instanceof Villager ? 0x400000L : (entity instanceof ArmorStand ? 131072L : 262144L));
        SerializableSubArea subArea = region.findSubAreaHasLocationInside(entity.getLocation());
        boolean allowed = subArea != null ? PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, requiredFlag) : PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, requiredFlag);
        return !allowed;
    }

    @EventHandler
    public void onEntityToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Chunk chunk = player.getLocation().getChunk();
            if (event.isGliding() && this.isWearingElytra(player) && ChunksManager.isChunkClaimed(chunk) && !PlayerUtils.isOperator(player)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
                if (subArea != null) {
                    if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x400000000L)) {
                        event.setCancelled(true);
                    }
                } else if (!player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x400000000L)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL && event.getCause() != EntityDamageEvent.DamageCause.FLY_INTO_WALL) {
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (!ChunksManager.isChunkClaimed(chunk)) {
            return;
        }
        Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
        SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
        if (subArea != null) {
            boolean allowed = PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x10000000L);
            if (!allowed) {
                event.setCancelled(true);
            }
        } else {
            boolean allowed = PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x10000000L);
            if (!allowed) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntity().getType() == EntityType.WIND_CHARGE) {
            Region region;
            Chunk chunk = event.getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(524288L)) {
                event.getEntity().remove();
                event.setCancelled(true);
            }
        } else if (event.getEntity().getType() == EntityType.WITHER || event.getEntity().getType() == EntityType.WITHER_SKULL) {
            event.blockList().removeIf(block -> {
                Chunk chunk = block.getChunk();
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                return region != null && region.isWorldFlagSet(256L);
            });
        } else if (event.getEntity() instanceof TNTPrimed || event.getEntity() instanceof Creeper || event.getEntity() instanceof Fireball || event.getEntity() instanceof EnderCrystal || event.getEntity().getType() == EntityType.END_CRYSTAL || event.getEntity().getType() == EntityType.TNT_MINECART) {
            Chunk chunk = event.getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (!region.isWorldFlagSet(128L)) {
                    event.setCancelled(true);
                }
            } else {
                ArrayList<Block> allowedblocks = new ArrayList<Block>();
                for (Block block2 : event.blockList()) {
                    Location blocklocation = block2.getLocation();
                    Chunk blockchunk = blocklocation.getChunk();
                    if (ChunksManager.isChunkClaimed(blockchunk)) continue;
                    allowedblocks.add(block2);
                }
                event.blockList().clear();
                event.blockList().addAll(allowedblocks);
            }
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (event.getBlock().getType().equals((Object)Material.AIR)) {
            Chunk chunk = event.getBlock().getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk)) {
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (!region.isWorldFlagSet(128L)) {
                    event.setCancelled(true);
                }
            } else {
                ArrayList<Block> allowedblocks = new ArrayList<Block>();
                for (Block block : event.blockList()) {
                    Location blocklocation = block.getLocation();
                    Chunk blockchunk = blocklocation.getChunk();
                    if (ChunksManager.isChunkClaimed(blockchunk)) continue;
                    allowedblocks.add(block);
                }
                event.blockList().clear();
                event.blockList().addAll(allowedblocks);
            }
        }
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent event) {
        if (event.getNewState().getType() == Material.FIRE) {
            Region region;
            Chunk chunk = event.getBlock().getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(32L)) {
                event.setCancelled(true);
            }
        } else if (event.getSource().getType() == Material.GRASS_BLOCK || event.getSource().getType() == Material.MYCELIUM) {
            Region region;
            Chunk chunk = event.getBlock().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(8192L)) {
                event.setCancelled(true);
            }
        } else if (event.getSource().getType() == Material.SCULK_CATALYST) {
            Region region;
            Chunk chunk = event.getBlock().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(16384L)) {
                event.setCancelled(true);
            }
        } else {
            Region region;
            Chunk chunk = event.getBlock().getLocation().getChunk();
            if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(4096L)) {
                event.setCancelled(true);
            }
        }
    }

    public void onBlockGrow(BlockGrowEvent event) {
        Region region;
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(4096L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        Region region;
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(16L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Region region;
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(32L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLiquidFlow(BlockFromToEvent event) {
        Chunk toChunk;
        Chunk fromChunk = event.getBlock().getChunk();
        if (!fromChunk.equals((Object)(toChunk = event.getToBlock().getChunk()))) {
            Region region;
            if (ChunksManager.isChunkClaimed(toChunk) && ChunksManager.isChunkClaimed(fromChunk)) {
                event.setCancelled(false);
            } else if (ChunksManager.isChunkClaimed(toChunk) && !(region = ChunksManager.getRegionOwnsTheChunk(toChunk)).isWorldFlagSet(64L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (!affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Block piston = event.getBlock();
        ArrayList<Block> affectedBlocks = new ArrayList<Block>(event.getBlocks());
        BlockFace direction = event.getDirection();
        if (event.isSticky() && !affectedBlocks.isEmpty()) {
            affectedBlocks.add(piston.getRelative(direction));
        }
        if (!this.canPistonMoveBlock(affectedBlocks, direction, piston.getLocation().getChunk(), true)) {
            event.setCancelled(true);
        }
    }

    private boolean canPistonMoveBlock(List<Block> blocks, BlockFace direction, Chunk pistonChunk, boolean retractOrNot) {
        if (retractOrNot) {
            for (Block block : blocks) {
                Chunk chunk = block.getLocation().getChunk();
                if (chunk.equals((Object)pistonChunk) || !ChunksManager.isChunkClaimed(chunk)) continue;
                Region pistonChunkRegion = ChunksManager.getRegionOwnsTheChunk(pistonChunk);
                UUID pistonChunkOwner = pistonChunkRegion == null ? null : pistonChunkRegion.getOwnerId();
                UUID targetChunkOwner = ChunksManager.getRegionOwnsTheChunk(chunk).getOwnerId();
                if (pistonChunkRegion != null && pistonChunkOwner != null && pistonChunkOwner.equals(targetChunkOwner)) {
                    return true;
                }
                Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
                if (region.isWorldFlagSet(512L)) continue;
                return false;
            }
            return true;
        }
        for (Block block : blocks) {
            Chunk chunk = block.getRelative(direction).getLocation().getChunk();
            if (chunk.equals((Object)pistonChunk) || !ChunksManager.isChunkClaimed(chunk)) continue;
            Region pistonChunkRegion = ChunksManager.getRegionOwnsTheChunk(pistonChunk);
            UUID pistonChunkOwner = pistonChunkRegion == null ? null : pistonChunkRegion.getOwnerId();
            UUID targetChunkOwner = ChunksManager.getRegionOwnsTheChunk(chunk).getOwnerId();
            if (pistonChunkRegion != null && pistonChunkOwner != null && pistonChunkOwner.equals(targetChunkOwner)) {
                return true;
            }
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (region.isWorldFlagSet(512L)) continue;
            return false;
        }
        return true;
    }

    @EventHandler
    public void onDispense(BlockDispenseEvent event) {
        Block block = event.getBlock();
        BlockData blockdata = event.getBlock().getBlockData();
        Chunk targetChunk = block.getRelative(((Directional)blockdata).getFacing()).getLocation().getChunk();
        if (!block.getLocation().getChunk().equals((Object)targetChunk) && ChunksManager.isChunkClaimed(targetChunk)) {
            Region dispenserChunkRegion = ChunksManager.getRegionOwnsTheChunk(block.getLocation().getChunk());
            UUID dispenserChunkOwner = dispenserChunkRegion == null ? null : dispenserChunkRegion.getOwnerId();
            UUID targetChunkOwner = ChunksManager.getRegionOwnsTheChunk(targetChunk).getOwnerId();
            if (dispenserChunkRegion != null && dispenserChunkOwner != null && dispenserChunkOwner.equals(targetChunkOwner)) {
                return;
            }
            Region region = ChunksManager.getRegionOwnsTheChunk(targetChunk);
            if (!region.isWorldFlagSet(1024L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Region region;
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        Chunk chunk = block.getChunk();
        if (entity == null) {
            return;
        }
        if (entity instanceof Sheep || entity instanceof Goat || entity instanceof Cow) {
            return;
        }
        if (!(!ChunksManager.isChunkClaimed(chunk) || entity instanceof Player || entity instanceof Wither || entity instanceof Villager || entity instanceof Bee || !(entity instanceof Mob) || (region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(4L))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        Chunk chunk = event.getLocation().getChunk();
        LivingEntity entity = event.getEntity();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (entity instanceof Monster || entity instanceof IronGolem) {
                if (!region.isWorldFlagSet(2L)) {
                    event.setCancelled(true);
                }
            } else if ((entity instanceof Animals || entity instanceof Mob) && !region.isWorldFlagSet(1L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity2(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        Chunk chunk = entity.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (damager instanceof Entity && !(damager instanceof Player) && entity instanceof Entity && !region.isWorldFlagSet(8L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityBreakDoor(EntityBreakDoorEvent event) {
        LivingEntity entity = event.getEntity();
        Chunk chunk = entity.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (!(entity instanceof Player) && !region.isWorldFlagSet(4L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onRaidTrigger(RaidTriggerEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getRaid().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            SerializableSubArea subArea = region.findSubAreaHasLocationInside(player.getLocation());
            if (subArea != null) {
                if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), subArea.getId(), player, 0x200000000L)) {
                    event.setCancelled(true);
                    PotionEffect effect = event.getPlayer().getPotionEffect(PotionEffectType.BAD_OMEN);
                    if (effect != null) {
                        event.getPlayer().removePotionEffect(PotionEffectType.BAD_OMEN);
                    }
                }
            } else if (!PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x200000000L)) {
                event.setCancelled(true);
                PotionEffect effect = event.getPlayer().getPotionEffect(PotionEffectType.BAD_OMEN);
                if (effect != null) {
                    event.getPlayer().removePotionEffect(PotionEffectType.BAD_OMEN);
                }
            }
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        Material blockType = event.getBlock().getType();
        Chunk chunk = event.getBlock().getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (blockType == Material.SNOW) {
                if (!region.isWorldFlagSet(65536L)) {
                    event.setCancelled(true);
                }
            } else if (blockType == Material.ICE && !region.isWorldFlagSet(131072L)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        Chunk toChunk;
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        Chunk fromChunk = from.getChunk();
        if (fromChunk.equals((Object)(toChunk = to.getChunk()))) {
            return;
        }
        if (ChunksManager.isChunkClaimed(toChunk)) {
            Region fromRegion = ChunksManager.getRegionOwnsTheChunk(fromChunk);
            Region toRegion = ChunksManager.getRegionOwnsTheChunk(toChunk);
            if (fromRegion == null) {
                if (!toRegion.isWorldFlagSet(2048L)) {
                    event.getVehicle().remove();
                }
            } else if (!fromRegion.getUniqueId().equals(toRegion.getUniqueId()) && !toRegion.isWorldFlagSet(2048L)) {
                event.getVehicle().remove();
            }
        }
    }

    @EventHandler
    public void onWitherBlockChange(EntityChangeBlockEvent event) {
        Region region;
        Block block;
        Chunk chunk;
        Entity entity = event.getEntity();
        if ((entity.getType() == EntityType.WITHER || entity.getType() == EntityType.WITHER_SKULL) && ChunksManager.isChunkClaimed(chunk = (block = event.getBlock()).getChunk()) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(256L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSnowGolemTrail(EntityBlockFormEvent event) {
        Region region;
        Block block;
        Chunk chunk;
        Entity entity = event.getEntity();
        if (entity instanceof Snowman && ChunksManager.isChunkClaimed(chunk = (block = event.getBlock()).getChunk()) && (region = ChunksManager.getRegionOwnsTheChunk(chunk)) != null && !region.isWorldFlagSet(262144L)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTreeGrow(StructureGrowEvent event) {
        Region region;
        Chunk chunk = event.getLocation().getChunk();
        if (ChunksManager.isChunkClaimed(chunk) && !(region = ChunksManager.getRegionOwnsTheChunk(chunk)).isWorldFlagSet(4096L)) {
            event.setCancelled(true);
        }
    }

    private boolean isWearingElytra(Player player) {
        return player.getInventory().getChestplate() != null && player.getInventory().getChestplate().getType() == Material.ELYTRA;
    }

    private boolean isCropBlock(Block block) {
        Material type = block.getType();
        return type == Material.WHEAT || type == Material.CARROTS || type == Material.POTATOES || type == Material.BEETROOTS || type == Material.PITCHER_PLANT || type == Material.NETHER_WART || type == Material.KELP || type == Material.CACTUS || type == Material.SEA_PICKLE || type == Material.RED_MUSHROOM || type == Material.BROWN_MUSHROOM || type == Material.SWEET_BERRIES || type == Material.SWEET_BERRY_BUSH;
    }
}

