/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class RegionLogsMenu {
    List<SerializableLog> logs;

    public RegionLogsMenu(Player player, Region region) {
        this.logs = region.getLogs();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(13), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region), (_player, event) -> new RegionMenu(player, region), (_player, context) -> {
            if (context.getIndex() >= this.logs.size()) {
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 32768L)) {
                return;
            }
            SerializableLog log = this.logs.get(context.getIndex());
            if (context.getEvent().isLeftClick()) {
                region.setLogAsRead(log.getId());
                PaginationMenu instance = context.getInstance();
                this.logs = region.getLogs();
                instance.setItems(this.getItems(player, region));
            } else if (context.getEvent().isRightClick()) {
                boolean isOwnerOrOperator;
                boolean bl = isOwnerOrOperator = PlayerUtils.isOperator(player) || region.getOwnerId().equals(player.getUniqueId());
                if (!isOwnerOrOperator) {
                    PlayerUtils.sendMessage(player, 159);
                    return;
                }
                region.removeLog(log.getId());
                PaginationMenu instance = context.getInstance();
                this.logs = region.getLogs();
                instance.setItems(this.getItems(player, region));
            }
        });
        gui.addActionButton(0, MenuUtils.getButton(46, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (region.getLogs().size() == 0) {
                PlayerUtils.sendMessage(player, 91);
                return;
            }
            for (SerializableLog log : region.getLogs()) {
                region.setLogAsRead(log.getId());
            }
            PlayerUtils.sendMessage(player, 92);
            Homestead.getInstance().runSyncTask(() -> new RegionLogsMenu(player, region));
        });
        gui.addActionButton(2, MenuUtils.getButton(41, new OfflinePlayer[0]), (_player, event) -> {
            boolean isOwnerOrOperator;
            if (!event.isLeftClick()) {
                return;
            }
            boolean bl = isOwnerOrOperator = PlayerUtils.isOperator(player) || region.getOwnerId().equals(player.getUniqueId());
            if (!isOwnerOrOperator) {
                PlayerUtils.sendMessage(player, 159);
                return;
            }
            if (region.getLogs().size() == 0) {
                PlayerUtils.sendMessage(player, 83);
                return;
            }
            region.setLogs(new ArrayList<SerializableLog>());
            PlayerUtils.sendMessage(player, 93);
            Homestead.getInstance().runSyncTask(() -> new RegionLogsMenu(player, region));
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.logs.size(); ++i) {
            SerializableLog log = this.logs.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{index}", String.valueOf(i + 1));
            replacements.put("{log-sentat}", Formatters.formatDate(log.getSentAt()));
            replacements.put("{log-author}", log.getAuthor());
            replacements.put("{log-message}", log.getMessage());
            items.add(MenuUtils.getButton(log.isRead() ? 40 : 39, replacements, new OfflinePlayer[0]));
        }
        return items;
    }
}

