/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.particles.ChunkParticlesSpawner;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation.DelayedTeleport;

public class RegionClaimedChunksMenu {
    private List<SerializableChunk> chunks;

    public RegionClaimedChunksMenu(Player player, Region region) {
        this.chunks = region.getChunks();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(11), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region), (_player, event) -> new RegionMenu(player, region), (_player, context) -> {
            if (context.getIndex() >= this.chunks.size()) {
                return;
            }
            SerializableChunk chunk = this.chunks.get(context.getIndex());
            if (context.getEvent().isRightClick()) {
                new DelayedTeleport(player, chunk.getBukkitLocation());
                return;
            }
            if (context.getEvent().isLeftClick() && ChunksManager.isChunkClaimed(chunk.getBukkitChunk()) && ChunksManager.getRegionOwnsTheChunk(chunk.getBukkitChunk()).getUniqueId().equals(region.getUniqueId())) {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 32L)) {
                    return;
                }
                int before = region.getChunks().size();
                ChunksManager.unclaimChunk(region.getUniqueId(), chunk.getBukkitChunk(), new OfflinePlayer[]{player});
                int after = region.getChunks().size();
                if (after < before) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{region}", region.getName());
                    PlayerUtils.sendMessage(player, 24, replacements);
                }
                if (region.getLocation() != null && region.getLocation().getBukkitLocation().getChunk().equals((Object)chunk.getBukkitChunk())) {
                    region.setLocation(null);
                }
                new ChunkParticlesSpawner(player);
                PaginationMenu instance = context.getInstance();
                this.chunks = region.getChunks();
                instance.setItems(this.getItems(player, region));
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }

    public List<ItemStack> getItems(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.chunks.size(); ++i) {
            SerializableChunk chunk = this.chunks.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{index}", String.valueOf(i + 1));
            replacements.put("{chunk-claimedat}", Formatters.formatDate(chunk.getClaimedAt()));
            replacements.put("{chunk-location}", Formatters.formatLocation(chunk.getBukkitLocation()));
            MenuUtils.ButtonData data = MenuUtils.getButtonData(33);
            if (data.getOriginalType().equals("CUSTOM::GETBYWORLD")) {
                switch (chunk.getBukkitLocation().getWorld().getEnvironment()) {
                    case NORMAL: {
                        data.originalType = (String)Homestead.menusConfig.get("button-types.world.overworld");
                        break;
                    }
                    case NETHER: {
                        data.originalType = (String)Homestead.menusConfig.get("button-types.world.nether");
                        break;
                    }
                    case THE_END: {
                        data.originalType = (String)Homestead.menusConfig.get("button-types.world.the_end");
                        break;
                    }
                    default: {
                        data.originalType = (String)Homestead.menusConfig.get("button-types.world.overworld");
                    }
                }
            }
            items.add(MenuUtils.getButton(data, replacements));
        }
        return items;
    }
}

