/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.RegionControlFlags;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMembersMenu;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class MemberRgControlFlagsMenu {
    private final HashSet<UUID> cooldowns = new HashSet();

    public MemberRgControlFlagsMenu(Player player, Region region, SerializableMember member) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String flagString : RegionControlFlags.getFlags()) {
            boolean value = FlagsCalculator.isFlagSet(member.getRegionControlFlags(), RegionControlFlags.valueOf(flagString));
            items.add(MenuUtils.getFlagButton(flagString, value));
        }
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(7).replace("{playername}", member.getBukkitOfflinePlayer().getName()), 45, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), items, (_player, event) -> new RegionMembersMenu(player, region), (_player, context) -> {
            boolean isOwnerOrOperator;
            if (this.cooldowns.contains(player.getUniqueId())) {
                return;
            }
            boolean bl = isOwnerOrOperator = PlayerUtils.isOperator(player) || region.getOwnerId().equals(player.getUniqueId());
            if (!isOwnerOrOperator) {
                PlayerUtils.sendMessage(player, 159);
                return;
            }
            String flagString = RegionControlFlags.getFlags().get(context.getIndex());
            List disabledFlags = (List)Homestead.config.get("disabled-flags");
            if (disabledFlags.contains(flagString)) {
                PlayerUtils.sendMessage(player, 42);
                return;
            }
            long flag = RegionControlFlags.valueOf(flagString);
            if (context.getEvent().isLeftClick()) {
                PaginationMenu instance = context.getInstance();
                long flags = member.getRegionControlFlags();
                boolean isSet = FlagsCalculator.isFlagSet(flags, flag);
                long newFlags = isSet ? FlagsCalculator.removeFlag(flags, flag) : FlagsCalculator.addFlag(flags, flag);
                region.setMemberRegionControlFlags(member, newFlags);
                this.cooldowns.add(player.getUniqueId());
                player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", flagString);
                replacements.put("{state}", Formatters.getFlag(!isSet));
                replacements.put("{region}", region.getName());
                replacements.put("{player}", member.getBukkitOfflinePlayer().getName());
                PlayerUtils.sendMessage(player, 43, replacements);
                instance.replaceSlot(context.getIndex(), MenuUtils.getFlagButton(flagString, !isSet));
                Homestead.getInstance().runAsyncTaskLater(() -> this.cooldowns.remove(player.getUniqueId()), 1);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

