/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public class WorldFlags {
    public static final long PASSIVE_ENTITIES_SPAWN = 1L;
    public static final long HOSTILE_ENTITIES_SPAWN = 2L;
    public static final long ENTITIES_GRIEF = 4L;
    public static final long ENTITIES_DAMAGE_ENTITIES = 8L;
    public static final long LEAVES_DECAY = 16L;
    public static final long FIRE_SPREAD = 32L;
    public static final long LIQUID_FLOW = 64L;
    public static final long EXPLOSIONS_DAMAGE = 128L;
    public static final long WITHER_DAMAGE = 256L;
    public static final long WILDERNESS_PISTONS = 512L;
    public static final long WILDERNESS_DISPENSERS = 1024L;
    public static final long WILDERNESS_MINECARTS = 2048L;
    public static final long PLANT_GROWTH = 4096L;
    public static final long GRASS_GROWTH = 8192L;
    public static final long SCULK_SPREAD = 16384L;
    public static final long PLAYER_GLOWING = 32768L;
    public static final long SNOW_MELTING = 65536L;
    public static final long ICE_MELTING = 131072L;
    public static final long SNOWMAN_TRAILS = 262144L;
    public static final long WINDCHARGE_BURST = 524288L;
    public static final long WILDERNESS_COPPER_GOLEMS = 0x100000L;
    public static final long WARS = 0x200000L;

    public static List<String> getFlags() {
        return Lists.newArrayList((Object[])new String[]{"passive-entities-spawn", "hostile-entities-spawn", "entities-grief", "entities-damage-entities", "leaves-decay", "fire-spread", "liquid-flow", "explosions-damage", "wither-damage", "wilderness-pistons", "wilderness-dispensers", "wilderness-minecarts", "plant-growth", "grass-growth", "sculk-spread", "player-glowing", "snow-melting", "ice-melting", "snowman-trails", "windcharge-burst", "wilderness-copper-golems", "wars"});
    }

    public static long valueOf(String name) {
        List<String> flags = WorldFlags.getFlags();
        if (flags.indexOf(name) == 0) {
            return 1L;
        }
        return 1L << flags.indexOf(name);
    }

    public static String from(long flag) {
        List<String> flags = WorldFlags.getFlags();
        for (int i = 0; i < flags.size(); ++i) {
            long value = WorldFlags.valueOf(flags.get(i));
            if (value != flag) continue;
            return flags.get(i);
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        List<String> allFlags = WorldFlags.getFlags();
        ArrayList<String> enabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = WorldFlags.valueOf(flag);
            if (!FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            enabledFlags.add(flag);
        }
        return enabledFlags;
    }

    public static List<String> getUnset(long flags) {
        List<String> allFlags = WorldFlags.getFlags();
        ArrayList<String> disabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = WorldFlags.valueOf(flag);
            if (FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            disabledFlags.add(flag);
        }
        return disabledFlags;
    }
}

