/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;

public class MariaDB {
    private static final String JDBC_URL = "jdbc:mariadb://";
    private Connection connection;

    public MariaDB(String username, String password, String host, int port) {
        this(username, password, host, port, false);
    }

    public MariaDB(String username, String password, String host, int port, boolean handleError) {
        block4: {
            try {
                Class.forName("org.mariadb.jdbc.Driver");
                String url = JDBC_URL + host + ":" + port + "/homestead_data?allowPublicKeyRetrieval=true&useSSL=false&serverTimezone=UTC";
                this.connection = DriverManager.getConnection(url, username, password);
                Logger.info("MariaDB database connection established.");
                this.createTablesIfNotExists();
                this.createWarsTableIfNotExists();
            }
            catch (ClassNotFoundException e) {
                Logger.error("MariaDB JDBC Driver not found.");
                e.printStackTrace();
                if (!handleError) {
                    Homestead.getInstance().endInstance();
                }
            }
            catch (SQLException e) {
                Logger.error("Unable to establish connection to MariaDB.");
                e.printStackTrace();
                if (handleError) break block4;
                Homestead.getInstance().endInstance();
            }
        }
    }

    private static String toPgTextArray(String[] src) {
        return "{" + String.join((CharSequence)",", src) + "}";
    }

    private static String[] stringArrayFromPgText(String pg) {
        if (pg == null || pg.isEmpty()) {
            return new String[0];
        }
        return pg.replaceAll("^\\{|\\}$", "").split(",", -1);
    }

    private static List<OfflinePlayer> uuidArrayFromPgText(String pg) {
        return Arrays.stream(MariaDB.stringArrayFromPgText(pg)).map(id -> Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(id))).collect(Collectors.toList());
    }

    public void createTablesIfNotExists() {
        String sql = "    CREATE TABLE IF NOT EXISTS regions (\n        id              CHAR(36) PRIMARY KEY,\n        display_name    TEXT NOT NULL,\n        name            TEXT NOT NULL,\n        description     TEXT NOT NULL,\n        owner_id        CHAR(36) NOT NULL,\n        location        TEXT,\n        created_at      BIGINT NOT NULL,\n        player_flags    BIGINT NOT NULL,\n        world_flags     BIGINT NOT NULL,\n        bank            DOUBLE PRECISION NOT NULL,\n        map_color       INT NOT NULL,\n        chunks          TEXT NOT NULL,\n        members         TEXT NOT NULL,\n        rates           TEXT NOT NULL,\n        invited_players TEXT NOT NULL,\n        banned_players  TEXT NOT NULL,\n        sub_areas       TEXT NOT NULL,\n        logs            TEXT NOT NULL,\n        rent            TEXT,\n        upkeep_at       BIGINT NOT NULL,\n        taxes_amount    DOUBLE NOT NULL,\n        weather         INT NOT NULL,\n        time            INT NOT NULL,\n        welcome_sign    TEXT,\n        icon            TEXT\n    )\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
            Logger.info("Regions table created/verified in MariaDB.");
        }
        catch (SQLException e) {
            Logger.error("Unable to create regions table in MariaDB.");
            e.printStackTrace();
        }
    }

    public void importRegions() {
        String sql = "SELECT * FROM regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM regions");){
            Homestead.regionsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                OfflinePlayer owner = Homestead.getInstance().getOfflinePlayerSync(UUID.fromString(rs.getString("owner_id")));
                SerializableLocation location = Optional.ofNullable(rs.getString("location")).map(SerializableLocation::fromString).orElse(null);
                long createdAt = rs.getLong("created_at");
                long playerFlags = rs.getLong("player_flags");
                long worldFlags = rs.getLong("world_flags");
                double bank = rs.getDouble("bank");
                int mapColor = rs.getInt("map_color");
                List<SerializableChunk> chunks = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("chunks"))).map(SerializableChunk::fromString).collect(Collectors.toList());
                List<SerializableMember> members = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("members"))).map(SerializableMember::fromString).collect(Collectors.toList());
                List<SerializableRate> rates = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("rates"))).map(SerializableRate::fromString).collect(Collectors.toList());
                List<OfflinePlayer> invitedPlayers = MariaDB.uuidArrayFromPgText(rs.getString("invited_players"));
                List<SerializableBannedPlayer> bannedPlayers = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("banned_players"))).map(SerializableBannedPlayer::fromString).collect(Collectors.toList());
                List<SerializableLog> logs = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("logs"))).map(SerializableLog::fromString).collect(Collectors.toList());
                List<SerializableSubArea> subAreas = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("sub_areas"))).map(SerializableSubArea::fromString).collect(Collectors.toList());
                SerializableRent rent = Optional.ofNullable(rs.getString("rent")).map(SerializableRent::fromString).orElse(null);
                long upkeepAt = rs.getLong("upkeep_at");
                double taxesAmount = rs.getDouble("taxes_amount");
                int weather = rs.getInt("weather");
                int time = rs.getInt("time");
                SerializableLocation welcomeSign = Optional.ofNullable(rs.getString("welcome_sign")).map(SerializableLocation::fromString).orElse(null);
                String icon = rs.getString("icon");
                if (owner == null) continue;
                Region region = new Region(name, owner);
                region.id = id;
                region.displayName = displayName;
                region.description = description;
                region.location = location;
                region.createdAt = createdAt;
                region.playerFlags = playerFlags;
                region.worldFlags = worldFlags;
                region.bank = bank;
                region.mapColor = mapColor;
                region.setChunks(chunks);
                region.setMembers(members);
                region.setRates(rates);
                region.setInvitedPlayers(ListUtils.removeNullElements(invitedPlayers));
                region.setBannedPlayers(bannedPlayers);
                region.setLogs(logs);
                region.setSubAreas(subAreas);
                region.rent = rent;
                region.upkeepAt = upkeepAt;
                region.taxesAmount = taxesAmount;
                region.weather = weather;
                region.time = time;
                region.welcomeSign = welcomeSign;
                region.icon = icon;
                Homestead.regionsCache.putOrUpdate(region);
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to import regions from MariaDB.");
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.regionsCache.size() + " regions from MariaDB.");
    }

    public void createWarsTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS wars (\n    id          CHAR(36) PRIMARY KEY,\n    display_name TEXT NOT NULL,\n    name        TEXT NOT NULL,\n    description TEXT NOT NULL,\n    regions     TEXT NOT NULL,\n    prize       DOUBLE PRECISION NOT NULL,\n    started_at  BIGINT NOT NULL\n)\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
            Logger.info("Wars table created/verified in MariaDB.");
        }
        catch (SQLException e) {
            Logger.error("Unable to create wars table in MariaDB.");
            e.printStackTrace();
        }
    }

    public void importWars() {
        String sql = "SELECT * FROM wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM wars");){
            Homestead.warsCache.clear();
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                String displayName = rs.getString("display_name");
                String name = rs.getString("name");
                String description = rs.getString("description");
                List<UUID> regions = Arrays.stream(MariaDB.stringArrayFromPgText(rs.getString("regions"))).map(UUID::fromString).collect(Collectors.toList());
                double prize = rs.getDouble("prize");
                long startedAt = rs.getLong("started_at");
                War war = new War(name, regions);
                war.id = id;
                war.displayName = displayName;
                war.description = description;
                war.prize = prize;
                war.startedAt = startedAt;
                Homestead.warsCache.putOrUpdate(war);
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to import wars from MariaDB.");
            e.printStackTrace();
        }
        Logger.info("Imported " + Homestead.warsCache.size() + " wars from MariaDB.");
    }

    public void exportRegions() {
        HashSet<UUID> dbRegionIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM regions";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT id FROM regions");){
            while (rs.next()) {
                dbRegionIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to fetch region IDs from MariaDB.");
            e.printStackTrace();
            return;
        }
        String upsertSql = "    INSERT INTO regions (\n        id, display_name, name, description, owner_id, location, created_at,\n        player_flags, world_flags, bank, map_color, chunks, members, rates,\n        invited_players, banned_players, sub_areas, logs, rent, upkeep_at,\n        taxes_amount, weather, time, welcome_sign, icon\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        display_name = VALUES(display_name),\n        name = VALUES(name),\n        description = VALUES(description),\n        owner_id = VALUES(owner_id),\n        location = VALUES(location),\n        created_at = VALUES(created_at),\n        player_flags = VALUES(player_flags),\n        world_flags = VALUES(world_flags),\n        bank = VALUES(bank),\n        map_color = VALUES(map_color),\n        chunks = VALUES(chunks),\n        members = VALUES(members),\n        rates = VALUES(rates),\n        invited_players = VALUES(invited_players),\n        banned_players = VALUES(banned_players),\n        sub_areas = VALUES(sub_areas),\n        logs = VALUES(logs),\n        rent = VALUES(rent),\n        upkeep_at = VALUES(upkeep_at),\n        taxes_amount = VALUES(taxes_amount),\n        weather = VALUES(weather),\n        time = VALUES(time),\n        welcome_sign = VALUES(welcome_sign),\n        icon = VALUES(icon)\n";
        String deleteSql = "DELETE FROM regions WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement("    INSERT INTO regions (\n        id, display_name, name, description, owner_id, location, created_at,\n        player_flags, world_flags, bank, map_color, chunks, members, rates,\n        invited_players, banned_players, sub_areas, logs, rent, upkeep_at,\n        taxes_amount, weather, time, welcome_sign, icon\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        display_name = VALUES(display_name),\n        name = VALUES(name),\n        description = VALUES(description),\n        owner_id = VALUES(owner_id),\n        location = VALUES(location),\n        created_at = VALUES(created_at),\n        player_flags = VALUES(player_flags),\n        world_flags = VALUES(world_flags),\n        bank = VALUES(bank),\n        map_color = VALUES(map_color),\n        chunks = VALUES(chunks),\n        members = VALUES(members),\n        rates = VALUES(rates),\n        invited_players = VALUES(invited_players),\n        banned_players = VALUES(banned_players),\n        sub_areas = VALUES(sub_areas),\n        logs = VALUES(logs),\n        rent = VALUES(rent),\n        upkeep_at = VALUES(upkeep_at),\n        taxes_amount = VALUES(taxes_amount),\n        weather = VALUES(weather),\n        time = VALUES(time),\n        welcome_sign = VALUES(welcome_sign),\n        icon = VALUES(icon)\n");
             PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM regions WHERE id = ?");){
            HashSet<UUID> cacheRegionIds = new HashSet<UUID>();
            for (Region region : Homestead.regionsCache.getAll()) {
                UUID regionId = region.id;
                cacheRegionIds.add(regionId);
                upsertStmt.setString(1, regionId.toString());
                upsertStmt.setString(2, region.displayName);
                upsertStmt.setString(3, region.name);
                upsertStmt.setString(4, region.description);
                upsertStmt.setString(5, region.getOwnerId().toString());
                upsertStmt.setString(6, region.location == null ? null : region.location.toString());
                upsertStmt.setLong(7, region.createdAt);
                upsertStmt.setLong(8, region.playerFlags);
                upsertStmt.setLong(9, region.worldFlags);
                upsertStmt.setDouble(10, region.bank);
                upsertStmt.setInt(11, region.mapColor);
                upsertStmt.setString(12, MariaDB.toPgTextArray((String[])region.chunks.stream().map(SerializableChunk::toString).toArray(String[]::new)));
                upsertStmt.setString(13, MariaDB.toPgTextArray((String[])region.members.stream().map(SerializableMember::toString).toArray(String[]::new)));
                upsertStmt.setString(14, MariaDB.toPgTextArray((String[])region.rates.stream().map(SerializableRate::toString).toArray(String[]::new)));
                upsertStmt.setString(15, MariaDB.toPgTextArray((String[])region.getInvitedPlayers().stream().map(p -> p.getUniqueId().toString()).toArray(String[]::new)));
                upsertStmt.setString(16, MariaDB.toPgTextArray((String[])region.bannedPlayers.stream().map(SerializableBannedPlayer::toString).toArray(String[]::new)));
                upsertStmt.setString(17, MariaDB.toPgTextArray((String[])region.logs.stream().map(SerializableLog::toString).toArray(String[]::new)));
                upsertStmt.setString(18, MariaDB.toPgTextArray((String[])region.subAreas.stream().map(SerializableSubArea::toString).toArray(String[]::new)));
                upsertStmt.setString(19, region.rent == null ? null : region.rent.toString());
                upsertStmt.setLong(20, region.upkeepAt);
                upsertStmt.setDouble(21, region.taxesAmount);
                upsertStmt.setInt(22, region.weather);
                upsertStmt.setInt(23, region.time);
                upsertStmt.setString(24, region.welcomeSign == null ? null : region.welcomeSign.toString());
                upsertStmt.setString(25, region.icon);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbRegionIds.removeAll(cacheRegionIds);
            for (UUID deletedId : dbRegionIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheRegionIds.size() + " regions and deleted " + dbRegionIds.size() + " regions from MariaDB.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to export regions to MariaDB.");
            e.printStackTrace();
        }
    }

    public void exportWars() {
        HashSet<UUID> dbWarIds = new HashSet<UUID>();
        String selectSql = "SELECT id FROM wars";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT id FROM wars");){
            while (rs.next()) {
                dbWarIds.add(UUID.fromString(rs.getString("id")));
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to fetch war IDs from MariaDB.");
            e.printStackTrace();
            return;
        }
        String upsertSql = "INSERT INTO wars (\n    id, display_name, name, description, regions, prize, started_at\n) VALUES (?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    display_name = VALUES(display_name),\n    name = VALUES(name),\n    description = VALUES(description),\n    regions = VALUES(regions),\n    prize = VALUES(prize),\n    started_at = VALUES(started_at)\n";
        String deleteSql = "DELETE FROM wars WHERE id = ?";
        try (PreparedStatement upsertStmt = this.connection.prepareStatement("INSERT INTO wars (\n    id, display_name, name, description, regions, prize, started_at\n) VALUES (?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    display_name = VALUES(display_name),\n    name = VALUES(name),\n    description = VALUES(description),\n    regions = VALUES(regions),\n    prize = VALUES(prize),\n    started_at = VALUES(started_at)\n");
             PreparedStatement deleteStmt = this.connection.prepareStatement("DELETE FROM wars WHERE id = ?");){
            HashSet<UUID> cacheWarIds = new HashSet<UUID>();
            for (War war : Homestead.warsCache.getAll()) {
                UUID warId = war.id;
                cacheWarIds.add(warId);
                upsertStmt.setString(1, warId.toString());
                upsertStmt.setString(2, war.displayName);
                upsertStmt.setString(3, war.name);
                upsertStmt.setString(4, war.description);
                upsertStmt.setString(5, MariaDB.toPgTextArray((String[])war.regions.stream().map(UUID::toString).toArray(String[]::new)));
                upsertStmt.setDouble(6, war.prize);
                upsertStmt.setLong(7, war.startedAt);
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
            dbWarIds.removeAll(cacheWarIds);
            for (UUID deletedId : dbWarIds) {
                deleteStmt.setString(1, deletedId.toString());
                deleteStmt.addBatch();
            }
            deleteStmt.executeBatch();
            if (Homestead.config.isDebugEnabled()) {
                Logger.info("Exported " + cacheWarIds.size() + " wars and deleted " + dbWarIds.size() + " wars from MariaDB.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to export wars to MariaDB.");
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Logger.warning("MariaDB connection has been closed.");
            }
        }
        catch (SQLException e) {
            Logger.error("Unable to close MariaDB connection.");
            e.printStackTrace();
        }
    }

    public long getLatency() {
        long before = System.currentTimeMillis();
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT 1");){
            while (rs.next()) {
            }
        }
        catch (SQLException e) {
            return -1L;
        }
        return System.currentTimeMillis() - before;
    }
}

