/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.database;

import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.database.providers.MariaDB;
import tfagaming.projects.minecraft.homestead.database.providers.MySQL;
import tfagaming.projects.minecraft.homestead.database.providers.PostgreSQL;
import tfagaming.projects.minecraft.homestead.database.providers.SQLite;
import tfagaming.projects.minecraft.homestead.database.providers.YAML;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class Database {
    private final Provider provider;
    private PostgreSQL postgreSQL;
    private MariaDB mariaDB;
    private MySQL mySQL;
    private SQLite sqLite;
    private YAML yaml;

    public Database(Provider provider) {
        this.provider = provider;
        Logger.warning("Attempting to connect to database... Provider:", provider.toString());
        switch (provider.ordinal()) {
            case 0: {
                this.postgreSQL = new PostgreSQL((String)Homestead.config.get("database.postgresql.username"), (String)Homestead.config.get("database.postgresql.password"), (String)Homestead.config.get("database.postgresql.host"), (Integer)Homestead.config.get("database.postgresql.port"));
                break;
            }
            case 1: {
                this.mariaDB = new MariaDB((String)Homestead.config.get("database.mariadb.username"), (String)Homestead.config.get("database.mariadb.password"), (String)Homestead.config.get("database.mariadb.host"), (Integer)Homestead.config.get("database.mariadb.port"));
                break;
            }
            case 2: {
                this.mySQL = new MySQL((String)Homestead.config.get("database.mysql.username"), (String)Homestead.config.get("database.mysql.password"), (String)Homestead.config.get("database.mysql.host"), (Integer)Homestead.config.get("database.mysql.port"));
                break;
            }
            case 3: {
                this.sqLite = new SQLite((String)Homestead.config.get("database.sqlite"));
                break;
            }
            case 4: {
                this.yaml = new YAML(Homestead.getInstance().getDataFolder());
                break;
            }
        }
    }

    public Database(Provider provider, boolean handleError) {
        this.provider = provider;
        Logger.warning("Attempting to connect to database... Provider:", provider.toString());
        switch (provider.ordinal()) {
            case 0: {
                this.postgreSQL = new PostgreSQL((String)Homestead.config.get("database.postgresql.username"), (String)Homestead.config.get("database.postgresql.password"), (String)Homestead.config.get("database.postgresql.host"), (Integer)Homestead.config.get("database.postgresql.port"), handleError);
                break;
            }
            case 1: {
                this.mariaDB = new MariaDB((String)Homestead.config.get("database.mariadb.username"), (String)Homestead.config.get("database.mariadb.password"), (String)Homestead.config.get("database.mariadb.host"), (Integer)Homestead.config.get("database.mariadb.port"), handleError);
                break;
            }
            case 2: {
                this.mySQL = new MySQL((String)Homestead.config.get("database.mysql.username"), (String)Homestead.config.get("database.mysql.password"), (String)Homestead.config.get("database.mysql.host"), (Integer)Homestead.config.get("database.mysql.port"), handleError);
                break;
            }
            case 3: {
                this.sqLite = new SQLite((String)Homestead.config.get("database.sqlite"), handleError);
                break;
            }
            case 4: {
                this.yaml = new YAML(Homestead.getInstance().getDataFolder());
                break;
            }
        }
    }

    public static Provider parseProviderFromString(String provider) {
        return switch (provider.toLowerCase()) {
            case "postgresql" -> Provider.PostgreSQL;
            case "mariadb" -> Provider.MariaDB;
            case "mysql" -> Provider.MySQL;
            case "sqlite" -> Provider.SQLite;
            case "yaml" -> Provider.YAML;
            default -> null;
        };
    }

    public String getSelectedProvider() {
        return this.provider.toString();
    }

    public void importRegions() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importRegions();
                break;
            }
            case 1: {
                this.mariaDB.importRegions();
                break;
            }
            case 2: {
                this.mySQL.importRegions();
                break;
            }
            case 3: {
                this.sqLite.importRegions();
                break;
            }
            case 4: {
                this.yaml.importRegions();
                break;
            }
        }
    }

    public void importWars() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.importWars();
                break;
            }
            case 1: {
                this.mariaDB.importWars();
                break;
            }
            case 2: {
                this.mySQL.importWars();
                break;
            }
            case 3: {
                this.sqLite.importWars();
                break;
            }
            case 4: {
                this.yaml.importWars();
                break;
            }
        }
    }

    public void exportRegions() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportRegions();
                break;
            }
            case 1: {
                this.mariaDB.exportRegions();
                break;
            }
            case 2: {
                this.mySQL.exportRegions();
                break;
            }
            case 3: {
                this.sqLite.exportRegions();
                break;
            }
            case 4: {
                this.yaml.exportRegions();
                break;
            }
        }
    }

    public void exportWars() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.exportWars();
                break;
            }
            case 1: {
                this.mariaDB.exportWars();
                break;
            }
            case 2: {
                this.mySQL.exportWars();
                break;
            }
            case 3: {
                this.sqLite.exportWars();
                break;
            }
            case 4: {
                this.yaml.exportWars();
                break;
            }
        }
    }

    public void closeConnection() {
        switch (this.provider.ordinal()) {
            case 0: {
                this.postgreSQL.closeConnection();
                break;
            }
            case 1: {
                this.mariaDB.closeConnection();
                break;
            }
            case 2: {
                this.mySQL.closeConnection();
                break;
            }
            case 3: {
                this.sqLite.closeConnection();
                break;
            }
            case 4: {
                this.yaml.closeConnection();
                break;
            }
        }
    }

    public long getLatency() {
        return switch (this.provider.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.postgreSQL.getLatency();
            case 1 -> this.mariaDB.getLatency();
            case 2 -> this.mySQL.getLatency();
            case 3 -> this.sqLite.getLatency();
            case 4 -> this.yaml.getLatency();
        };
    }

    public static enum Provider {
        PostgreSQL,
        MariaDB,
        MySQL,
        SQLite,
        YAML;

    }
}

