/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands.subcommands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.commands.SubCommandBuilder;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.NumberUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class WarSubCmd
extends SubCommandBuilder {
    public WarSubCmd() {
        super("war");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homestead.region.war")) {
            PlayerUtils.sendMessage(player, 8);
            return true;
        }
        boolean isEnabled = (Boolean)Homestead.config.get("wars.enabled");
        if (!isEnabled) {
            PlayerUtils.sendMessage(player, 105);
            return true;
        }
        if (args.length < 2) {
            PlayerUtils.sendMessage(player, 0);
            return true;
        }
        if (!Homestead.vault.isEconomyReady()) {
            PlayerUtils.sendMessage(player, 69);
            Logger.warning("The player \"" + player.getName() + "\" (UUID: " + String.valueOf(player.getUniqueId()) + ") executed a command that requires economy implementation, but it's disabled.");
            Logger.warning("The execution has been ignored, you may resolve this issue by installing a plugin that implements economy on the server.");
            return true;
        }
        switch (args[1]) {
            case "declare": {
                Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                if (region != null && WarsManager.isRegionInWar(region.getUniqueId())) {
                    PlayerUtils.sendMessage(player, 151);
                    return false;
                }
                if (args.length < 4) {
                    PlayerUtils.sendMessage(player, 0);
                    return true;
                }
                if (region == null) {
                    PlayerUtils.sendMessage(player, 4);
                    return false;
                }
                String targetRegionName = args[2];
                Region targetRegion = RegionsManager.findRegion(targetRegionName);
                if (targetRegion == null) {
                    PlayerUtils.sendMessage(player, 9);
                    return true;
                }
                if (!region.getOwnerId().equals(player.getUniqueId()) && region.isPlayerMember((OfflinePlayer)player)) {
                    PlayerUtils.sendMessage(player, 149);
                    return false;
                }
                if (region.getUniqueId().equals(targetRegion.getUniqueId()) || region.getOwnerId().equals(targetRegion.getOwnerId())) {
                    PlayerUtils.sendMessage(player, 148);
                    return false;
                }
                if (!region.isWorldFlagSet(0x200000L) || !targetRegion.isWorldFlagSet(0x200000L)) {
                    PlayerUtils.sendMessage(player, 164);
                    return false;
                }
                if (WarsManager.isRegionInWar(targetRegion.getUniqueId())) {
                    PlayerUtils.sendMessage(player, 150);
                    return false;
                }
                String prizeInput = args[3];
                if (!NumberUtils.isValidDouble(prizeInput) || NumberUtils.isValidDouble(prizeInput) && Double.parseDouble(prizeInput) > 2.147483647E9) {
                    PlayerUtils.sendMessage(player, 146);
                    return true;
                }
                double prize = Double.parseDouble(prizeInput);
                double minPrize = (Double)Homestead.config.get("wars.min-prize");
                double maxPrize = (Double)Homestead.config.get("wars.max-prize");
                if (prize < minPrize || prize > maxPrize) {
                    PlayerUtils.sendMessage(player, 160);
                    return true;
                }
                if (!(targetRegion.getBank() >= prize) || !(region.getBank() >= prize)) {
                    PlayerUtils.sendMessage(player, 157);
                    return true;
                }
                List<String> nameList = Arrays.asList(args).subList(4, args.length);
                String name = String.join((CharSequence)" ", nameList);
                if (name.isEmpty()) {
                    name = "Unnamed War";
                }
                if (name.length() > 512) {
                    PlayerUtils.sendMessage(player, 145);
                    return true;
                }
                War war = WarsManager.declareWar(name, prize, List.of(region, targetRegion));
                List listString = (List)Homestead.language.get("147");
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{war-name}", war.getName());
                replacements.put("{regionplayer}", region.getName());
                replacements.put("{regiontarget}", targetRegion.getName());
                replacements.put("{prize}", Formatters.formatBalance(prize));
                List<OfflinePlayer> players = WarsManager.getMembersOfWar(war.getUniqueId());
                for (OfflinePlayer p : players) {
                    if (!p.isOnline()) continue;
                    Player player1 = (Player)p;
                    player1.playSound(player1.getLocation(), Sound.EVENT_MOB_EFFECT_RAID_OMEN, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    for (String string : listString) {
                        player1.sendMessage(ChatColorTranslator.translate(Formatters.replace(string, replacements)));
                    }
                }
                break;
            }
            case "surrender": {
                if (args.length < 2) {
                    PlayerUtils.sendMessage(player, 0);
                    return true;
                }
                Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                if (region == null) {
                    PlayerUtils.sendMessage(player, 4);
                    return false;
                }
                if (!WarsManager.isRegionInWar(region.getUniqueId())) {
                    PlayerUtils.sendMessage(player, 152);
                    return true;
                }
                War war = WarsManager.surrenderRegionFromFirstWarFound(region.getUniqueId());
                if (war != null && war.getRegions().size() == 1) {
                    Region winner = war.getRegions().getFirst();
                    double prize = war.getPrize();
                    region.removeBalanceFromBank(prize);
                    winner.addBalanceToBank(prize);
                    if (winner.getOwner().isOnline()) {
                        PlayerUtils.sendMessage((Player)winner.getOwner(), 155);
                    }
                    WarsManager.endWar(war.getUniqueId());
                }
                PlayerUtils.sendMessage(player, 153);
                break;
            }
            case "info": {
                Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                if (region == null) {
                    PlayerUtils.sendMessage(player, 4);
                    return false;
                }
                War war = WarsManager.findWarByRegionId(region.getUniqueId());
                if (!WarsManager.isRegionInWar(region.getUniqueId()) || war == null) {
                    PlayerUtils.sendMessage(player, 152);
                    return true;
                }
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{regions}", Formatters.getRegionsOfWar(war));
                replacements.put("{prize}", Formatters.formatBalance(war.prize));
                PlayerUtils.sendMessage(player, 154, replacements);
            }
        }
        return true;
    }
}

