/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.AcceptInviteSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.AutoSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.BalanceSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.BanPlayerSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.BanlistSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.ChatSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.ClaimlistSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.CreateRegionSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.DeleteRegionSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.DenyInviteSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.DepositBankSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.FlagsSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.HelpSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.HomeSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.KickPlayerSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.LogsSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.MailSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.MembersSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.MenuSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.PlayerInfoSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RegionBordersSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RegionInfoSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RegionRateSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RegionTopSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RenameRegionSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.RewardsSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.SetRegionSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.SubAreasSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.TrustPlayerSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.UnbanPlayerSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.UntrustPlayerSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.VisitRegionSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.WarSubCmd;
import tfagaming.projects.minecraft.homestead.commands.commands.subcommands.WithdrawBankSubCmd;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.WorldFlags;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionsMenu;
import tfagaming.projects.minecraft.homestead.integrations.maps.RegionIconTools;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.commands.AutoCompleteFilter;
import tfagaming.projects.minecraft.homestead.tools.java.StringSimilarity;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.plugins.MapColor;

public class RegionCommand
extends CommandBuilder {
    public RegionCommand() {
        super("region", "rg", "hs", "homestead");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You cannot use this command via the console.");
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            new RegionsMenu(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (this.getSubcommands().contains(subCommand) && !player.hasPermission("homestead.commands.region." + subCommand)) {
            PlayerUtils.sendMessage(player, 8);
            return true;
        }
        switch (subCommand) {
            case "create": {
                new CreateRegionSubCmd().onExecution(sender, args);
                break;
            }
            case "delete": {
                new DeleteRegionSubCmd().onExecution(sender, args);
                break;
            }
            case "set": {
                new SetRegionSubCmd().onExecution(sender, args);
                break;
            }
            case "rename": {
                new RenameRegionSubCmd().onExecution(sender, args);
                break;
            }
            case "borders": {
                new RegionBordersSubCmd().onExecution(sender, args);
                break;
            }
            case "ban": {
                new BanPlayerSubCmd().onExecution(sender, args);
                break;
            }
            case "unban": {
                new UnbanPlayerSubCmd().onExecution(sender, args);
                break;
            }
            case "trust": {
                new TrustPlayerSubCmd().onExecution(sender, args);
                break;
            }
            case "untrust": {
                new UntrustPlayerSubCmd().onExecution(sender, args);
                break;
            }
            case "flags": {
                new FlagsSubCmd().onExecution(sender, args);
                break;
            }
            case "accept": {
                new AcceptInviteSubCmd().onExecution(sender, args);
                break;
            }
            case "deny": {
                new DenyInviteSubCmd().onExecution(sender, args);
                break;
            }
            case "visit": {
                new VisitRegionSubCmd().onExecution(sender, args);
                break;
            }
            case "subareas": {
                new SubAreasSubCmd().onExecution(sender, args);
                break;
            }
            case "deposit": {
                new DepositBankSubCmd().onExecution(sender, args);
                break;
            }
            case "withdraw": {
                new WithdrawBankSubCmd().onExecution(sender, args);
                break;
            }
            case "menu": {
                new MenuSubCmd().onExecution(sender, args);
                break;
            }
            case "player": {
                new PlayerInfoSubCmd().onExecution(sender, args);
                break;
            }
            case "home": {
                new HomeSubCmd().onExecution(sender, args);
                break;
            }
            case "info": {
                new RegionInfoSubCmd().onExecution(sender, args);
                break;
            }
            case "banlist": {
                new BanlistSubCmd().onExecution(sender, args);
                break;
            }
            case "members": {
                new MembersSubCmd().onExecution(sender, args);
                break;
            }
            case "claimlist": {
                new ClaimlistSubCmd().onExecution(sender, args);
                break;
            }
            case "help": {
                new HelpSubCmd().onExecution(sender, args);
                break;
            }
            case "logs": {
                new LogsSubCmd().onExecution(sender, args);
                break;
            }
            case "rate": {
                new RegionRateSubCmd().onExecution(sender, args);
                break;
            }
            case "top": {
                new RegionTopSubCmd().onExecution(sender, args);
                break;
            }
            case "auto": {
                new AutoSubCmd().onExecution(sender, args);
                break;
            }
            case "kick": {
                new KickPlayerSubCmd().onExecution(sender, args);
                break;
            }
            case "war": {
                new WarSubCmd().onExecution(sender, args);
                break;
            }
            case "chat": {
                new ChatSubCmd().onExecution(sender, args);
                break;
            }
            case "mail": {
                new MailSubCmd().onExecution(sender, args);
                break;
            }
            case "balance": {
                new BalanceSubCmd().onExecution(sender, args);
                break;
            }
            case "rewards": {
                new RewardsSubCmd().onExecution(sender, args);
                break;
            }
            default: {
                String similaritySubCmds = StringSimilarity.findTopSimilarStrings(this.getSubcommands(), subCommand).stream().collect(Collectors.joining(", "));
                if (sender instanceof Player) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{similarity-subcmds}", similaritySubCmds);
                    PlayerUtils.sendMessage(player, 7, replacements);
                    break;
                }
                sender.sendMessage(new String[]{"Unknown sub-command, maybe you meant...", similaritySubCmds});
            }
        }
        return true;
    }

    @Override
    public List<String> onAutoComplete(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Lists.newArrayList();
        }
        Player player = (Player)sender;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            List subcommands = this.getSubcommands().stream().filter(cmd -> cmd.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            for (String subcommand : subcommands) {
                if (!player.hasPermission("homestead.commands.region." + subcommand)) continue;
                suggestions.add(subcommand);
            }
            return suggestions;
        }
        if (this.getSubcommands().contains(args[0].toLowerCase()) && !player.hasPermission("homestead.commands.region." + args[0].toLowerCase())) {
            return new ArrayList<String>();
        }
        switch (args[0].toLowerCase()) {
            case "borders": {
                if (args.length != 2) break;
                suggestions.add("stop");
                break;
            }
            case "delete": {
                if (args.length != 2) break;
                suggestions.add("confirm");
                break;
            }
            case "set": {
                if (args.length == 2) {
                    suggestions.addAll(List.of("displayname", "target", "description", "mapcolor", "spawn", "icon", "tax"));
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("target")) {
                    suggestions.addAll(RegionsManager.getRegionsOwnedByPlayer((OfflinePlayer)player).stream().map(Region::getName).toList());
                    suggestions.addAll(RegionsManager.getRegionsHasPlayerAsMember((OfflinePlayer)player).stream().map(Region::getName).toList());
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("mapcolor")) {
                    suggestions.addAll(MapColor.getAll());
                    break;
                }
                if (args.length != 3 || !args[1].equalsIgnoreCase("icon")) break;
                suggestions.addAll(RegionIconTools.getAllIcons());
                suggestions.add("Default");
                break;
            }
            case "kick": {
                if (args.length != 2) break;
                suggestions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
                break;
            }
            case "ban": {
                if (args.length != 2) break;
                suggestions.addAll(Homestead.getInstance().getOfflinePlayersSync().stream().map(OfflinePlayer::getName).toList());
                break;
            }
            case "unban": {
                Region region;
                if (args.length != 2 || (region = TargetRegionSession.getRegion((OfflinePlayer)player)) == null) break;
                for (SerializableBannedPlayer bannedPlayer : region.getBannedPlayers()) {
                    OfflinePlayer bukkitBannedPlayer = bannedPlayer.getBukkitOfflinePlayer();
                    if (bukkitBannedPlayer == null) continue;
                    suggestions.add(bukkitBannedPlayer.getName());
                }
                break;
            }
            case "player": 
            case "trust": {
                if (args.length != 2) break;
                suggestions.addAll(Homestead.getInstance().getOfflinePlayersSync().stream().map(OfflinePlayer::getName).toList());
                break;
            }
            case "untrust": {
                Region region;
                if (args.length != 2 || (region = TargetRegionSession.getRegion((OfflinePlayer)player)) == null) break;
                for (SerializableMember member : region.getMembers()) {
                    OfflinePlayer bukkitMember = member.getBukkitOfflinePlayer();
                    if (bukkitMember == null) continue;
                    suggestions.add(bukkitMember.getName());
                }
                suggestions.addAll(region.getInvitedPlayers().stream().map(OfflinePlayer::getName).toList());
                break;
            }
            case "flags": {
                if (args.length == 2) {
                    suggestions.addAll(List.of("member", "global", "world"));
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("member")) {
                    Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                    if (region == null) break;
                    for (SerializableMember member : region.getMembers()) {
                        OfflinePlayer bukkitMember = member.getBukkitOfflinePlayer();
                        if (bukkitMember == null) continue;
                        suggestions.add(bukkitMember.getName());
                    }
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("global")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("world")) {
                    suggestions.addAll(WorldFlags.getFlags());
                    break;
                }
                if (args.length == 4 && args[1].equalsIgnoreCase("member")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (!(args.length == 4 && args[1].equalsIgnoreCase("global") || args.length == 4 && args[1].equalsIgnoreCase("world")) && (args.length != 5 || !args[1].equalsIgnoreCase("member"))) break;
                suggestions.addAll(List.of("allow", "deny"));
                break;
            }
            case "accept": 
            case "deny": {
                if (args.length != 2) break;
                suggestions.addAll(RegionsManager.getRegionsInvitedPlayer((OfflinePlayer)player).stream().map(Region::getName).toList());
                break;
            }
            case "visit": {
                if (args.length == 2) {
                    if (Homestead.config.isWelcomeSignEnabled()) {
                        suggestions.addAll(RegionsManager.getPlayersWithRegionsHasWelcomeSigns().stream().map(OfflinePlayer::getName).toList());
                    } else if (PlayerUtils.isOperator(player)) {
                        suggestions.addAll(RegionsManager.getAll().stream().map(Region::getName).toList());
                    } else {
                        suggestions.addAll(RegionsManager.getPublicRegions().stream().map(Region::getName).toList());
                    }
                }
                if (args.length != 3 || !Homestead.config.isWelcomeSignEnabled()) break;
                for (int i = 0; i < RegionsManager.getPlayersWithRegionsHasWelcomeSigns().size(); ++i) {
                    suggestions.add(String.valueOf(i));
                }
                break;
            }
            case "subareas": {
                if (args.length == 2) {
                    suggestions.addAll(List.of("create", "delete", "rename", "flags"));
                    break;
                }
                if (args.length == 3 && !args[1].equalsIgnoreCase("create")) {
                    Region region = TargetRegionSession.getRegion((OfflinePlayer)player);
                    if (region == null) break;
                    suggestions.addAll(region.getSubAreas().stream().map(SerializableSubArea::getName).collect(Collectors.toList()));
                    break;
                }
                if (args.length == 4 && args[1].equals("flags")) {
                    suggestions.addAll(PlayerFlags.getFlags());
                    break;
                }
                if (args.length != 5) break;
                suggestions.addAll(List.of("allow", "deny"));
                break;
            }
            case "deposit": 
            case "withdraw": {
                if (args.length != 2) break;
                suggestions.add("all");
                break;
            }
            case "balance": 
            case "mail": 
            case "info": 
            case "rate": {
                if (args.length != 2) break;
                suggestions.addAll(RegionsManager.getAll().stream().map(Region::getName).collect(Collectors.toList()));
                break;
            }
            case "war": {
                if (args.length != 3 || !args[1].equalsIgnoreCase("declare")) break;
                suggestions.addAll(RegionsManager.getAll().stream().map(Region::getName).collect(Collectors.toList()));
            }
        }
        return AutoCompleteFilter.filter(suggestions, args);
    }

    public List<String> getSubcommands() {
        return Lists.newArrayList((Object[])new String[]{"create", "delete", "set", "rename", "borders", "ban", "unban", "trust", "untrust", "flags", "accept", "deny", "visit", "subareas", "deposit", "withdraw", "menu", "player", "home", "info", "banlist", "members", "claimlist", "help", "logs", "rate", "top", "auto", "kick", "war", "chat", "mail", "balance", "rewards"});
    }
}

