/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.players;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.flags.PlayerFlags;
import tfagaming.projects.minecraft.homestead.flags.RegionControlFlags;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.managers.WarsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.War;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRent;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerLimits;

public class PlayerUtils {
    private static HashSet<UUID> cooldown = new HashSet();

    public static boolean hasAvailableSlot(Player player) {
        return player.getInventory().firstEmpty() != -1;
    }

    public static double getBalance(OfflinePlayer player) {
        if (!Homestead.vault.isEconomyReady()) {
            return 0.0;
        }
        return Homestead.vault.getEconomy().getBalance(player);
    }

    public static void addBalance(OfflinePlayer player, double amount) {
        if (!Homestead.vault.isEconomyReady()) {
            return;
        }
        Homestead.vault.getEconomy().depositPlayer(player, amount);
    }

    public static void removeBalance(OfflinePlayer player, double amount) {
        if (!Homestead.vault.isEconomyReady()) {
            return;
        }
        Homestead.vault.getEconomy().withdrawPlayer(player, amount);
    }

    public static void sendMessage(Player player, String ... messages) {
        player.sendMessage(ChatColorTranslator.translate(String.join((CharSequence)"", messages)));
    }

    public static void sendMessage(CommandSender sender, String path, Map<String, String> replacements) {
        String message = (String)Homestead.language.get(path);
        if (message == null) {
            sender.sendMessage("String not found from the language file: " + path);
            return;
        }
        message = Formatters.replace(message, replacements);
        sender.sendMessage(ChatColorTranslator.translate(Homestead.config.getPrefix() + message));
    }

    public static void sendMessage(CommandSender sender, String path) {
        String message = (String)Homestead.language.get(path);
        if (message == null) {
            sender.sendMessage("String not found from the language file: " + path);
            return;
        }
        sender.sendMessage(ChatColorTranslator.translate(Homestead.config.getPrefix() + message));
    }

    public static void sendMessage(Player player, int path, Map<String, String> replacements) {
        PlayerUtils.sendMessage((CommandSender)player, String.valueOf(path), replacements);
    }

    public static void sendMessage(CommandSender sender, int path, Map<String, String> replacements) {
        PlayerUtils.sendMessage(sender, String.valueOf(path), replacements);
    }

    public static void sendMessage(CommandSender sender, int path) {
        PlayerUtils.sendMessage(sender, String.valueOf(path));
    }

    public static void sendMessage(Player player, int path) {
        PlayerUtils.sendMessage((CommandSender)player, String.valueOf(path));
    }

    public static void sendMessageRegionEnter(Player player, Map<String, String> replacements) {
        switch (((String)Homestead.config.get("enter-exit-region-message.type")).toLowerCase()) {
            case "title": {
                List titleData = (List)Homestead.config.get("enter-exit-region-message.messages.enter.title");
                player.sendTitle(ChatColorTranslator.translate(Formatters.replace((String)titleData.get(0), replacements)), ChatColorTranslator.translate(Formatters.replace((String)titleData.get(1), replacements)), 10, 70, 20);
                break;
            }
            case "actionbar": {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.enter.actionbar"), replacements))));
                break;
            }
            default: {
                player.sendMessage(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.enter.chat"), replacements)));
            }
        }
    }

    public static void sendMessageRegionExit(Player player, Map<String, String> replacements) {
        switch (((String)Homestead.config.get("enter-exit-region-message.type")).toLowerCase()) {
            case "title": {
                List titleData = (List)Homestead.config.get("enter-exit-region-message.messages.exit.title");
                player.sendTitle(ChatColorTranslator.translate(Formatters.replace((String)titleData.get(0), replacements)), ChatColorTranslator.translate(Formatters.replace((String)titleData.get(1), replacements)), 10, 70, 20);
                break;
            }
            case "actionbar": {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.exit.actionbar"), replacements))));
                break;
            }
            default: {
                player.sendMessage(ChatColorTranslator.translate(Formatters.replace((String)Homestead.config.get("enter-exit-region-message.messages.exit.chat"), replacements)));
            }
        }
    }

    public static void teleportPlayerToChunk(Player player, Chunk chunk) {
        Location location = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 8), 64.0, (double)(chunk.getZ() * 16 + 8));
        location.setY((double)(location.getWorld().getHighestBlockYAt(location) + 2));
        location.setPitch(player.getLocation().getPitch());
        location.setYaw(player.getLocation().getYaw());
        player.teleport(location);
    }

    public static boolean isOperator(Player player) {
        if (player.isOp()) {
            return true;
        }
        return player.hasPermission("homestead.operator");
    }

    public static boolean isOperator(OfflinePlayer player) {
        return player.isOp();
    }

    public static boolean hasPermissionFlag(UUID regionId, Player player, long flag) {
        boolean response;
        Region region = RegionsManager.findRegion(regionId);
        if (region == null) {
            return true;
        }
        SerializableRent rent = region.getRent();
        War war = WarsManager.findWarByRegionId(regionId);
        if (rent != null && rent.getPlayerId() != null && rent.getPlayerId().equals(player.getUniqueId()) && flag != 0x8000000L) {
            response = true;
        } else if (war != null && WarsManager.getMembersOfWar(war.getUniqueId()).stream().map(OfflinePlayer::getUniqueId).toList().contains(player.getUniqueId()) && List.of(Long.valueOf(0x8000000L), Long.valueOf(8L), Long.valueOf(16L), Long.valueOf(0x4000000L), Long.valueOf(32L), Long.valueOf(0x400000000L)).contains(flag)) {
            response = true;
        } else if (region.isPlayerMember((OfflinePlayer)player)) {
            SerializableMember member = region.getMember((OfflinePlayer)player);
            response = FlagsCalculator.isFlagSet(member.getFlags(), flag);
        } else {
            response = FlagsCalculator.isFlagSet(region.getPlayerFlags(), flag);
        }
        if (!response && flag != 0x10000000L && !cooldown.contains(player.getUniqueId())) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{flag}", PlayerFlags.from(flag));
            replacements.put("{region}", region.getName());
            PlayerUtils.sendMessage(player, 50, replacements);
            cooldown.add(player.getUniqueId());
            Homestead.getInstance().runAsyncTaskLater(() -> cooldown.remove(player.getUniqueId()), 3);
        }
        return response;
    }

    public static boolean hasPermissionFlag(UUID regionId, UUID subAreaId, Player player, long flag) {
        Region region = RegionsManager.findRegion(regionId);
        if (region != null) {
            SerializableSubArea subArea = region.getSubArea(subAreaId);
            boolean response = true;
            SerializableRent rent = region.getRent();
            if (rent != null && rent.getPlayerId() != null && rent.getPlayerId().equals(player.getUniqueId()) && flag != 0x8000000L) {
                response = true;
            } else if (region.isPlayerMember((OfflinePlayer)player)) {
                SerializableMember member = region.getMember((OfflinePlayer)player);
                response = FlagsCalculator.isFlagSet(member.getFlags(), flag);
            } else {
                response = FlagsCalculator.isFlagSet(subArea.getFlags(), flag);
            }
            if (!response && !cooldown.contains(player.getUniqueId())) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", PlayerFlags.from(flag));
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 50, replacements);
                cooldown.add(player.getUniqueId());
                Homestead.getInstance().runAsyncTaskLater(() -> cooldown.remove(player.getUniqueId()), 3);
            }
            return response;
        }
        return true;
    }

    public static boolean hasControlRegionPermissionFlag(UUID regionId, Player player, long flag) {
        Region region = RegionsManager.findRegion(regionId);
        if (region != null) {
            if (PlayerUtils.isOperator(player) || player.getUniqueId().equals(region.getOwnerId())) {
                return true;
            }
            boolean response = true;
            if (region.isPlayerMember((OfflinePlayer)player)) {
                SerializableMember member = region.getMember((OfflinePlayer)player);
                response = FlagsCalculator.isFlagSet(member.getRegionControlFlags(), flag);
            }
            if (!response && !cooldown.contains(player.getUniqueId())) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{flag}", RegionControlFlags.from(flag));
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 70, replacements);
                cooldown.add(player.getUniqueId());
                Homestead.getInstance().runAsyncTaskLater(() -> cooldown.remove(player.getUniqueId()), 3);
            }
            return response;
        }
        return true;
    }

    public static String getPlayerGroup(OfflinePlayer player) {
        if (PlayerLimits.getLimitsMethod() != PlayerLimits.LimitMethod.GROUPS) {
            return null;
        }
        try {
            if (player.isOnline()) {
                return Homestead.vault.getPermissions().getPrimaryGroup((Player)player);
            }
            return Homestead.vault.getPermissions().getPrimaryGroup(player.getLocation().getWorld().getName(), player);
        }
        catch (UnsupportedOperationException e) {
            Logger.error("Unable to find a service provider for permissions and groups, using the default group \"default\".");
            Logger.error("Please install a plugin that supports permissions and groups. We recommend installing the LuckPerms plugin.");
            Logger.error("To ignore this warning, change the limits method to \"static\" in this setting: limits.method");
            return null;
        }
    }
}

