/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.api.events.RegionCreateEvent;
import tfagaming.projects.minecraft.homestead.api.events.RegionDeleteEvent;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;
import tfagaming.projects.minecraft.homestead.integrations.WorldEditAPI;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLog;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableMember;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableRate;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;
import tfagaming.projects.minecraft.homestead.tools.other.UpkeepUtils;

public class RegionsManager {
    public static Region createRegion(String name, OfflinePlayer player) {
        Region region = new Region(name, player);
        boolean isEnabled = (Boolean)Homestead.config.get("upkeep.enabled");
        int delay = (Integer)Homestead.config.get("upkeep.start-upkeep");
        if (isEnabled) {
            region.setUpkeepAt(UpkeepUtils.getNewUpkeepAt() + (long)(delay != 0 ? delay * 1000 : 0));
        }
        Homestead.regionsCache.putOrUpdate(region);
        RegionCreateEvent event = new RegionCreateEvent(region, player);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
        return region;
    }

    public static Region createRegion(String name, OfflinePlayer player, boolean verifyName) {
        if (verifyName) {
            Object newname = name;
            int counter = 1;
            if (verifyName) {
                while (RegionsManager.isNameUsed((String)newname)) {
                    newname = name + counter;
                    ++counter;
                }
            }
            Region region = new Region((String)newname, player);
            boolean isEnabled = (Boolean)Homestead.config.get("upkeep.enabled");
            int delay = (Integer)Homestead.config.get("upkeep.start-upkeep");
            if (isEnabled) {
                region.setUpkeepAt(UpkeepUtils.getNewUpkeepAt() + (long)(delay != 0 ? delay * 1000 : 0));
            }
            Homestead.regionsCache.putOrUpdate(region);
            return region;
        }
        return RegionsManager.createRegion(name, player);
    }

    public static List<Region> getAll() {
        return Homestead.regionsCache.getAll();
    }

    public static Region findRegion(UUID id) {
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.getUniqueId().equals(id)) continue;
            return region;
        }
        return null;
    }

    public static Region findRegion(String name) {
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.getName().equals(name)) continue;
            return region;
        }
        return null;
    }

    public static void deleteRegion(UUID id, OfflinePlayer ... player) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        boolean isRegeneratingChunksEnabled = (Boolean)Homestead.config.get("worldedit.regenerate-chunks");
        if (isRegeneratingChunksEnabled) {
            for (SerializableChunk chunk : region.getChunks()) {
                Homestead.getInstance().runAsyncTask(() -> WorldEditAPI.regenerateChunk(chunk.getWorld(), chunk.getX(), chunk.getZ()));
            }
        }
        Homestead.regionsCache.remove(id);
        RegionDeleteEvent event = new RegionDeleteEvent(region, player.length > 0 ? player[0] : null);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
    }

    public static void addNewLog(UUID id, int messagePath) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        String message = (String)Homestead.language.get("logs." + messagePath);
        region.addLog(new SerializableLog((String)Homestead.language.get("default.author"), message));
    }

    public static void addNewLog(UUID id, int messagePath, Map<String, String> replacements) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        String message = (String)Homestead.language.get("logs." + messagePath);
        region.addLog(new SerializableLog((String)Homestead.language.get("default.author"), Formatters.replace(message, replacements)));
    }

    public static List<OfflinePlayer> getAllOwners() {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        for (Region region : Homestead.regionsCache.getAll()) {
            players.add(region.getOwner());
        }
        return ListUtils.removeDuplications(players);
    }

    public static List<Region> sortRegionsAlpha() {
        List<Region> regions = Homestead.regionsCache.getAll();
        Collections.sort(regions, new Comparator<Region>(){

            @Override
            public int compare(Region r1, Region r2) {
                return r1.getName().compareToIgnoreCase(r2.getName());
            }
        });
        return regions;
    }

    public static List<Region> getRegionsWithWelcomeSigns() {
        ArrayList<Region> filtered = new ArrayList<Region>();
        for (Region region : RegionsManager.getAll()) {
            if (region.getWelcomeSign() == null) continue;
            filtered.add(region);
        }
        return filtered;
    }

    public static List<OfflinePlayer> getPlayersWithRegionsHasWelcomeSigns() {
        ArrayList<OfflinePlayer> filtered = new ArrayList<OfflinePlayer>();
        for (Region region : RegionsManager.getAll()) {
            if (region.getWelcomeSign() == null) continue;
            filtered.add(region.getOwner());
        }
        return filtered;
    }

    public static List<Region> getRegionsOwnedByPlayer(OfflinePlayer player) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.getOwner().getUniqueId().equals(player.getUniqueId())) continue;
            regions.add(region);
        }
        return regions;
    }

    public static List<Region> getRegionsHasPlayerAsMember(OfflinePlayer player) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.isPlayerMember(player)) continue;
            regions.add(region);
        }
        return regions;
    }

    public static List<Region> getPublicRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : Homestead.regionsCache.getAll()) {
            long flags = region.getPlayerFlags();
            if (!FlagsCalculator.isFlagSet(flags, 0x4000000L) || !FlagsCalculator.isFlagSet(flags, 0x2000000L)) continue;
            regions.add(region);
        }
        return regions;
    }

    public static List<Region> getRegionsInvitedPlayer(OfflinePlayer player) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.isPlayerInvited(player)) continue;
            regions.add(region);
        }
        return regions;
    }

    public static List<Region> sortRegions(RegionSorting type) {
        switch (type.ordinal()) {
            case 0: {
                return Homestead.regionsCache.getAll().stream().sorted(Comparator.comparingDouble(Region::getBank).reversed()).collect(Collectors.toList());
            }
            case 1: {
                return Homestead.regionsCache.getAll().stream().sorted(Comparator.comparingInt(region -> ((Region)region).getChunks().size()).reversed()).collect(Collectors.toList());
            }
            case 2: {
                return Homestead.regionsCache.getAll().stream().sorted(Comparator.comparingInt(region -> ((Region)region).getMembers().size()).reversed()).collect(Collectors.toList());
            }
            case 3: {
                return Homestead.regionsCache.getAll().stream().sorted(Comparator.comparingDouble(region -> RegionsManager.getAverageRating((Region)region)).reversed()).collect(Collectors.toList());
            }
            case 4: {
                return Homestead.regionsCache.getAll().stream().sorted(Comparator.comparingLong(region -> region.getCreatedAt())).collect(Collectors.toList());
            }
        }
        return new ArrayList<Region>();
    }

    public static int getRank(RegionSorting type, UUID id) {
        List<Region> regions = RegionsManager.sortRegions(type);
        for (int i = 0; i < regions.size(); ++i) {
            Region region = regions.get(i);
            if (!region.getUniqueId().equals(id)) continue;
            return i + 1;
        }
        return 0;
    }

    public static int getGlobalRank(UUID id) {
        return (RegionsManager.getRank(RegionSorting.BANK, id) + RegionsManager.getRank(RegionSorting.CHUNKS_COUNT, id) + RegionsManager.getRank(RegionSorting.MEMBERS_COUNT, id) + RegionsManager.getRank(RegionSorting.RATING, id)) / 4;
    }

    public static boolean isNameUsed(String name) {
        for (Region region : Homestead.regionsCache.getAll()) {
            if (!region.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerInsideRegion(Player player, Region region) {
        Chunk location = player.getLocation().getChunk();
        for (SerializableChunk chunk : region.getChunks()) {
            if (chunk.getX() != location.getX() || chunk.getZ() != location.getZ()) continue;
            return true;
        }
        return false;
    }

    public static double getAverageRating(Region region) {
        List<SerializableRate> rates = region.getRates();
        if (rates == null || rates.isEmpty()) {
            return 0.0;
        }
        int totalRate = 0;
        for (SerializableRate rate : rates) {
            totalRate += rate.getRate();
        }
        return (double)totalRate / (double)rates.size();
    }

    public static int deleteRegionsWithInvalidPlayerIds() {
        int count = 0;
        for (Region region : Homestead.regionsCache.getAll()) {
            OfflinePlayer regionOwner = region.getOwner();
            if (regionOwner.getName() == null) {
                RegionsManager.deleteRegion(region.getUniqueId(), new OfflinePlayer[0]);
                ++count;
                continue;
            }
            for (SerializableMember serializableMember : region.getMembers()) {
                OfflinePlayer member = serializableMember.getBukkitOfflinePlayer();
                if (member.getName() != null) continue;
                region.removeMember(serializableMember);
                ++count;
            }
        }
        return count;
    }

    public static void setPlayerFlagForAllRegions(long flag, boolean state) {
        for (Region region : RegionsManager.getAll()) {
            long flags = region.getPlayerFlags();
            long newFlags = state ? FlagsCalculator.addFlag(flags, flag) : FlagsCalculator.removeFlag(flags, flag);
            region.setPlayerFlags(newFlags);
        }
    }

    public static void setWorldFlagForAllRegions(long flag, boolean state) {
        for (Region region : RegionsManager.getAll()) {
            long flags = region.getWorldFlags();
            long newFlags = state ? FlagsCalculator.addFlag(flags, flag) : FlagsCalculator.removeFlag(flags, flag);
            region.setWorldFlags(newFlags);
        }
    }

    public static int cleanStartup() {
        int updated = 0;
        for (Region region : Homestead.regionsCache.getAll()) {
            SerializableLocation welcomeSignLoc;
            World world;
            for (SerializableMember member : region.getMembers()) {
                if (member.getBukkitOfflinePlayer() != null) continue;
                region.removeMember(member);
                ++updated;
            }
            for (SerializableBannedPlayer bannedPlayer : region.getBannedPlayers()) {
                if (bannedPlayer.getBukkitOfflinePlayer() != null) continue;
                region.unbanPlayer(bannedPlayer.getPlayerId());
                ++updated;
            }
            for (SerializableRate rate : region.getRates()) {
                OfflinePlayer rater = rate.getBukkitOfflinePlayer();
                if (rater != null) continue;
                region.removePlayerRate(rate.getPlayerId());
                ++updated;
            }
            for (SerializableChunk chunk : region.getChunks()) {
                world = chunk.getWorld();
                if (world != null) continue;
                region.removeChunk(chunk);
                ++updated;
            }
            for (SerializableSubArea area : region.getSubAreas()) {
                world = area.getWorld();
                if (world != null) continue;
                region.removeSubArea(area.getId());
                ++updated;
            }
            SerializableLocation spawnLoc = region.getLocation();
            if (spawnLoc != null && spawnLoc.getWorld() == null) {
                region.setLocation(null);
                ++updated;
            }
            if ((welcomeSignLoc = region.getWelcomeSign()) != null && welcomeSignLoc.getWorld() == null) {
                region.setWelcomeSign(null);
                ++updated;
            }
            if (region.getOwner() != null) continue;
            RegionsManager.deleteRegion(region.getUniqueId(), new OfflinePlayer[0]);
            ++updated;
        }
        return updated;
    }

    public static enum RegionSorting {
        BANK,
        CHUNKS_COUNT,
        MEMBERS_COUNT,
        RATING,
        CREATION_DATE;

    }
}

