/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class MenusConfigLoader {
    private File configFile;
    private FileConfiguration config;

    public MenusConfigLoader(Homestead plugin) {
        this.configFile = new File(plugin.getDataFolder(), "menus.yml");
        if (!this.configFile.exists()) {
            try {
                InputStream stream = plugin.getResource("menus.yml");
                FileUtils.copyInputStreamToFile(stream, this.configFile);
            }
            catch (IOException e) {
                Logger.error("Unable to copy the default menus configuration file (menus.yml), closing plugin's instance...");
                plugin.endInstance();
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        Logger.info("The menus configuration file is ready.");
    }

    public <T> T get(String path) {
        return (T)this.config.get(path);
    }

    public List<String> getKeysUnderPath(String path) {
        if (this.config.isConfigurationSection(path)) {
            Set keys = this.config.getConfigurationSection(path).getKeys(false);
            return new ArrayList<String>(keys);
        }
        return new ArrayList<String>();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

