/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.CommodoreProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.commands.MojangBrigadier;
import tfagaming.projects.minecraft.homestead.commands.commands.ClaimCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.ForceUnclaimCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.HomesteadAdminCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.RegionCommand;
import tfagaming.projects.minecraft.homestead.commands.commands.UnclaimCommand;
import tfagaming.projects.minecraft.homestead.config.ConfigLoader;
import tfagaming.projects.minecraft.homestead.config.LanguageLoader;
import tfagaming.projects.minecraft.homestead.config.MenusConfigLoader;
import tfagaming.projects.minecraft.homestead.database.Database;
import tfagaming.projects.minecraft.homestead.database.OldDataLoader;
import tfagaming.projects.minecraft.homestead.database.RegionsCache;
import tfagaming.projects.minecraft.homestead.database.WarsCache;
import tfagaming.projects.minecraft.homestead.events.MemberTaxes;
import tfagaming.projects.minecraft.homestead.events.RegionRent;
import tfagaming.projects.minecraft.homestead.events.RegionUpkeep;
import tfagaming.projects.minecraft.homestead.integrations.DynamicMaps;
import tfagaming.projects.minecraft.homestead.integrations.PlaceholderAPI;
import tfagaming.projects.minecraft.homestead.integrations.Vault;
import tfagaming.projects.minecraft.homestead.integrations.bStats;
import tfagaming.projects.minecraft.homestead.integrations.maps.RegionIconTools;
import tfagaming.projects.minecraft.homestead.listeners.CommandsCooldownListener;
import tfagaming.projects.minecraft.homestead.listeners.CustomSignsLisntener;
import tfagaming.projects.minecraft.homestead.listeners.PlayerAutoClaimListener;
import tfagaming.projects.minecraft.homestead.listeners.PlayerRegionEnterAndExitListener;
import tfagaming.projects.minecraft.homestead.listeners.RegionProtectionListener;
import tfagaming.projects.minecraft.homestead.listeners.SelectionToolListener;
import tfagaming.projects.minecraft.homestead.logs.Logger;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.tools.https.UpdateChecker;
import tfagaming.projects.minecraft.homestead.tools.minecraft.plugins.IntegrationsUtils;
import tfagaming.projects.minecraft.homestead.tools.validator.YAMLValidator;

public class Homestead
extends JavaPlugin {
    private static final String version = "4.1.3";
    private static Homestead instance;
    private static long startedAt;
    public static Database database;
    public static RegionsCache regionsCache;
    public static WarsCache warsCache;
    public static ConfigLoader config;
    public static LanguageLoader language;
    public static MenusConfigLoader menusConfig;
    public static Vault vault;

    public void onEnable() {
        YAMLValidator menusConfigValidator;
        YAMLValidator languageValidator;
        File warsFolder;
        File regionsFolder;
        instance = this;
        startedAt = System.currentTimeMillis();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(regionsFolder = new File(this.getDataFolder(), "regions")).exists()) {
            regionsFolder.mkdir();
        }
        if (!(warsFolder = new File(this.getDataFolder(), "wars")).exists()) {
            warsFolder.mkdir();
        }
        new Logger();
        this.saveDefaultConfig();
        config = new ConfigLoader(this);
        language = new LanguageLoader(this, (String)config.get("language"));
        menusConfig = new MenusConfigLoader(this);
        HashSet<String> skipKeys = new HashSet<String>();
        YAMLValidator configValidator = new YAMLValidator("config.yml", new File(this.getDataFolder(), "config.yml"), skipKeys);
        if (!configValidator.validate()) {
            boolean fixed = configValidator.fix();
            if (fixed) {
                config = new ConfigLoader(this);
            } else {
                this.endInstance();
                return;
            }
        }
        if (!(languageValidator = new YAMLValidator("en-US.yml", language.getLanguageFile((String)config.get("language")))).validate()) {
            boolean fixed = languageValidator.fix();
            if (fixed) {
                language = new LanguageLoader(this, (String)config.get("language"));
            } else {
                this.endInstance();
                return;
            }
        }
        if (!(menusConfigValidator = new YAMLValidator("menus.yml", new File(this.getDataFolder(), "menus.yml"), skipKeys)).validate()) {
            boolean fixed = menusConfigValidator.fix();
            if (fixed) {
                menusConfig = new MenusConfigLoader(this);
            } else {
                this.endInstance();
                return;
            }
        }
        regionsCache = new RegionsCache((Integer)config.get("cache-interval"));
        warsCache = new WarsCache((Integer)config.get("cache-interval"));
        Database.Provider provider = Database.parseProviderFromString((String)config.get("database.provider"));
        if (provider == null) {
            Logger.error("Invalid database provider, please use: PostgreSQL, MySQL, SQLite, YAML");
            this.endInstance();
        }
        database = new Database(provider);
        File claimsFolder = new File(this.getDataFolder(), "claims");
        if (claimsFolder.exists() && claimsFolder.isDirectory()) {
            Logger.warning("Detected \"claims\" folder, importing old regions data...");
            int __a = OldDataLoader.loadRegions();
            Logger.warning("Imported " + __a + " regions, deleting the \"claims\" folder...");
            if (!OldDataLoader.deleteDirectory(claimsFolder)) {
                for (int i = 0; i < 100; ++i) {
                    Logger.error("Unable to delete the \"claims\" folder, please delete it manually.");
                }
                this.endInstance();
                return;
            }
            Logger.warning("The migration was successfully done, welcome to version " + Homestead.getVersion() + "!");
            database.exportRegions();
        } else {
            database.importRegions();
            database.importWars();
        }
        if (!IntegrationsUtils.isVaultInstalled()) {
            Logger.error("Unable to start the plugin; \"Vault\" is required. Shutting down plugin instance...");
            this.endInstance();
            return;
        }
        Logger.warning("Loading service providers with Vault...");
        vault = new Vault(this);
        if (!vault.setupEconomy()) {
            Logger.warning("No Economy service provider found.");
            Logger.warning("Any feature requiring an Economy service will be skipped.");
        } else {
            Logger.info("Loaded service provider: Economy [" + vault.getEconomy().getName() + "]");
        }
        if (!vault.setupPermissions()) {
            Logger.error("No Permissions service provider found.");
            Logger.error("Permissions are required for Homestead to run. Shutting down plugin instance...");
            this.endInstance();
            return;
        }
        Logger.info("Loaded service provider: Permissions [" + vault.getPermissions().getName() + "]");
        this.registerCommands();
        this.registerEvents();
        this.registerBrigadier();
        new bStats(this);
        if (config.isDebugEnabled()) {
            Logger.warning("Debug mode is enabled in config.yml; logs.txt may be flooded with warnings.");
        }
        if (((Boolean)config.get("clean-startup")).booleanValue()) {
            Logger.warning("Cleaning up regions data...");
            int updated = RegionsManager.cleanStartup();
            if (updated > 0) {
                Logger.info("Successfully updated " + updated + " rows of regions data.");
            } else {
                Logger.info("No data corruption was found!");
            }
        }
        Logger.info("Ready, took " + String.valueOf(System.currentTimeMillis() - startedAt) + " ms to load.");
        this.runAsyncTask(() -> {
            Logger.warning("Downloading required web map render icons... This may take a while!");
            RegionIconTools.downloadAllIcons();
            Logger.info("Successfully downloaded all icons.");
        });
        this.runAsyncTimerTask(() -> this.runAsyncTask(() -> new DynamicMaps(this)), (Integer)config.get("dynamic-maps.update-interval"));
        if (vault.isEconomyReady() && ((Boolean)config.get("taxes.enabled")).booleanValue()) {
            this.runAsyncTimerTask(() -> new MemberTaxes(this), 10);
        }
        if (vault.isEconomyReady() && ((Boolean)config.get("upkeep.enabled")).booleanValue()) {
            this.runAsyncTimerTask(() -> new RegionUpkeep(this), 10);
        }
        if (vault.isEconomyReady() && ((Boolean)config.get("renting.enabled")).booleanValue()) {
            this.runAsyncTimerTask(() -> new RegionRent(this), 10);
        }
        this.runAsyncTimerTask(() -> this.runAsyncTask(() -> new UpdateChecker(this)), 86400);
        this.registerExternalPlugins();
        this.runAsyncTaskLater(() -> this.runSyncTimerTask(() -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    RegionProtectionListener.onEntityMove(entity);
                }
            }
        }, 5L), 10);
    }

    private void registerCommands() {
        CommandBuilder.register(new RegionCommand());
        CommandBuilder.register(new ClaimCommand());
        CommandBuilder.register(new UnclaimCommand());
        CommandBuilder.register(new HomesteadAdminCommand());
        CommandBuilder.register(new ForceUnclaimCommand());
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerRegionEnterAndExitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RegionProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SelectionToolListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CommandsCooldownListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CustomSignsLisntener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerAutoClaimListener(), (Plugin)this);
    }

    private void registerBrigadier() {
        try {
            if (CommodoreProvider.isSupported()) {
                Commodore commodore = CommodoreProvider.getCommodore((Plugin)this);
                new MojangBrigadier(this, commodore);
            } else {
                Logger.warning("Mojang Brigadier is not supported on this server software.");
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.warning("Commodore/Brigadier classes not present. Skipping Brigadier command registration.");
        }
    }

    public BukkitTask runAsyncTimerTask(Runnable callable, int interval) {
        long intervalTicks = (long)interval * 20L;
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, callable, 0L, intervalTicks);
    }

    public void runSyncTimerTask(Runnable callable, long ticks) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, callable, 0L, ticks);
    }

    public void runAsyncTimerTask(Runnable callable, int delay, int interval) {
        long delayTicks = (long)delay * 20L;
        long intervalTicks = (long)interval * 20L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, callable, delayTicks, intervalTicks);
    }

    public void runAsyncTaskLater(Runnable callable, int delay) {
        long delayTicks = (long)delay * 20L;
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, callable, delayTicks);
    }

    public void runAsyncTask(Runnable callable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, callable);
    }

    public void runSyncTask(Runnable callable) {
        Bukkit.getScheduler().runTask((Plugin)this, callable);
    }

    public List<OfflinePlayer> getOfflinePlayersSync() {
        OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
        return Arrays.asList(offlinePlayers);
    }

    public OfflinePlayer getOfflinePlayerSync(UUID playerId) {
        OfflinePlayer[] offlinePlayers;
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        for (OfflinePlayer player : offlinePlayers = Bukkit.getOfflinePlayers()) {
            if (player.getName() == null || !player.hasPlayedBefore() || !player.getUniqueId().equals(playerId)) continue;
            return player;
        }
        return null;
    }

    public OfflinePlayer getOfflinePlayerSync(String playerName) {
        OfflinePlayer[] offlinePlayers;
        Player onlinePlayer = Bukkit.getPlayer((String)playerName);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        for (OfflinePlayer player : offlinePlayers = Bukkit.getOfflinePlayers()) {
            if (player.getName() == null || !player.hasPlayedBefore() || !player.getName().equals(playerName)) continue;
            return player;
        }
        return null;
    }

    public void onDisable() {
        if (database != null) {
            Logger.info("Closing database connection...");
            database.closeConnection();
        }
    }

    public static String getVersion() {
        return version;
    }

    public static Homestead getInstance() {
        return instance;
    }

    public void registerExternalPlugins() {
        boolean placeholderRegistered;
        if (this.isPlaceholderAPIInstalled() && !(placeholderRegistered = new PlaceholderAPI(this).register())) {
            Logger.error("Failed to register hooks.");
        }
    }

    public boolean isPlaceholderAPIInstalled() {
        return Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null && Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI").isEnabled();
    }

    public void endInstance() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }
}

