/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tfagaming.projects.minecraft.homestead.commands.CommandBuilder;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.particles.ChunkParticlesSpawner;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class ForceUnclaimCommand
extends CommandBuilder {
    public ForceUnclaimCommand() {
        super("forceunclaim");
    }

    @Override
    public boolean onExecution(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            PlayerUtils.sendMessage(sender, 8);
            return false;
        }
        Player player = (Player)sender;
        if (!player.isOp()) {
            PlayerUtils.sendMessage(sender, 8);
            return true;
        }
        Chunk chunk = player.getLocation().getChunk();
        if (ChunksManager.isChunkInDisabledWorld(chunk)) {
            PlayerUtils.sendMessage(player, 20);
            return true;
        }
        Region owningRegion = ChunksManager.getRegionOwnsTheChunk(chunk);
        if (owningRegion == null) {
            PlayerUtils.sendMessage(player, 25);
            return true;
        }
        ChunksManager.forceUnclaimChunk(owningRegion.getUniqueId(), chunk, new OfflinePlayer[]{player});
        if (owningRegion.getLocation() != null && owningRegion.getLocation().getBukkitLocation() != null && owningRegion.getLocation().getBukkitLocation().getChunk().equals((Object)chunk)) {
            owningRegion.setLocation(null);
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", owningRegion.getName());
        PlayerUtils.sendMessage(player, 24, replacements);
        new ChunkParticlesSpawner(player);
        return true;
    }

    @Override
    public List<String> onAutoComplete(CommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

