/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.particles;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;

public class ChunkParticlesSpawner {
    private static final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();
    private final Player player;

    public ChunkParticlesSpawner(Player player) {
        this.player = player;
        if (tasks.containsKey(player.getUniqueId())) {
            BukkitTask taskFromMap = tasks.get(player.getUniqueId());
            ChunkParticlesSpawner.cancelTask(taskFromMap, player);
        }
        this.startRepeatingEffect(15L);
    }

    public void spawnParticles() {
        for (Region region : RegionsManager.getAll()) {
            this.spawnParticlesForRegion(region);
        }
    }

    public void spawnParticlesForRegion(Region region) {
        List<SerializableChunk> chunks = region.getChunks();
        for (SerializableChunk chunk : chunks) {
            World world = this.player.getWorld();
            double yOffset = this.player.getLocation().getY() + 1.0;
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            String chunkWorldName = chunk.getWorldName();
            int minX = chunkX * 16;
            int minZ = chunkZ * 16;
            if (!world.getName().equals(chunkWorldName)) continue;
            Particle.DustOptions dustOptions = (region = RegionsManager.findRegion(region.getUniqueId())).getOwnerId().equals(this.player.getUniqueId()) ? new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 2.0f) : (region.isPlayerMember((OfflinePlayer)this.player) ? new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)0), 2.0f) : new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 2.0f));
            this.checkAndSpawn(world, chunkX, chunkZ - 1, region, minX, minZ, yOffset, dustOptions, Direction.NORTH);
            this.checkAndSpawn(world, chunkX, chunkZ + 1, region, minX, minZ + 16, yOffset, dustOptions, Direction.SOUTH);
            this.checkAndSpawn(world, chunkX - 1, chunkZ, region, minX, minZ, yOffset, dustOptions, Direction.WEST);
            this.checkAndSpawn(world, chunkX + 1, chunkZ, region, minX + 16, minZ, yOffset, dustOptions, Direction.EAST);
        }
    }

    private void checkAndSpawn(World world, int chunkX, int chunkZ, Region region, int minX, int minZ, double yOffset, Particle.DustOptions dustOptions, Direction direction) {
        block5: {
            if (!world.isChunkLoaded(chunkX, chunkZ)) {
                return;
            }
            Chunk neighbor = world.getChunkAt(chunkX, chunkZ);
            Region neighborRegion = ChunksManager.getRegionOwnsTheChunk(neighbor);
            if (neighborRegion != null && neighborRegion.getUniqueId().equals(region.getUniqueId())) break block5;
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                for (int x = minX; x < minX + 16; ++x) {
                    this.player.spawnParticle(Particle.DUST, (double)x, yOffset, (double)minZ, 5, (Object)dustOptions);
                }
            } else {
                for (int z = minZ; z < minZ + 16; ++z) {
                    this.player.spawnParticle(Particle.DUST, (double)minX, yOffset, (double)z, 5, (Object)dustOptions);
                }
            }
        }
    }

    public void startRepeatingEffect(long intervalTicks) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                ChunkParticlesSpawner.this.spawnParticles();
            }
        }.runTaskTimer((Plugin)Homestead.getInstance(), 0L, intervalTicks);
        tasks.put(this.player.getUniqueId(), task);
        Bukkit.getScheduler().runTaskLater((Plugin)Homestead.getInstance(), () -> ChunkParticlesSpawner.cancelTask(task, this.player), 1200L);
    }

    public static void cancelTask(BukkitTask task, Player player) {
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
        }
    }

    public static boolean isTaskRunning(Player player) {
        return tasks.containsKey(player.getUniqueId());
    }

    public static void cancelTask(Player player) {
        BukkitTask task = tasks.get(player.getUniqueId());
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
        }
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

