/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class PlayerRegionEnterAndExitListener
implements Listener {
    private static final Map<UUID, UUID> sessions = new HashMap<UUID, UUID>();

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = player.getLocation().getChunk();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        boolean isFeatureEnabled = (Boolean)Homestead.config.get("enter-exit-region-message.enabled");
        if (ChunksManager.isChunkClaimed(chunk)) {
            Region region = ChunksManager.getRegionOwnsTheChunk(chunk);
            if (sessions.containsKey(player.getUniqueId()) && sessions.get(player.getUniqueId()).equals(region.getUniqueId())) {
                return;
            }
            if (region.isPlayerBanned((OfflinePlayer)player)) {
                Chunk nearbyChunk = ChunksManager.findNearbyUnclaimedChunk(player);
                if (nearbyChunk != null) {
                    PlayerUtils.teleportPlayerToChunk(player, nearbyChunk);
                }
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                replacements.put("{ban-reason}", region.getBannedPlayer((OfflinePlayer)player).getReason());
                PlayerUtils.sendMessage(player, 28, replacements);
                return;
            }
            if (!(PlayerUtils.isOperator(player) || player.getUniqueId().equals(region.getOwnerId()) || PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x4000000L))) {
                Chunk nearbyChunk = ChunksManager.findNearbyUnclaimedChunk(player);
                if (nearbyChunk != null) {
                    PlayerUtils.teleportPlayerToChunk(player, nearbyChunk);
                }
                return;
            }
            if (isFeatureEnabled) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region-displayname}", region.getDisplayName());
                replacements.put("{region-owner}", region.getOwner().getName());
                replacements.put("{region-description}", region.getDescription().replace("%player%", player.getName()));
                PlayerUtils.sendMessageRegionEnter(player, replacements);
            }
            sessions.put(player.getUniqueId(), region.getUniqueId());
            if (region.getWeather() != 0) {
                switch (region.getWeather()) {
                    case 1: {
                        player.setPlayerWeather(WeatherType.CLEAR);
                        break;
                    }
                    case 2: {
                        player.setPlayerWeather(WeatherType.DOWNFALL);
                    }
                }
            }
            if (region.getTime() != 0) {
                player.setPlayerTime((long)region.getTime(), false);
            }
            if (region.isWorldFlagSet(32768L) && !player.hasPotionEffect(PotionEffectType.GLOWING)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1, false, false));
            }
            if (player.isGliding() && this.isWearingElytra(player) && !PlayerUtils.isOperator(player) && !player.getUniqueId().equals(region.getOwnerId()) && !PlayerUtils.hasPermissionFlag(region.getUniqueId(), player, 0x400000000L)) {
                player.setGliding(false);
            }
        } else {
            if (!sessions.containsKey(player.getUniqueId())) {
                return;
            }
            Region region = RegionsManager.findRegion(sessions.get(player.getUniqueId()));
            if (isFeatureEnabled) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                if (region != null) {
                    replacements.put("{region-displayname}", region.getDisplayName());
                    replacements.put("{region-owner}", region.getOwner().getName());
                    replacements.put("{region-description}", region.getDescription());
                }
                PlayerUtils.sendMessageRegionExit(player, replacements);
            }
            sessions.remove(player.getUniqueId());
            if (player.getPlayerWeather() != null) {
                player.resetPlayerWeather();
            }
            if (player.getPlayerTimeOffset() != 0L) {
                player.resetPlayerTime();
            }
            if (player.hasPotionEffect(PotionEffectType.GLOWING)) {
                player.removePotionEffect(PotionEffectType.GLOWING);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (sessions.containsKey(player.getUniqueId())) {
            sessions.remove(player.getUniqueId());
        }
    }

    private boolean isWearingElytra(Player player) {
        return player.getInventory().getChestplate() != null && player.getInventory().getChestplate().getType() == Material.ELYTRA;
    }
}

