/*
 * Decompiled with CFR 0.152.
 */
package com.technicjelle.BMUtils;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.math.Shape;
import org.jetbrains.annotations.NotNull;

public class ShapeExtensions {
    private ShapeExtensions() {
        throw new IllegalStateException("Utility class");
    }

    public static Shape expandShapeRect(@NotNull Shape shape, double amount) {
        int i;
        int size = shape.getPointCount();
        Vector2d[] copies = new Vector2d[size];
        for (i = 0; i < size; ++i) {
            copies[i] = shape.getPoint(i);
        }
        for (i = 0; i < size; ++i) {
            int endIndex = (i + 1) % size;
            Vector2d start = shape.getPoint(i);
            Vector2d end = shape.getPoint(endIndex);
            Vector2d dir = end.sub(start).normalize();
            Vector2d norm = Vector2d.from((double)dir.getY(), (double)(-dir.getX())).mul(amount);
            copies[i] = copies[i].add(norm);
            copies[endIndex] = copies[endIndex].add(norm);
        }
        return new Shape(copies);
    }

    public static Shape shrinkShapeRect(@NotNull Shape shape, double amount) {
        return ShapeExtensions.expandShapeRect(shape, -amount);
    }

    public static Shape expandShapeAccurate(@NotNull Shape shape, double amount) {
        return ShapeExtensions.shrinkShapeAccurate(shape, -amount);
    }

    public static Shape shrinkShapeAccurate(@NotNull Shape shape, double amount) {
        int i;
        int size = shape.getPointCount();
        Vector2d[] copies = new Vector2d[size];
        for (i = 0; i < size; ++i) {
            copies[i] = shape.getPoint(i);
        }
        for (i = 0; i < size; ++i) {
            int prevIndex = Math.floorMod(i - 1, size);
            int nextIndex = Math.floorMod(i + 1, size);
            Vector2d prevStart = shape.getPoint(prevIndex);
            Vector2d current = shape.getPoint(i);
            Vector2d nextEnd = shape.getPoint(nextIndex);
            Vector2d dirFromPrev = current.sub(prevStart).normalize();
            Vector2d normFromPrev = Vector2d.from((double)dirFromPrev.getY(), (double)(-dirFromPrev.getX()));
            Vector2d dirToNext = nextEnd.sub(current).normalize();
            Vector2d normToNext = Vector2d.from((double)dirToNext.getY(), (double)(-dirToNext.getX()));
            Vector2d averageNorm = normFromPrev.add(normToNext).div(2.0).normalize();
            copies[i] = copies[i].add(averageNorm.mul(amount));
        }
        return new Shape(copies);
    }

    public static Shape scaleShapeOrigin(@NotNull Shape shape, double scale) {
        Vector2d[] points = new Vector2d[shape.getPointCount()];
        for (int i = 0; i < shape.getPointCount(); ++i) {
            points[i] = shape.getPoint(i).mul(scale);
        }
        return new Shape(points);
    }

    @NotNull
    public static Shape scaleShapeMiddle(@NotNull Shape shape, double scale) {
        Vector2d middle = shape.getMin().add(shape.getMax()).div(2.0f);
        return ShapeExtensions.scaleShapeAround(shape, scale, middle);
    }

    public static Shape scaleShapeAround(@NotNull Shape shape, double scale, Vector2d origin) {
        Vector2d[] points = new Vector2d[shape.getPointCount()];
        for (int i = 0; i < shape.getPointCount(); ++i) {
            points[i] = origin.add(shape.getPoint(i).sub(origin).mul(scale));
        }
        return new Shape(points);
    }
}

