/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.minecraft.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapColor {
    public static final int RED = 0xFF0000;
    public static final int GREEN = 65280;
    public static final int BLUE = 255;
    public static final int YELLOW = 0xFFFF00;
    public static final int CYAN = 65535;
    public static final int MAGENTA = 0xFF00FF;
    public static final int WHITE = 0xFFFFFF;
    public static final int GRAY = 0x808080;
    public static final int LIGHT_GRAY = 0xC0C0C0;
    public static final int DARK_GRAY = 0x404040;
    public static final int ORANGE = 16753920;
    public static final int PINK = 16761035;
    public static final int PURPLE = 0x800080;
    public static final int BROWN = 0xA52A2A;
    public static final int GOLD = 16766720;
    public static final int SILVER = 0xC0C0C0;
    public static final int NAVY = 128;
    public static final int TEAL = 32896;
    public static final int LIME = 65280;
    public static final int MAROON = 0x800000;
    public static final int OLIVE = 0x808000;
    public static final int CRIMSON = 14423100;
    public static final int CORAL = 16744272;
    public static final int SALMON = 16416882;
    public static final int TURQUOISE = 4251856;
    public static final int VIOLET = 0xEE82EE;
    public static final int INDIGO = 4915330;
    public static final int LAVENDER = 15132410;
    public static final int PLUM = 0xDDA0DD;
    public static final int TAN = 13808780;
    public static final int BEIGE = 16119260;
    public static final int MINT = 0x98FF98;
    public static final int SKY_BLUE = 8900331;
    public static final int SLATE_GRAY = 7372944;
    public static final int DARK_SLATE_GRAY = 0x2F4F4F;
    public static final int CHOCOLATE = 13789470;
    public static final int PERU = 13468991;
    public static final int KHAKI = 15787660;
    public static final int THISTLE = 14204888;
    public static final int NEON_GREEN = 3800852;
    public static final int ELECTRIC_BLUE = 8255999;
    public static final int HOT_PINK = 16738740;
    public static final int BRIGHT_ORANGE = 16753920;
    public static final int NEON_YELLOW = 0xFFFF33;
    public static final int NEON_PURPLE = 10289407;
    public static final int DARK_RED = 0x8B0000;
    public static final int DARK_GREEN = 25600;
    public static final int DARK_BLUE = 139;
    public static final int LIGHT_BLUE = 11393254;
    public static final int LIGHT_GREEN = 0x90EE90;
    public static final int LIGHT_PINK = 16758465;
    public static final int LIGHT_YELLOW = 0xFFFFE0;
    public static final int LIGHT_CYAN = 0xE0FFFF;
    public static final int DEFAULT = 0;
    private static final Map<String, Integer> COLOR_MAP = new HashMap<String, Integer>();
    private static final Map<Integer, String> COLOR_CODE_TO_NAME = new HashMap<Integer, String>();

    static {
        COLOR_MAP.put("RED", 0xFF0000);
        COLOR_MAP.put("GREEN", 65280);
        COLOR_MAP.put("BLUE", 255);
        COLOR_MAP.put("YELLOW", 0xFFFF00);
        COLOR_MAP.put("CYAN", 65535);
        COLOR_MAP.put("MAGENTA", 0xFF00FF);
        COLOR_MAP.put("WHITE", 0xFFFFFF);
        COLOR_MAP.put("GRAY", 0x808080);
        COLOR_MAP.put("LIGHT_GRAY", 0xC0C0C0);
        COLOR_MAP.put("DARK_GRAY", 0x404040);
        COLOR_MAP.put("ORANGE", 16753920);
        COLOR_MAP.put("PINK", 16761035);
        COLOR_MAP.put("PURPLE", 0x800080);
        COLOR_MAP.put("BROWN", 0xA52A2A);
        COLOR_MAP.put("GOLD", 16766720);
        COLOR_MAP.put("SILVER", 0xC0C0C0);
        COLOR_MAP.put("DEFAULT", 0);
        COLOR_MAP.put("NAVY", 128);
        COLOR_MAP.put("TEAL", 32896);
        COLOR_MAP.put("LIME", 65280);
        COLOR_MAP.put("MAROON", 0x800000);
        COLOR_MAP.put("OLIVE", 0x808000);
        COLOR_MAP.put("CRIMSON", 14423100);
        COLOR_MAP.put("CORAL", 16744272);
        COLOR_MAP.put("SALMON", 16416882);
        COLOR_MAP.put("TURQUOISE", 4251856);
        COLOR_MAP.put("VIOLET", 0xEE82EE);
        COLOR_MAP.put("INDIGO", 4915330);
        COLOR_MAP.put("LAVENDER", 15132410);
        COLOR_MAP.put("PLUM", 0xDDA0DD);
        COLOR_MAP.put("TAN", 13808780);
        COLOR_MAP.put("BEIGE", 16119260);
        COLOR_MAP.put("MINT", 0x98FF98);
        COLOR_MAP.put("SKY_BLUE", 8900331);
        COLOR_MAP.put("SLATE_GRAY", 7372944);
        COLOR_MAP.put("DARK_SLATE_GRAY", 0x2F4F4F);
        COLOR_MAP.put("CHOCOLATE", 13789470);
        COLOR_MAP.put("PERU", 13468991);
        COLOR_MAP.put("KHAKI", 15787660);
        COLOR_MAP.put("THISTLE", 14204888);
        COLOR_MAP.put("NEON_GREEN", 3800852);
        COLOR_MAP.put("ELECTRIC_BLUE", 8255999);
        COLOR_MAP.put("HOT_PINK", 16738740);
        COLOR_MAP.put("BRIGHT_ORANGE", 16753920);
        COLOR_MAP.put("NEON_YELLOW", 0xFFFF33);
        COLOR_MAP.put("NEON_PURPLE", 10289407);
        COLOR_MAP.put("DARK_RED", 0x8B0000);
        COLOR_MAP.put("DARK_GREEN", 25600);
        COLOR_MAP.put("DARK_BLUE", 139);
        COLOR_MAP.put("LIGHT_BLUE", 11393254);
        COLOR_MAP.put("LIGHT_GREEN", 0x90EE90);
        COLOR_MAP.put("LIGHT_PINK", 16758465);
        COLOR_MAP.put("LIGHT_YELLOW", 0xFFFFE0);
        COLOR_MAP.put("LIGHT_CYAN", 0xE0FFFF);
        COLOR_MAP.forEach((name, code) -> {
            String string = COLOR_CODE_TO_NAME.put((Integer)code, (String)name);
        });
    }

    public static List<String> getAll() {
        ArrayList<String> colors = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : COLOR_MAP.entrySet()) {
            colors.add(entry.getKey().toLowerCase().replace("_", "-"));
        }
        return colors;
    }

    public static String convertToColoredStringWithColorName(int color) {
        return "&#" + String.format("%06X", color & 0xFFFFFF) + MapColor.fromInt(color);
    }

    public static String fromInt(int color) {
        String name = COLOR_CODE_TO_NAME.get(color);
        if (name == null) {
            return "Unknown";
        }
        return MapColor.formatColorName(name);
    }

    private static String formatColorName(String name) {
        String[] words = name.split("_");
        StringBuilder formatted = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!word.isEmpty()) {
                formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
            }
            ++n2;
        }
        return formatted.toString().trim();
    }

    public static int parseFromString(String colorString) {
        if ((colorString = colorString.toUpperCase().replace("-", "_")) == null || colorString.isEmpty()) {
            return 0;
        }
        Integer color = COLOR_MAP.get(colorString);
        return color == null ? 0 : color;
    }
}

