/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.structure.serializable;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class SerializableChunk {
    private String worldName;
    private int x;
    private int z;
    private long claimedAt;

    public SerializableChunk(Chunk chunk) {
        this.worldName = chunk.getWorld().getName();
        this.x = chunk.getX();
        this.z = chunk.getZ();
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(String worldName, int x, int z) {
        this.worldName = worldName;
        this.x = x;
        this.z = z;
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(World world, int x, int z) {
        this.worldName = world.getName();
        this.x = x;
        this.z = z;
        this.claimedAt = System.currentTimeMillis();
    }

    public SerializableChunk(String worldName, int x, int z, long claimedAt) {
        this.worldName = worldName;
        this.x = x;
        this.z = z;
        this.claimedAt = claimedAt;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public long getClaimedAt() {
        return this.claimedAt;
    }

    public String toString() {
        return this.worldName + "," + this.x + "," + this.z + "," + this.claimedAt;
    }

    public String toString(boolean withoutClaimTime) {
        return this.worldName + "," + this.x + "," + this.z;
    }

    public static SerializableChunk fromString(String string) {
        String[] splitted = string.split(",");
        return new SerializableChunk(splitted[0], Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), Long.parseLong(splitted[3]));
    }

    public static String convertToString(Chunk chunk) {
        return chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ() + "," + System.currentTimeMillis();
    }

    public static String convertToString(Chunk chunk, boolean withoutClaimTime) {
        return chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
    }

    public Location getBukkitLocation() {
        Location newLocation;
        World world = Bukkit.getWorld((String)this.worldName);
        Location location = new Location(world, (double)(this.x * 16 + 8), 64.0, (double)(this.z * 16 + 8));
        location.setY((double)(world.getHighestBlockYAt(location) + 2));
        if (world.getEnvironment().equals((Object)World.Environment.NETHER) && (newLocation = this.findSafeNetherLocation(world, this.x * 16 + 8, this.z * 16 + 8)) != null) {
            location = newLocation;
        }
        return location;
    }

    public Chunk getBukkitChunk() {
        return this.getBukkitLocation().getChunk();
    }

    private Location findSafeNetherLocation(World world, int x, int z) {
        int maxY;
        int minY = 32;
        int y = maxY = 124;
        while (y >= minY) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            Block aboveAbove = world.getBlockAt(x, y + 2, z);
            if (block.getType() != Material.AIR && block.getType() != Material.LAVA && above.getType() == Material.AIR && aboveAbove.getType() == Material.AIR) {
                return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            --y;
        }
        return null;
    }
}

