/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.particles;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;

public class ChunkParticlesSpawner {
    private static final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();
    private final Player player;

    public ChunkParticlesSpawner(Player player) {
        this.player = player;
        if (tasks.containsKey(player.getUniqueId())) {
            BukkitTask taskFromMap = tasks.get(player.getUniqueId());
            ChunkParticlesSpawner.cancelTask(taskFromMap, player);
        }
        this.startRepeatingEffect(15L);
    }

    public void spawnParticles() {
        for (Region region : RegionsManager.getAll()) {
            this.spawnParticlesForRegion(region);
        }
    }

    public void spawnParticlesForRegion(Region region) {
        List<SerializableChunk> chunks = region.getChunks();
        for (SerializableChunk chunk : chunks) {
            Chunk east;
            Chunk west;
            Chunk south;
            World world = this.player.getWorld();
            double yOffset = this.player.getLocation().getY() + 1.0;
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            String chunkWorldName = chunk.getWorldName();
            int minX = chunkX * 16;
            int minZ = chunkZ * 16;
            if (!this.player.getLocation().getWorld().getName().equals(chunkWorldName)) continue;
            Particle.DustOptions dustoptions = (region = RegionsManager.findRegion(region.getUniqueId())).getOwnerId().equals(this.player.getUniqueId()) ? new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 2.0f) : (region.isPlayerMember((OfflinePlayer)this.player) ? new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)0), 2.0f) : new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 2.0f));
            Chunk north = world.getChunkAt(chunkX, chunkZ - 1);
            if (ChunksManager.getRegionOwnsTheChunk(north) == null || ChunksManager.getRegionOwnsTheChunk(north) != null && !ChunksManager.getRegionOwnsTheChunk(north).getUniqueId().equals(region.getUniqueId())) {
                int x = minX;
                while (x < minX + 16) {
                    this.player.spawnParticle(Particle.DUST, (double)x, yOffset, (double)minZ, 5, (Object)dustoptions);
                    ++x;
                }
            }
            if (ChunksManager.getRegionOwnsTheChunk(south = world.getChunkAt(chunkX, chunkZ + 1)) == null || ChunksManager.getRegionOwnsTheChunk(south) != null && !ChunksManager.getRegionOwnsTheChunk(south).getUniqueId().equals(region.getUniqueId())) {
                int x = minX;
                while (x < minX + 16) {
                    this.player.spawnParticle(Particle.DUST, (double)x, yOffset, (double)(minZ + 16), 5, (Object)dustoptions);
                    ++x;
                }
            }
            if (ChunksManager.getRegionOwnsTheChunk(west = world.getChunkAt(chunkX - 1, chunkZ)) == null || ChunksManager.getRegionOwnsTheChunk(west) != null && !ChunksManager.getRegionOwnsTheChunk(west).getUniqueId().equals(region.getUniqueId())) {
                int z = minZ;
                while (z < minZ + 16) {
                    this.player.spawnParticle(Particle.DUST, (double)minX, yOffset, (double)z, 5, (Object)dustoptions);
                    ++z;
                }
            }
            if (ChunksManager.getRegionOwnsTheChunk(east = world.getChunkAt(chunkX + 1, chunkZ)) != null && (ChunksManager.getRegionOwnsTheChunk(east) == null || ChunksManager.getRegionOwnsTheChunk(east).getUniqueId().equals(region.getUniqueId()))) continue;
            int z = minZ;
            while (z < minZ + 16) {
                this.player.spawnParticle(Particle.DUST, (double)(minX + 16), yOffset, (double)z, 5, (Object)dustoptions);
                ++z;
            }
        }
    }

    public void startRepeatingEffect(long intervalTicks) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                ChunkParticlesSpawner.this.spawnParticles();
            }
        }.runTaskTimer((Plugin)Homestead.getInstance(), 0L, intervalTicks);
        tasks.put(this.player.getUniqueId(), task);
        Bukkit.getScheduler().runTaskLater((Plugin)Homestead.getInstance(), () -> ChunkParticlesSpawner.cancelTask(task, this.player), 1200L);
    }

    public static void cancelTask(BukkitTask task, Player player) {
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
            task = null;
        }
    }

    public static void cancelTask(Player player) {
        BukkitTask task = tasks.get(player.getUniqueId());
        if (task != null) {
            tasks.remove(player.getUniqueId());
            task.cancel();
            task = null;
        }
    }
}

