/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations.maps;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.registry.WorldRegistry;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.Location;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.integrations.maps.RegionIconTools;
import tfagaming.projects.minecraft.homestead.managers.ChunksManager;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chat.ChatColorTranslator;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class Pl3xMapAPI {
    private static Map<org.bukkit.World, SimpleLayer> layers = new HashMap<org.bukkit.World, SimpleLayer>();

    public Pl3xMapAPI(Homestead plugin) {
        try {
            this.update();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void clearAllMarkers() {
        for (SimpleLayer layer : layers.values()) {
            if (layer == null) continue;
            layer.getMarkers().removeIf(__ -> true);
        }
    }

    public void addChunkMarker(Region region, SerializableChunk chunk) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", region.getName());
        replacements.put("{region-owner}", region.getOwner().getName());
        replacements.put("{region-members}", ChatColorTranslator.removeColor(Formatters.getMembersOfRegion(region), false));
        replacements.put("{region-chunks}", String.valueOf(region.getChunks().size()));
        replacements.put("{global-rank}", String.valueOf(RegionsManager.getGlobalRank(region.getUniqueId())));
        replacements.put("{region-description}", region.getDescription());
        replacements.put("{region-size}", String.valueOf(region.getChunks().size() * 256));
        boolean isOperator = PlayerUtils.isOperator(region.getOwner());
        String hoverText = Formatters.replace(isOperator ? (String)Homestead.config.get("dynamic-maps.chunks.operator-description") : (String)Homestead.config.get("dynamic-maps.chunks.description"), replacements);
        int chunkColor = region.getMapColor() == 0 ? (isOperator ? ((Integer)Homestead.config.get("dynamic-maps.chunks.operator-color")).intValue() : ((Integer)Homestead.config.get("dynamic-maps.chunks.color")).intValue()) : region.getMapColor();
        org.bukkit.World world = chunk.getWorld();
        SimpleLayer layer = layers.get(world);
        if (layer == null) {
            String layerId = "claims_" + world.getName();
            WorldRegistry worldRegistry = Pl3xMap.api().getWorldRegistry();
            World mapWorld = (World)worldRegistry.get(world.getName());
            if (mapWorld != null) {
                layer = new SimpleLayer(layerId, () -> "Homestead Regions");
                layer.setPriority(1);
                layer.setZIndex(Integer.valueOf(1));
                layer.setLiveUpdate(true);
                mapWorld.getLayerRegistry().register((Keyed)layer);
                layers.put(world, layer);
            }
        }
        this.addChunkMarkerWithOptions(layer, chunk, hoverText, chunkColor, !this.isChunkClaimed(region, chunk, GeoDirection.NORTH), !this.isChunkClaimed(region, chunk, GeoDirection.EAST), !this.isChunkClaimed(region, chunk, GeoDirection.SOUTH), !this.isChunkClaimed(region, chunk, GeoDirection.WEST));
        boolean isEnabled = (Boolean)Homestead.config.get("dynamic-maps.icons.enabled");
        if (isEnabled) {
            SimpleLayer finalLayer = layer;
            if (region.getLocation() != null && region.getLocation().getBukkitLocation().getChunk().equals(chunk.getBukkitChunk())) {
                Homestead.getInstance().runAsyncTask(() -> this.addRegionIcon(finalLayer, region, hoverText));
            }
        }
    }

    private void addChunkMarkerWithOptions(SimpleLayer targetLayer, SerializableChunk chunk, String hoverText, int chunkColor, boolean north, boolean east, boolean south, boolean west) {
        String markerId = "fill_" + chunk.getX() + "_" + chunk.getZ();
        Point point1 = Point.of((int)(chunk.getX() * 16), (int)(chunk.getZ() * 16));
        Point point2 = Point.of((int)(chunk.getX() * 16 + 16), (int)(chunk.getZ() * 16 + 16));
        Rectangle rectangle = new Rectangle(markerId, point1, point2);
        rectangle.setOptions(Options.builder().tooltipContent(hoverText).fillColor(Integer.valueOf(Colors.setAlpha((int)50, (int)chunkColor))).strokeColor(Integer.valueOf(Colors.setAlpha((int)0, (int)chunkColor))).strokeWeight(Integer.valueOf(0)).fill(Boolean.valueOf(true)).stroke(Boolean.valueOf(false)).build());
        targetLayer.addMarker((Marker)rectangle);
        if (north) {
            this.addBorderLine(targetLayer, chunk, GeoDirection.NORTH, chunkColor);
        }
        if (east) {
            this.addBorderLine(targetLayer, chunk, GeoDirection.EAST, chunkColor);
        }
        if (south) {
            this.addBorderLine(targetLayer, chunk, GeoDirection.SOUTH, chunkColor);
        }
        if (west) {
            this.addBorderLine(targetLayer, chunk, GeoDirection.WEST, chunkColor);
        }
    }

    private void addBorderLine(SimpleLayer layer, SerializableChunk chunk, GeoDirection side, int color) {
        Point p2;
        Point p1;
        int x = chunk.getX();
        int z = chunk.getZ();
        String markerId = "border_" + x + "_" + z + "_" + String.valueOf((Object)side);
        switch (side) {
            case NORTH: {
                p1 = Point.of((int)(x * 16), (int)(z * 16));
                p2 = Point.of((int)(x * 16 + 16), (int)(z * 16));
                break;
            }
            case EAST: {
                p1 = Point.of((int)(x * 16 + 16), (int)(z * 16));
                p2 = Point.of((int)(x * 16 + 16), (int)(z * 16 + 16));
                break;
            }
            case SOUTH: {
                p1 = Point.of((int)(x * 16), (int)(z * 16 + 16));
                p2 = Point.of((int)(x * 16 + 16), (int)(z * 16 + 16));
                break;
            }
            case WEST: {
                p1 = Point.of((int)(x * 16), (int)(z * 16));
                p2 = Point.of((int)(x * 16), (int)(z * 16 + 16));
                break;
            }
            default: {
                return;
            }
        }
        Polyline line = new Polyline(markerId, List.of(p1, p2));
        line.setOptions(Options.builder().strokeColor(Integer.valueOf(Colors.setAlpha((int)255, (int)color))).strokeWeight(Integer.valueOf(2)).build());
        layer.addMarker((Marker)line);
    }

    public boolean isChunkClaimed(Region region, SerializableChunk chunk, GeoDirection direction) {
        int x = chunk.getX();
        int z = chunk.getZ();
        org.bukkit.World world = chunk.getWorld();
        return switch (direction) {
            case GeoDirection.NORTH -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x, z - 1).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case GeoDirection.EAST -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x + 1, z).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case GeoDirection.SOUTH -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x, z + 1).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            case GeoDirection.WEST -> {
                Region chunksRegion = ChunksManager.getRegionOwnsTheChunk(new SerializableChunk(world, x - 1, z).getBukkitChunk());
                yield chunksRegion != null && chunksRegion.getUniqueId().equals(region.getUniqueId());
            }
            default -> false;
        };
    }

    private void addRegionIcon(SimpleLayer layer, Region region, String hoverText) {
        BufferedImage bufferedIcon = RegionIconTools.getIconBufferedImage(region.getIcon());
        int iconSize = (Integer)Homestead.config.get("dynamic-maps.icons.size");
        if (region.getLocation() == null) {
            return;
        }
        try {
            String iconId = "region_icon_" + region.getName().toLowerCase().replaceAll(" ", "_");
            Location regionLocation = region.getLocation().getBukkitLocation();
            Point iconPoint = Point.of((double)regionLocation.getX(), (double)regionLocation.getZ());
            if (bufferedIcon != null) {
                IconImage iconImage = new IconImage(iconId, bufferedIcon, "png");
                if (Pl3xMap.api().getIconRegistry().has(iconId) && !((IconImage)Pl3xMap.api().getIconRegistry().get(iconId)).getImage().equals(iconImage.getImage())) {
                    Pl3xMap.api().getIconRegistry().unregister(iconId);
                }
                if (!Pl3xMap.api().getIconRegistry().has(iconId)) {
                    Pl3xMap.api().getIconRegistry().register(iconId, iconImage);
                }
                Icon iconMarker = Marker.icon((String)("marker_" + iconId), (Point)iconPoint, (String)iconId, (double)iconSize, (double)iconSize);
                iconMarker.setOptions(Options.builder().tooltipContent(hoverText).build());
                layer.addMarker((Marker)iconMarker);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        this.clearAllMarkers();
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk chunk : region.getChunks()) {
                this.addChunkMarker(region, chunk);
            }
        }
    }

    private static enum GeoDirection {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

