/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.integrations;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import tfagaming.projects.minecraft.homestead.logs.Logger;

public class WorldGuardAPI {
    public static boolean warningSent = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isChunkInWorldGuardRegion(Chunk chunk) {
        try {
            RegionContainer regionContainer = WorldGuardAPI.getInstance().getPlatform().getRegionContainer();
            World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)chunk.getWorld());
            if (worldEditWorld == null) {
                return false;
            }
            RegionManager regionManager = regionContainer.get(worldEditWorld);
            if (regionManager == null) {
                return false;
            }
            int chunkX = chunk.getX() << 4;
            int chunkZ = chunk.getZ() << 4;
            int x = chunkX;
            block2: while (true) {
                if (x >= chunkX + 16) {
                    return false;
                }
                int z = chunkZ;
                while (true) {
                    if (z >= chunkZ + 16) {
                        ++x;
                        continue block2;
                    }
                    Location location = new Location(chunk.getWorld(), (double)x, 64.0, (double)z);
                    BlockVector3 blockVector = BukkitAdapter.asBlockVector((Location)location);
                    ApplicableRegionSet regionSet = regionManager.getApplicableRegions(blockVector);
                    if (regionSet.size() > 0) {
                        return true;
                    }
                    ++z;
                }
                break;
            }
        }
        catch (NoClassDefFoundError e) {
            if (!warningSent) {
                Logger.error("Protection against claiming inside WorldGuard regions is enabled, but the WorldGuard class was not found.");
                Logger.error("Please install the WorldGuard plugin on your server or turn off this feature in the config.yml file.");
                warningSent = true;
            }
            return false;
        }
    }

    public static WorldGuard getInstance() {
        return WorldGuard.getInstance();
    }
}

