/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionInfoMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.targetedregion.TargetRegionSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.ListUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.teleportation.DelayedTeleport;

public class RegionsMenu {
    List<Region> regions = new ArrayList<Region>();

    public List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.regions.size()) {
            Region region = this.regions.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{region-displayname}", region.getDisplayName());
            replacements.put("{region-owner}", region.getOwner().getName());
            replacements.put("{region-bank}", Formatters.formatBalance(region.getBank()));
            replacements.put("{region-createdat}", Formatters.formatDate(region.getCreatedAt()));
            Region targetRegion = TargetRegionSession.getRegion((OfflinePlayer)player);
            if (targetRegion != null && targetRegion.getUniqueId().equals(region.getUniqueId())) {
                items.add(MenuUtils.getButton(5, replacements, new OfflinePlayer[0]));
            } else {
                items.add(MenuUtils.getButton(4, replacements, new OfflinePlayer[0]));
            }
            ++i;
        }
        return items;
    }

    public RegionsMenu(Player player) {
        this.regions.addAll(RegionsManager.getRegionsOwnedByPlayer((OfflinePlayer)player));
        this.regions.addAll(RegionsManager.getRegionsHasPlayerAsMember((OfflinePlayer)player));
        this.regions = ListUtils.removeDuplications(this.regions);
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(0), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player), (_player, event) -> _player.closeInventory(), (_player, context) -> {
            if (context.getIndex() >= this.regions.size()) {
                return;
            }
            Region region = this.regions.get(context.getIndex());
            if (context.getEvent().isShiftClick() && context.getEvent().isRightClick()) {
                new RegionInfoMenu(player, region, () -> new RegionsMenu(player));
            } else if (context.getEvent().isRightClick()) {
                if (region.getLocation() == null) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{region}", region.getName());
                    PlayerUtils.sendMessage(player, 71, replacements);
                    return;
                }
                new DelayedTeleport(player, region.getLocation().getBukkitLocation());
            } else if (context.getEvent().isShiftClick() && context.getEvent().isLeftClick()) {
                if (TargetRegionSession.getRegion((OfflinePlayer)player) != null && TargetRegionSession.getRegion((OfflinePlayer)player).getUniqueId().equals(region.getUniqueId())) {
                    return;
                }
                new TargetRegionSession(player, region);
                player.playSound(player.getLocation(), Sound.BLOCK_LEVER_CLICK, 500.0f, 1.0f);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 12, replacements);
                PaginationMenu instance = context.getInstance();
                this.regions = RegionsManager.getRegionsOwnedByPlayer((OfflinePlayer)player);
                instance.setItems(this.getItems(player));
            } else if (context.getEvent().isLeftClick()) {
                new RegionMenu(player, region);
            }
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

