/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.PaginationMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.ManagePlayersMenu;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableBannedPlayer;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class RegionBannedPlayersMenu {
    List<SerializableBannedPlayer> bannedPlayers;

    public List<ItemStack> getItems(Player player, Region region) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.bannedPlayers.size()) {
            SerializableBannedPlayer bannedPlayer = this.bannedPlayers.get(i);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{region}", region.getName());
            replacements.put("{playername}", bannedPlayer.getBukkitOfflinePlayer().getName());
            replacements.put("{player-bannedat}", Formatters.formatDate(bannedPlayer.getBannedAt()));
            replacements.put("{player-banreason}", bannedPlayer.getReason());
            items.add(MenuUtils.getButton(27, replacements, bannedPlayer.getBukkitOfflinePlayer()));
            ++i;
        }
        return items;
    }

    public RegionBannedPlayersMenu(Player player, Region region) {
        this.bannedPlayers = region.getBannedPlayers();
        PaginationMenu gui = new PaginationMenu(MenuUtils.getTitle(9), 36, MenuUtils.getNextPageButton(), MenuUtils.getPreviousPageButton(), this.getItems(player, region), (_player, event) -> new ManagePlayersMenu(player, region), (_player, context) -> {
            if (context.getIndex() >= this.bannedPlayers.size()) {
                return;
            }
            SerializableBannedPlayer bannedPlayer = this.bannedPlayers.get(context.getIndex());
            if (context.getEvent().isLeftClick() && region.isPlayerBanned(bannedPlayer.getBukkitOfflinePlayer())) {
                if (!player.hasPermission("homestead.region.players.unban")) {
                    PlayerUtils.sendMessage(player, 8);
                    return;
                }
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 8L)) {
                    return;
                }
                region.unbanPlayer(bannedPlayer.getBukkitOfflinePlayer());
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{playername}", bannedPlayer.getBukkitOfflinePlayer().getName());
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 34, replacements);
                PaginationMenu instance = context.getInstance();
                this.bannedPlayers = region.getBannedPlayers();
                instance.setItems(this.getItems(player, region));
            }
        });
        gui.addActionButton(0, MenuUtils.getButton(28, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!player.hasPermission("homestead.region.players.ban")) {
                PlayerUtils.sendMessage(player, 8);
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                OfflinePlayer targetPlayer = Homestead.getInstance().getOfflinePlayerSync((String)input);
                region.banPlayer(targetPlayer);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{playername}", targetPlayer.getName());
                replacements.put("{region}", region.getName());
                replacements.put("{reason}", (String)Homestead.language.get("default.reason"));
                PlayerUtils.sendMessage(player, 31, replacements);
                if (region.isPlayerMember(targetPlayer)) {
                    region.removeMember(targetPlayer);
                }
                if (region.isPlayerInvited(targetPlayer)) {
                    region.removePlayerInvite(targetPlayer);
                }
                Homestead.getInstance().runSyncTask(() -> new RegionBannedPlayersMenu(player, region));
            }, (Function<String, Boolean>)((Function)message -> {
                OfflinePlayer target = Homestead.getInstance().getOfflinePlayerSync((String)message);
                if (target == null) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", (String)message);
                    PlayerUtils.sendMessage(player, 29, replacements);
                    return false;
                }
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 4L)) {
                    return false;
                }
                if (region.isPlayerBanned(target)) {
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    replacements.put("{playername}", target.getName());
                    PlayerUtils.sendMessage(player, 32, replacements);
                    return false;
                }
                if (target.getUniqueId().equals(region.getOwnerId())) {
                    PlayerUtils.sendMessage(player, 30);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new RegionBannedPlayersMenu(player, region)), 73);
        });
        gui.addActionButton(2, MenuUtils.getButton(32, new OfflinePlayer[0]), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (region.getBannedPlayers().size() == 0) {
                PlayerUtils.sendMessage(player, 77);
                return;
            }
            region.setBannedPlayers(new ArrayList<SerializableBannedPlayer>());
            PlayerUtils.sendMessage(player, 94);
            Homestead.getInstance().runSyncTask(() -> new RegionBannedPlayersMenu(player, region));
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

