/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.tools.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StringSimilarity {
    public static List<String> findTopSimilarStrings(List<String> list, String comparison) {
        if (list == null || comparison == null) {
            throw new IllegalArgumentException("Input list and comparison string cannot be null");
        }
        if (list.size() <= 3) {
            return new ArrayList<String>(list);
        }
        ArrayList<StringScore> scoredStrings = new ArrayList<StringScore>();
        for (String str : list) {
            double score = StringSimilarity.similarity(str, comparison);
            scoredStrings.add(new StringScore(str, score));
        }
        Collections.sort(scoredStrings, new Comparator<StringScore>(){

            @Override
            public int compare(StringScore o1, StringScore o2) {
                return Double.compare(o2.score, o1.score);
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < Math.min(3, scoredStrings.size())) {
            result.add(((StringScore)scoredStrings.get((int)i)).str);
            ++i;
        }
        return result;
    }

    private static double similarity(String s1, String s2) {
        String shorter;
        if (s1 == null || s2 == null) {
            return 0.0;
        }
        String longer = s1.length() > s2.length() ? s1 : s2;
        String string = shorter = s1.length() > s2.length() ? s2 : s1;
        if (longer.length() == 0) {
            return 1.0;
        }
        double distance = StringSimilarity.levenshteinDistance(longer, shorter);
        return 1.0 - distance / (double)longer.length();
    }

    private static int levenshteinDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        int i = 0;
        while (i <= s1.length()) {
            int lastValue = i;
            int j = 0;
            while (j <= s2.length()) {
                if (i == 0) {
                    costs[j] = j;
                } else if (j > 0) {
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                ++j;
            }
            if (i > 0) {
                costs[s2.length()] = lastValue;
            }
            ++i;
        }
        return costs[s2.length()];
    }

    private static class StringScore {
        String str;
        double score;

        StringScore(String str, double score) {
            this.str = str;
            this.score = score;
        }
    }
}

