/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.api.events.ChunkClaimEvent;
import tfagaming.projects.minecraft.homestead.api.events.ChunkUnclaimEvent;
import tfagaming.projects.minecraft.homestead.integrations.WorldEditAPI;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableChunk;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableSubArea;
import tfagaming.projects.minecraft.homestead.tools.minecraft.chunks.ChunkUtils;

public class ChunksManager {
    public static void claimChunk(UUID id, Chunk chunk, OfflinePlayer ... player) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        region.addChunk(new SerializableChunk(chunk));
        ChunkClaimEvent event = new ChunkClaimEvent(chunk, player.length > 0 ? player[0] : null);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
    }

    public static void unclaimChunk(UUID id, Chunk chunk, OfflinePlayer ... player) {
        ChunksManager.removeChunk(id, new SerializableChunk(chunk));
        boolean isRegeneratingChunksEnabled = (Boolean)Homestead.config.get("worldedit.regenerate-chunks");
        if (isRegeneratingChunksEnabled) {
            Homestead.getInstance().runAsyncTask(() -> WorldEditAPI.regenerateChunk(chunk.getWorld(), chunk.getX(), chunk.getZ()));
        }
        ChunkUnclaimEvent event = new ChunkUnclaimEvent(chunk, player.length > 0 ? player[0] : null);
        Homestead.getInstance().runSyncTask(() -> Bukkit.getPluginManager().callEvent((Event)event));
    }

    public static void removeChunk(UUID id, SerializableChunk chunk) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        region.removeChunk(chunk);
        block0: for (SerializableSubArea subArea : region.getSubAreas()) {
            for (Chunk subAreaChunk : ChunkUtils.getChunksInArea(subArea.getFirstPoint(), subArea.getSecondPoint())) {
                if (!new SerializableChunk(subAreaChunk).toString(true).equals(chunk.toString(true))) continue;
                region.removeSubArea(subArea.getId());
                continue block0;
            }
        }
    }

    public static boolean isChunkInDisabledWorld(Chunk chunk) {
        List disabledWorlds = (List)Homestead.config.get("disabled-worlds");
        return disabledWorlds.contains(chunk.getWorld().getName());
    }

    public static boolean isChunkClaimed(Chunk chunk) {
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk serializedChunk : region.getChunks()) {
                String chunkString = SerializableChunk.convertToString(chunk, true);
                if (!serializedChunk.toString(true).equals(chunkString)) continue;
                return true;
            }
        }
        return false;
    }

    public static Region getRegionOwnsTheChunk(Chunk chunk) {
        for (Region region : RegionsManager.getAll()) {
            for (SerializableChunk serializedChunk : region.getChunks()) {
                String chunkString = SerializableChunk.convertToString(chunk, true);
                if (!serializedChunk.toString(true).equals(chunkString)) continue;
                return region;
            }
        }
        return null;
    }

    public static Chunk findNearbyUnclaimedChunk(Player player) {
        Chunk startChunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int startX = startChunk.getX();
        int startZ = startChunk.getZ();
        int radius = 1;
        int maxRadius = 30;
        while (radius <= maxRadius) {
            int x = -radius;
            while (x <= radius) {
                int z = -radius;
                while (z <= radius) {
                    Chunk currentChunk;
                    if (!(Math.abs(x) != radius && Math.abs(z) != radius || ChunksManager.isChunkClaimed(currentChunk = world.getChunkAt(startX + x, startZ + z)))) {
                        return currentChunk;
                    }
                    ++z;
                }
                ++x;
            }
            ++radius;
        }
        return null;
    }

    public static boolean hasNeighbor(Player player) {
        Region region;
        Chunk chunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int x = chunk.getX();
        int z = chunk.getZ();
        Chunk north = world.getChunkAt(x, z - 1);
        Chunk south = world.getChunkAt(x, z + 1);
        Chunk west = world.getChunkAt(x - 1, z);
        Chunk east = world.getChunkAt(x + 1, z);
        if (ChunksManager.isChunkClaimed(north) && !(region = ChunksManager.getRegionOwnsTheChunk(north)).getOwnerId().equals(player.getUniqueId())) {
            return true;
        }
        if (ChunksManager.isChunkClaimed(south) && !(region = ChunksManager.getRegionOwnsTheChunk(south)).getOwnerId().equals(player.getUniqueId())) {
            return true;
        }
        if (ChunksManager.isChunkClaimed(west) && !(region = ChunksManager.getRegionOwnsTheChunk(west)).getOwnerId().equals(player.getUniqueId())) {
            return true;
        }
        return ChunksManager.isChunkClaimed(east) && !(region = ChunksManager.getRegionOwnsTheChunk(east)).getOwnerId().equals(player.getUniqueId());
    }

    public static Chunk getFromLocation(World world, int x, int z) {
        Location location = new Location(world, (double)(x * 16 + 8), 64.0, (double)(z * 16 + 8));
        return location.getChunk();
    }

    public static Location getLocation(Player player, Chunk chunk) {
        Location location = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 8), 64.0, (double)(chunk.getZ() * 16 + 8));
        location.setY((double)(location.getWorld().getHighestBlockYAt(location) + 2));
        location.setPitch(player.getLocation().getPitch());
        location.setYaw(player.getLocation().getYaw());
        return location;
    }

    public static Location getLocation(Player player, SerializableChunk chunk) {
        Location location;
        World world = chunk.getWorld();
        int x = chunk.getX() * 16 + 8;
        int z = chunk.getZ() * 16 + 8;
        if (world == null) {
            return null;
        }
        if (world.getEnvironment() == World.Environment.NETHER) {
            location = ChunksManager.findSafeNetherLocation(world, x, z);
        } else {
            int highestY = world.getHighestBlockYAt(x, z);
            location = new Location(world, (double)x, (double)(highestY + 2), (double)z);
        }
        if (location != null) {
            location.setPitch(player.getLocation().getPitch());
            location.setYaw(player.getLocation().getYaw());
        }
        return location;
    }

    private static Location findSafeNetherLocation(World world, int x, int z) {
        int minY = 32;
        int maxY = 127;
        int y = minY;
        while (y < maxY) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            if (block.getType() == Material.AIR && above.getType() == Material.AIR) {
                return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            }
            ++y;
        }
        return null;
    }

    public static void removeRandomChunk(UUID id) {
        Region region = RegionsManager.findRegion(id);
        if (region == null) {
            return;
        }
        List<SerializableChunk> chunks = region.getChunks();
        if (chunks.size() > 0) {
            Random random = new Random();
            int randomIndex = random.nextInt(chunks.size());
            region.removeChunk(chunks.get(randomIndex));
        }
    }

    public static int deleteInvalidChunks() {
        int count = 0;
        ArrayList<String> worlds = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            worlds.add(world.getName());
        }
        for (Region region : RegionsManager.getAll()) {
            if (region == null || region.getChunks().size() == 0) continue;
            for (SerializableChunk serializedChunk : region.getChunks()) {
                if (worlds.contains(serializedChunk.getWorldName())) continue;
                region.removeChunk(serializedChunk);
                ++count;
            }
        }
        return count;
    }
}

