/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.gui.menus;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tfagaming.projects.minecraft.homestead.Homestead;
import tfagaming.projects.minecraft.homestead.gui.Menu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionMenu;
import tfagaming.projects.minecraft.homestead.gui.menus.RegionsMenu;
import tfagaming.projects.minecraft.homestead.managers.RegionsManager;
import tfagaming.projects.minecraft.homestead.sessions.playerinput.PlayerInputSession;
import tfagaming.projects.minecraft.homestead.structure.Region;
import tfagaming.projects.minecraft.homestead.structure.serializable.SerializableLocation;
import tfagaming.projects.minecraft.homestead.tools.java.Formatters;
import tfagaming.projects.minecraft.homestead.tools.java.StringUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.menus.MenuUtils;
import tfagaming.projects.minecraft.homestead.tools.minecraft.players.PlayerUtils;

public class MiscellaneousSettingsMenu {
    public MiscellaneousSettingsMenu(Player player, Region region) {
        Menu gui = new Menu(MenuUtils.getTitle(12), 27);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{region}", region.getName());
        replacements.put("{region-displayname}", region.getDisplayName());
        replacements.put("{region-description}", region.getDescription());
        ItemStack renameRegionButton = MenuUtils.getButton(34, replacements, new OfflinePlayer[0]);
        gui.addItem(11, renameRegionButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                String oldName = region.getName();
                region.setName((String)input);
                replacements.put("{oldname}", oldName);
                replacements.put("{newname}", (String)input);
                PlayerUtils.sendMessage(player, 13, (Map<String, String>)replacements);
                RegionsManager.addNewLog(region.getUniqueId(), 0, replacements);
                Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region));
            }, (Function<String, Boolean>)((Function)message -> {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 8192L)) {
                    return false;
                }
                if (!StringUtils.isValidRegionName(message)) {
                    PlayerUtils.sendMessage(player, 1);
                    return false;
                }
                if (message.equalsIgnoreCase(region.getName())) {
                    PlayerUtils.sendMessage(player, 11);
                    return false;
                }
                if (RegionsManager.isNameUsed(message)) {
                    PlayerUtils.sendMessage(player, 2);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region)), 78);
        });
        ItemStack setDisplaynameRegionButton = MenuUtils.getButton(35, replacements, new OfflinePlayer[0]);
        gui.addItem(12, setDisplaynameRegionButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                String oldDisplayName = region.getDisplayName();
                region.setDisplayName((String)input);
                replacements.put("{olddisplayname}", oldDisplayName);
                replacements.put("{newdisplayname}", region.getDisplayName());
                PlayerUtils.sendMessage(player, 15, (Map<String, String>)replacements);
                Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region));
            }, (Function<String, Boolean>)((Function)message -> {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 8192L)) {
                    return false;
                }
                if (!StringUtils.isValidRegionDisplayName(message)) {
                    PlayerUtils.sendMessage(player, 14);
                    return false;
                }
                if (region.getDisplayName().equals(message)) {
                    PlayerUtils.sendMessage(player, 11);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region)), 79);
        });
        ItemStack setDescriptionRegionButton = MenuUtils.getButton(36, replacements, new OfflinePlayer[0]);
        gui.addItem(13, setDescriptionRegionButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                String oldDescription = region.getDescription();
                region.setDescription((String)input);
                replacements.put("{olddescription}", oldDescription);
                replacements.put("{newdescription}", region.getDescription());
                PlayerUtils.sendMessage(player, 17, (Map<String, String>)replacements);
                Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region));
            }, (Function<String, Boolean>)((Function)message -> {
                if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 16384L)) {
                    return false;
                }
                if (!StringUtils.isValidRegionDescription(message)) {
                    PlayerUtils.sendMessage(player, 16);
                    return false;
                }
                if (region.getDescription().equals(message)) {
                    PlayerUtils.sendMessage(player, 11);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region)), 80);
        });
        ItemStack setLocationRegionButton = MenuUtils.getButton(37, replacements, new OfflinePlayer[0]);
        gui.addItem(14, setLocationRegionButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            if (!PlayerUtils.hasControlRegionPermissionFlag(region.getUniqueId(), player, 2048L)) {
                return;
            }
            Location location = player.getLocation();
            region.setLocation(new SerializableLocation(location));
            replacements.put("{region}", region.getName());
            replacements.put("{location}", Formatters.formatLocation(location));
            PlayerUtils.sendMessage(player, 72, (Map<String, String>)replacements);
            RegionsManager.addNewLog(region.getUniqueId(), 1, replacements);
        });
        ItemStack transferOwnershipRegionButton = MenuUtils.getButton(38, replacements, new OfflinePlayer[0]);
        gui.addItem(15, transferOwnershipRegionButton, (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            player.closeInventory();
            new PlayerInputSession(Homestead.getInstance(), player, (p, input) -> {
                OfflinePlayer targetPlayer = Homestead.getInstance().getOfflinePlayerSync((String)input);
                region.setOwner(targetPlayer);
                replacements.put("{playername}", targetPlayer.getName());
                replacements.put("{region}", region.getName());
                PlayerUtils.sendMessage(player, 82, (Map<String, String>)replacements);
                if (region.isPlayerMember(targetPlayer)) {
                    region.removeMember(targetPlayer);
                }
                if (region.isPlayerInvited(targetPlayer)) {
                    region.removePlayerInvite(targetPlayer);
                }
                Homestead.getInstance().runSyncTask(() -> new RegionsMenu(player));
            }, (Function<String, Boolean>)((Function)message -> {
                OfflinePlayer target = Homestead.getInstance().getOfflinePlayerSync((String)message);
                if (target == null) {
                    replacements.put("{playername}", (String)message);
                    PlayerUtils.sendMessage(player, 29, (Map<String, String>)replacements);
                    return false;
                }
                if (!PlayerUtils.isOperator(player) && !region.getOwnerId().equals(player.getUniqueId())) {
                    PlayerUtils.sendMessage(player, 30);
                    return false;
                }
                if (region.isPlayerBanned(target)) {
                    replacements.put("{playername}", target.getName());
                    PlayerUtils.sendMessage(player, 32, (Map<String, String>)replacements);
                    return false;
                }
                if (target.getUniqueId().equals(region.getOwnerId())) {
                    PlayerUtils.sendMessage(player, 30);
                    return false;
                }
                return true;
            }), __player -> Homestead.getInstance().runSyncTask(() -> new MiscellaneousSettingsMenu(player, region)), 81);
        });
        gui.addItem(18, MenuUtils.getBackButton(), (_player, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            new RegionMenu(player, region);
        });
        gui.open(player, MenuUtils.getEmptySlot());
    }
}

