/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.flags;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import tfagaming.projects.minecraft.homestead.flags.FlagsCalculator;

public class PlayerFlags {
    public static final long BREAK_BLOCKS = 1L;
    public static final long PLACE_BLOCKS = 2L;
    public static final long CONTAINERS = 4L;
    public static final long DOORS = 8L;
    public static final long TRAP_DOORS = 16L;
    public static final long FENCE_GATES = 32L;
    public static final long USE_ANVIL = 64L;
    public static final long REDSTONE = 128L;
    public static final long LEVERS = 256L;
    public static final long BUTTONS = 512L;
    public static final long PRESSURE_PLATES = 1024L;
    public static final long USE_BELLS = 2048L;
    public static final long TRIGGER_TRIPWIRE = 4096L;
    public static final long FROST_WALKER = 8192L;
    public static final long HARVEST_CROPS = 16384L;
    public static final long BLOCK_TRAMPLING = 32768L;
    public static final long GENERAL_INTERACTION = 65536L;
    public static final long ARMOR_STANDS = 131072L;
    public static final long INTERACT_ENTITIES = 262144L;
    public static final long ITEM_FRAME_ROTATION = 524288L;
    public static final long DAMAGE_PASSIVE_ENTITIES = 0x100000L;
    public static final long DAMAGE_HOSTILE_ENTITIES = 0x200000L;
    public static final long TRADE_VILLAGERS = 0x400000L;
    public static final long IGNITE = 0x800000L;
    public static final long VEHICLES = 0x1000000L;
    public static final long TELEPORT_SPAWN = 0x2000000L;
    public static final long PASSTHROUGH = 0x4000000L;
    public static final long PVP = 0x8000000L;
    public static final long TAKE_FALL_DAMAGE = 0x10000000L;
    public static final long TELEPORT = 0x20000000L;
    public static final long THROW_POTIONS = 0x40000000L;
    public static final long PICKUP_ITEMS = 0x80000000L;
    public static final long SLEEP = 0x100000000L;
    public static final long TRIGGER_RAID = 0x200000000L;
    public static final long ELYTRA = 0x400000000L;

    public static List<String> getFlags() {
        return Lists.newArrayList((Object[])new String[]{"break-blocks", "place-blocks", "containers", "doors", "trap-doors", "fence-gates", "use-anvil", "redstone", "levers", "buttons", "pressure-plates", "use-bells", "trigger-tripwire", "frost-walker", "harvest-crops", "block-trampling", "general-interaction", "armor-stands", "interact-entities", "item-frame-rotation", "damage-passive-entities", "damage-hostile-entities", "trade-villagers", "ignite", "vehicles", "teleport-spawn", "passthrough", "pvp", "take-fall-damage", "teleport", "throw-potions", "pickup-items", "sleep", "trigger-raid", "elytra"});
    }

    public static long valueOf(String name) {
        List<String> flags = PlayerFlags.getFlags();
        if (flags.indexOf(name) == 0) {
            return 1L;
        }
        return 1L << flags.indexOf(name);
    }

    public static String from(long flag) {
        List<String> flags = PlayerFlags.getFlags();
        int i = 0;
        while (i < flags.size()) {
            long value = PlayerFlags.valueOf(flags.get(i));
            if (value == flag) {
                return flags.get(i);
            }
            ++i;
        }
        return "unknown-flag";
    }

    public static List<String> getSet(long flags) {
        List<String> allFlags = PlayerFlags.getFlags();
        ArrayList<String> enabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = PlayerFlags.valueOf(flag);
            if (!FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            enabledFlags.add(flag);
        }
        return enabledFlags;
    }

    public static List<String> getUnset(long flags) {
        List<String> allFlags = PlayerFlags.getFlags();
        ArrayList<String> disabledFlags = new ArrayList<String>();
        for (String flag : allFlags) {
            long flagValue = PlayerFlags.valueOf(flag);
            if (FlagsCalculator.isFlagSet(flags, flagValue)) continue;
            disabledFlags.add(flag);
        }
        return disabledFlags;
    }
}

