/*
 * Decompiled with CFR 0.152.
 */
package tfagaming.projects.minecraft.homestead.commands;

import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import tfagaming.projects.minecraft.homestead.Homestead;

public abstract class CommandBuilder
implements CommandExecutor,
TabCompleter {
    private final String name;
    private String[] aliases = new String[0];
    public final Homestead plugin = Homestead.getInstance();

    public CommandBuilder(String name) {
        this.name = name;
    }

    public CommandBuilder(String name, String ... aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public abstract boolean onExecution(CommandSender var1, String[] var2);

    public abstract List<String> onAutoComplete(CommandSender var1, String[] var2);

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        return this.onExecution(sender, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        return this.onAutoComplete(sender, args);
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static void register(CommandBuilder command) {
        PluginCommand bukkitCommand = Homestead.getInstance().getCommand(command.getName());
        if (bukkitCommand != null) {
            bukkitCommand.setExecutor((CommandExecutor)command);
            bukkitCommand.setTabCompleter((TabCompleter)command);
        }
        String[] stringArray = command.getAliases();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            PluginCommand bukkitCommandAlias = Homestead.getInstance().getCommand(alias);
            if (bukkitCommandAlias != null) {
                bukkitCommandAlias.setExecutor((CommandExecutor)command);
                bukkitCommandAlias.setTabCompleter((TabCompleter)command);
            }
            ++n2;
        }
    }
}

