/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import net.milkbowl.vault.PluginEnableListener;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.metrics.bukkit.Metrics;
import net.milkbowl.vault.metrics.charts.SimplePie;
import net.milkbowl.vault.papi.EconomyPlaceholders;
import net.milkbowl.vault2.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Vault
extends JavaPlugin {
    private static final String VAULT_BUKKIT_URL = "https://www.spigotmc.org/resources/vaultunlocked.117277/";
    private Logger log;
    private String newVersionTitle = "";
    private double newVersion = 0.0;
    private double currentVersion = 0.0;
    private String currentVersionTitle = "";
    private ScheduledExecutorService asyncTaskTimer;
    private static Vault instance;

    public void onDisable() {
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        if (this.asyncTaskTimer != null) {
            this.asyncTaskTimer.shutdownNow();
        }
    }

    public void onEnable() {
        instance = this;
        this.log = this.getLogger();
        this.currentVersionTitle = this.getDescription().getVersion().split("-")[0];
        this.currentVersion = Double.parseDouble(this.currentVersionTitle.replaceFirst("\\.", ""));
        this.getConfig().addDefault("update-check", (Object)true);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.getCommand("vault-info").setExecutor((CommandExecutor)this);
        this.getCommand("vault-convert").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VaultListener(), (Plugin)this);
        Metrics metrics = new Metrics(this, 22252);
        this.findCustomData(metrics);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new EconomyPlaceholders().register();
        } else {
            Bukkit.getPluginManager().registerEvents((Listener)new PluginEnableListener(), (Plugin)this);
        }
        this.log.info(String.format("Enabled Version %s", this.getDescription().getVersion()));
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (command.getName().equalsIgnoreCase("vault-info")) {
            if (!sender.hasPermission("vault.admin.info")) {
                sender.sendMessage("You do not have permission to use that command!");
                return true;
            }
            this.infoCommand(sender);
            return true;
        }
        if (command.getName().equalsIgnoreCase("vault-convert")) {
            if (!sender.hasPermission("vault.admin.convert")) {
                sender.sendMessage("You do not have permission to use that command!");
                return true;
            }
            this.convertCommand(sender, args);
            return true;
        }
        sender.sendMessage("VaultUnlocked Commands:");
        sender.sendMessage("  /vault-info - Displays information about Vault");
        sender.sendMessage("  /vault-convert [economy1] [economy2] - Converts from one Economy to another");
        return true;
    }

    private void convertCommand(CommandSender sender, String[] args) {
        String econName;
        Collection econs = this.getServer().getServicesManager().getRegistrations(Economy.class);
        Collection econs2 = this.getServer().getServicesManager().getRegistrations(net.milkbowl.vault2.economy.Economy.class);
        if (econs == null || econs.size() < 2 && econs2.isEmpty()) {
            sender.sendMessage("You must have at least 2 economies loaded to convert.");
            return;
        }
        if (args.length != 2) {
            sender.sendMessage("You must specify only the economy to convert from and the economy to convert to. (names should not contain spaces)");
            return;
        }
        Economy econ1 = null;
        Economy econ2 = null;
        net.milkbowl.vault2.economy.Economy econ1Unlocked = null;
        net.milkbowl.vault2.economy.Economy econ2Unlocked = null;
        StringBuilder economies = new StringBuilder();
        for (RegisteredServiceProvider econ : econs) {
            econName = ((Economy)econ.getProvider()).getName().replace(" ", "");
            if (econName.equalsIgnoreCase(args[0])) {
                econ1 = (Economy)econ.getProvider();
            } else if (econName.equalsIgnoreCase(args[1])) {
                econ2 = (Economy)econ.getProvider();
            }
            if (economies.length() > 0) {
                economies.append(", ");
            }
            economies.append(econName);
        }
        for (RegisteredServiceProvider econ : econs2) {
            econName = ((net.milkbowl.vault2.economy.Economy)econ.getProvider()).getName().replace(" ", "");
            if (econName.equalsIgnoreCase(args[0])) {
                econ1Unlocked = (net.milkbowl.vault2.economy.Economy)econ.getProvider();
            } else if (econName.equalsIgnoreCase(args[1])) {
                econ2Unlocked = (net.milkbowl.vault2.economy.Economy)econ.getProvider();
            }
            if (economies.length() > 0) {
                economies.append(", ");
            }
            economies.append(econName);
        }
        if (econ1 == null && econ1Unlocked == null) {
            sender.sendMessage("Could not find " + args[0] + " loaded on the server, check your spelling.");
            sender.sendMessage("Valid economies are: " + economies);
            return;
        }
        if (econ2 == null && econ2Unlocked == null) {
            sender.sendMessage("Could not find " + args[1] + " loaded on the server, check your spelling.");
            sender.sendMessage("Valid economies are: " + economies);
            return;
        }
        sender.sendMessage("This may take some time to convert, expect server lag.");
        boolean useUnlocked1 = econ1Unlocked != null;
        boolean useUnlocked2 = econ2Unlocked != null;
        String pluginID = "vault conversion";
        for (OfflinePlayer op : Bukkit.getServer().getOfflinePlayers()) {
            BigDecimal diff;
            if (useUnlocked1) {
                if (useUnlocked2) {
                    if (econ2Unlocked.hasAccount(op.getUniqueId())) continue;
                    econ2Unlocked.createAccount(op.getUniqueId(), op.getName());
                    diff = econ1Unlocked.getBalance("vault conversion", op.getUniqueId()).subtract(econ2Unlocked.getBalance("vault conversion", op.getUniqueId()));
                    if (diff.compareTo(BigDecimal.ZERO) > 0) {
                        econ2Unlocked.deposit("vault conversion", op.getUniqueId(), diff);
                        continue;
                    }
                    if (diff.compareTo(BigDecimal.ZERO) >= 0) continue;
                    econ2Unlocked.withdraw("vault conversion", op.getUniqueId(), diff.negate());
                    continue;
                }
                if (econ2.hasAccount(op)) continue;
                econ2.createPlayerAccount(op);
                diff = econ1Unlocked.getBalance("vault conversion", op.getUniqueId()).subtract(BigDecimal.valueOf(econ2.getBalance(op)));
                if (diff.compareTo(BigDecimal.ZERO) > 0) {
                    econ2.depositPlayer(op, diff.doubleValue());
                    continue;
                }
                if (diff.compareTo(BigDecimal.ZERO) >= 0) continue;
                econ2.withdrawPlayer(op, diff.negate().doubleValue());
                continue;
            }
            if (useUnlocked2) {
                if (econ2Unlocked.hasAccount(op.getUniqueId())) continue;
                econ2Unlocked.createAccount(op.getUniqueId(), op.getName());
                diff = BigDecimal.valueOf(econ1.getBalance(op)).subtract(econ2Unlocked.getBalance("vault conversion", op.getUniqueId()));
                if (diff.compareTo(BigDecimal.ZERO) > 0) {
                    econ2Unlocked.deposit("vault conversion", op.getUniqueId(), diff);
                    continue;
                }
                if (diff.compareTo(BigDecimal.ZERO) >= 0) continue;
                econ2Unlocked.withdraw("vault conversion", op.getUniqueId(), diff.negate());
                continue;
            }
            if (econ2.hasAccount(op)) continue;
            econ2.createPlayerAccount(op);
            diff = BigDecimal.valueOf(econ1.getBalance(op)).subtract(BigDecimal.valueOf(econ2.getBalance(op)));
            if (diff.compareTo(BigDecimal.ZERO) > 0) {
                econ2.depositPlayer(op, diff.doubleValue());
                continue;
            }
            if (diff.compareTo(BigDecimal.ZERO) >= 0) continue;
            econ2.withdrawPlayer(op, diff.negate().doubleValue());
        }
        sender.sendMessage("Conversion complete, please verify the data before using it.");
    }

    private void infoCommand(CommandSender sender) {
        StringBuilder registeredEcons = new StringBuilder();
        Collection econs = this.getServer().getServicesManager().getRegistrations(Economy.class);
        for (RegisteredServiceProvider econ : econs) {
            if (registeredEcons.length() > 0) {
                registeredEcons.append(", ");
            }
            registeredEcons.append(((Economy)econ.getProvider()).getName());
        }
        StringBuilder registeredModernEcons = new StringBuilder();
        Collection econs2 = this.getServer().getServicesManager().getRegistrations(net.milkbowl.vault2.economy.Economy.class);
        for (RegisteredServiceProvider econ : econs2) {
            if (registeredModernEcons.length() > 0) {
                registeredModernEcons.append(", ");
            }
            registeredModernEcons.append(((net.milkbowl.vault2.economy.Economy)econ.getProvider()).getName());
        }
        StringBuilder registeredPerms = new StringBuilder();
        Collection perms = this.getServer().getServicesManager().getRegistrations(net.milkbowl.vault.permission.Permission.class);
        for (RegisteredServiceProvider perm : perms) {
            if (registeredPerms.length() > 0) {
                registeredPerms.append(", ");
            }
            registeredPerms.append(((net.milkbowl.vault.permission.Permission)perm.getProvider()).getName());
        }
        StringBuilder registeredModernPerms = new StringBuilder();
        Collection perms2 = this.getServer().getServicesManager().getRegistrations(Permission.class);
        for (RegisteredServiceProvider perm : perms2) {
            if (registeredModernPerms.length() > 0) {
                registeredModernPerms.append(", ");
            }
            registeredModernPerms.append(((Permission)perm.getProvider()).getName());
        }
        StringBuilder registeredChats = new StringBuilder();
        Collection chats = this.getServer().getServicesManager().getRegistrations(Chat.class);
        for (RegisteredServiceProvider chat : chats) {
            if (registeredChats.length() > 0) {
                registeredChats.append(", ");
            }
            registeredChats.append(((Chat)chat.getProvider()).getName());
        }
        StringBuilder registeredModernChats = new StringBuilder();
        Collection chats2 = this.getServer().getServicesManager().getRegistrations(net.milkbowl.vault2.chat.Chat.class);
        for (RegisteredServiceProvider chat : chats2) {
            if (registeredModernChats.length() > 0) {
                registeredModernChats.append(", ");
            }
            registeredModernChats.append(((net.milkbowl.vault2.chat.Chat)chat.getProvider()).getName());
        }
        Economy econ = null;
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            econ = (Economy)rsp.getProvider();
        }
        net.milkbowl.vault2.economy.Economy econ2 = null;
        RegisteredServiceProvider rsp2 = this.getServer().getServicesManager().getRegistration(net.milkbowl.vault2.economy.Economy.class);
        if (rsp2 != null) {
            econ2 = (net.milkbowl.vault2.economy.Economy)rsp2.getProvider();
        }
        net.milkbowl.vault.permission.Permission perm = null;
        RegisteredServiceProvider rspp = this.getServer().getServicesManager().getRegistration(net.milkbowl.vault.permission.Permission.class);
        if (rspp != null) {
            perm = (net.milkbowl.vault.permission.Permission)rspp.getProvider();
        }
        Permission perm2 = null;
        RegisteredServiceProvider rspp2 = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rspp2 != null) {
            perm2 = (Permission)rspp2.getProvider();
        }
        Chat chat = null;
        RegisteredServiceProvider rspc = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (rspc != null) {
            chat = (Chat)rspc.getProvider();
        }
        net.milkbowl.vault2.chat.Chat chat2 = null;
        RegisteredServiceProvider rspc2 = this.getServer().getServicesManager().getRegistration(net.milkbowl.vault2.chat.Chat.class);
        if (rspc2 != null) {
            chat2 = (net.milkbowl.vault2.chat.Chat)rspc2.getProvider();
        }
        sender.sendMessage(String.format("[%s] Vault v%s Information", this.getDescription().getName(), this.getDescription().getVersion()));
        sender.sendMessage(String.format("[%s] Economy Legacy: %s%s", this.getDescription().getName(), econ == null ? "None" : econ.getName(), registeredEcons.length() == 0 ? "" : " [" + registeredEcons + "]"));
        sender.sendMessage(String.format("[%s] Economy Modern: %s%s", this.getDescription().getName(), econ2 == null ? "None" : econ2.getName(), registeredModernEcons.length() == 0 ? "" : " [" + registeredModernEcons + "]"));
        sender.sendMessage(String.format("[%s] Permission Legacy: %s%s", this.getDescription().getName(), perm == null ? "None" : perm.getName(), registeredPerms.length() == 0 ? "" : " [" + registeredPerms + "]"));
        sender.sendMessage(String.format("[%s] Permission Modern: %s%s", this.getDescription().getName(), perm2 == null ? "None" : perm2.getName(), registeredModernPerms.length() == 0 ? "" : " [" + registeredModernPerms + "]"));
        sender.sendMessage(String.format("[%s] Chat Legacy: %s%s", this.getDescription().getName(), chat == null ? "None" : chat.getName(), registeredChats.length() == 0 ? "" : " [" + registeredChats + "]"));
        sender.sendMessage(String.format("[%s] Chat Modern: %s%s", this.getDescription().getName(), chat2 == null ? "None" : chat2.getName(), registeredModernChats.length() == 0 ? "" : " [" + registeredChats + "]"));
    }

    public Optional<net.milkbowl.vault2.economy.Economy> modernProvider() {
        RegisteredServiceProvider econ = this.getServer().getServicesManager().getRegistration(net.milkbowl.vault2.economy.Economy.class);
        return Optional.ofNullable(econ.getProvider());
    }

    private static boolean packagesExists(String ... packages) {
        try {
            for (String pkg : packages) {
                Class.forName(pkg);
            }
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public double updateCheck(double currentVersion) {
        try {
            URL url = new URL("https://api.curseforge.com/servermods/files?projectids=33184");
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(5000);
            conn.addRequestProperty("User-Agent", "VaultUnlocked Update Checker");
            conn.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String response = reader.readLine();
            JSONArray array = (JSONArray)JSONValue.parse((String)response);
            if (array.isEmpty()) {
                this.getLogger().warning("No files found, or Feed URL is bad.");
                return currentVersion;
            }
            this.newVersionTitle = ((String)((JSONObject)array.get(array.size() - 1)).get((Object)"name")).replace("Vault", "").trim();
            return Double.parseDouble(this.newVersionTitle.replaceFirst("\\.", "").trim());
        }
        catch (Exception ignore) {
            this.log.info("There was an issue attempting to check for the latest version.");
            return currentVersion;
        }
    }

    private void findCustomData(Metrics metrics) {
        RegisteredServiceProvider rspEcon = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        Economy econ = null;
        if (rspEcon != null) {
            econ = (Economy)rspEcon.getProvider();
        }
        String econName = econ != null ? econ.getName() : "No Economy";
        metrics.addCustomChart(new SimplePie("economy", () -> econName));
        RegisteredServiceProvider rspPerm = Bukkit.getServer().getServicesManager().getRegistration(net.milkbowl.vault.permission.Permission.class);
        net.milkbowl.vault.permission.Permission perm = null;
        if (rspPerm != null) {
            perm = (net.milkbowl.vault.permission.Permission)rspPerm.getProvider();
        }
        String permName = perm != null ? perm.getName() : "No Economy";
        metrics.addCustomChart(new SimplePie("permission", () -> permName));
        RegisteredServiceProvider rspChat = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
        Chat chat = null;
        if (rspChat != null) {
            chat = (Chat)rspChat.getProvider();
        }
        String chatName = chat != null ? chat.getName() : "No Chat";
        metrics.addCustomChart(new SimplePie("chat", () -> chatName));
    }

    public static Vault instance() {
        return instance;
    }

    public class VaultListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (player.hasPermission("vault.update")) {
                try {
                    if (Vault.this.newVersion > Vault.this.currentVersion) {
                        player.sendMessage("VaultUnlocked " + Vault.this.newVersionTitle + " is out! You are running " + Vault.this.currentVersionTitle);
                        player.sendMessage("Update VaultUnlocked at: https://www.spigotmc.org/resources/vaultunlocked.117277/");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

