/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.teleport;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.platform.ServerEnvironment;
import pl.syntaxdevteam.punisher.platform.SchedulerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ,\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0007J$\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/teleport/SafeTeleportService;", "", "scheduler", "Lpl/syntaxdevteam/punisher/platform/SchedulerAdapter;", "foliaBasedOverride", "", "safetyEvaluator", "Lkotlin/Function1;", "Lorg/bukkit/Location;", "chunkLoader", "", "<init>", "(Lpl/syntaxdevteam/punisher/platform/SchedulerAdapter;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "foliaBased", "teleportSafely", "player", "Lorg/bukkit/entity/Player;", "location", "callback", "findNearestSafeLocation", "horizontalRange", "", "verticalRange", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nSafeTeleportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeTeleportService.kt\npl/syntaxdevteam/punisher/teleport/SafeTeleportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1011#2,2:159\n*S KotlinDebug\n*F\n+ 1 SafeTeleportService.kt\npl/syntaxdevteam/punisher/teleport/SafeTeleportService\n*L\n86#1:159,2\n*E\n"})
public final class SafeTeleportService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SchedulerAdapter scheduler;
    @NotNull
    private final Function1<Location, Boolean> safetyEvaluator;
    @NotNull
    private final Function1<Location, Unit> chunkLoader;
    private final boolean foliaBased;

    public SafeTeleportService(@NotNull SchedulerAdapter scheduler, @Nullable Boolean foliaBasedOverride, @NotNull Function1<? super Location, Boolean> safetyEvaluator, @NotNull Function1<? super Location, Unit> chunkLoader) {
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(safetyEvaluator, "safetyEvaluator");
        Intrinsics.checkNotNullParameter(chunkLoader, "chunkLoader");
        this.scheduler = scheduler;
        this.safetyEvaluator = safetyEvaluator;
        this.chunkLoader = chunkLoader;
        Boolean bl = foliaBasedOverride;
        this.foliaBased = bl != null ? bl.booleanValue() : ServerEnvironment.INSTANCE.isFoliaBased();
    }

    public /* synthetic */ SafeTeleportService(SchedulerAdapter schedulerAdapter, Boolean bl, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            function1 = new Function1<Location, Boolean>((Object)Companion){

                @Override
                public final Boolean invoke(Location p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((Companion)this.receiver).isLocationSafe(p0);
                }
            };
        }
        if ((n & 8) != 0) {
            function12 = SafeTeleportService::_init_$lambda$0;
        }
        this(schedulerAdapter, bl, function1, function12);
    }

    public final void teleportSafely(@NotNull Player player, @NotNull Location location, @NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(callback, "callback");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location target = location2;
        if (this.foliaBased) {
            this.scheduler.runRegionally(target, () -> SafeTeleportService.teleportSafely$lambda$1(this, target, callback, player));
        } else {
            this.scheduler.runSync(() -> SafeTeleportService.teleportSafely$lambda$2(this, target, callback, player));
        }
    }

    public static /* synthetic */ void teleportSafely$default(SafeTeleportService safeTeleportService, Player player, Location location, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = SafeTeleportService::teleportSafely$lambda$0;
        }
        safeTeleportService.teleportSafely(player, location, function1);
    }

    @Nullable
    public final Location findNearestSafeLocation(@NotNull Location location, int horizontalRange, int verticalRange) {
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location base = location2;
        if (this.safetyEvaluator.invoke(base).booleanValue()) {
            return base;
        }
        World world = base.getWorld();
        if (world == null) {
            return null;
        }
        World world2 = world;
        List offsets = new ArrayList();
        int dy = -verticalRange;
        if (dy <= verticalRange) {
            while (true) {
                int dx;
                if ((dx = -horizontalRange) <= horizontalRange) {
                    while (true) {
                        int dz;
                        if ((dz = -horizontalRange) <= horizontalRange) {
                            while (true) {
                                if (dx != 0 || dy != 0 || dz != 0) {
                                    offsets.add(new Triple<Integer, Integer, Integer>(dx, dy, dz));
                                }
                                if (dz == horizontalRange) break;
                                ++dz;
                            }
                        }
                        if (dx == horizontalRange) break;
                        ++dx;
                    }
                }
                if (dy == verticalRange) break;
                ++dy;
            }
        }
        List $this$sortBy$iv = offsets;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Triple triple = (Triple)a;
                    boolean bl = false;
                    int dx = ((Number)triple.component1()).intValue();
                    int dy = ((Number)triple.component2()).intValue();
                    int dz = ((Number)triple.component3()).intValue();
                    triple = (Triple)b;
                    Comparable comparable = Integer.valueOf(dx * dx + dy * dy + dz * dz);
                    bl = false;
                    dx = ((Number)triple.component1()).intValue();
                    dy = ((Number)triple.component2()).intValue();
                    dz = ((Number)triple.component3()).intValue();
                    return ComparisonsKt.compareValues(comparable, dx * dx + dy * dy + dz * dz);
                }
            });
        }
        for (Triple triple : offsets) {
            int dx = ((Number)triple.component1()).intValue();
            int dy2 = ((Number)triple.component2()).intValue();
            int dz = ((Number)triple.component3()).intValue();
            Location candidate = new Location(world2, base.getX() + (double)dx, base.getY() + (double)dy2, base.getZ() + (double)dz, base.getYaw(), base.getPitch());
            if (!this.safetyEvaluator.invoke(candidate).booleanValue()) continue;
            return candidate;
        }
        return null;
    }

    public static /* synthetic */ Location findNearestSafeLocation$default(SafeTeleportService safeTeleportService, Location location, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 6;
        }
        if ((n3 & 4) != 0) {
            n2 = 4;
        }
        return safeTeleportService.findNearestSafeLocation(location, n, n2);
    }

    private static final Unit _init_$lambda$0(Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        if (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        return Unit.INSTANCE;
    }

    private static final Unit teleportSafely$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final void teleportSafely$lambda$1(SafeTeleportService this$0, Location $target, Function1 $callback, Player $player) {
        this$0.chunkLoader.invoke($target);
        Location safeLocation = SafeTeleportService.findNearestSafeLocation$default(this$0, $target, 0, 0, 6, null);
        if (safeLocation == null) {
            this$0.scheduler.runSync(() -> SafeTeleportService.teleportSafely$lambda$1$0($callback));
            return;
        }
        this$0.scheduler.runSync(() -> SafeTeleportService.teleportSafely$lambda$1$1($player, safeLocation, $callback));
    }

    private static final void teleportSafely$lambda$1$0(Function1 $callback) {
        $callback.invoke(false);
    }

    private static final void teleportSafely$lambda$1$1(Player $player, Location $safeLocation, Function1 $callback) {
        ((CompletableFuture)$player.teleportAsync($safeLocation).thenAccept(arg_0 -> SafeTeleportService.teleportSafely$lambda$1$1$1(arg_0 -> SafeTeleportService.teleportSafely$lambda$1$1$0($callback, arg_0), arg_0))).exceptionally(arg_0 -> SafeTeleportService.teleportSafely$lambda$1$1$2($callback, arg_0));
    }

    private static final Unit teleportSafely$lambda$1$1$0(Function1 $callback, Boolean result) {
        Intrinsics.checkNotNull(result);
        $callback.invoke(result);
        return Unit.INSTANCE;
    }

    private static final void teleportSafely$lambda$1$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void teleportSafely$lambda$1$1$2(Function1 $callback, Throwable it) {
        $callback.invoke(false);
        return null;
    }

    private static final void teleportSafely$lambda$2(SafeTeleportService this$0, Location $target, Function1 $callback, Player $player) {
        this$0.chunkLoader.invoke($target);
        Location safeLocation = SafeTeleportService.findNearestSafeLocation$default(this$0, $target, 0, 0, 6, null);
        if (safeLocation == null) {
            $callback.invoke(false);
            return;
        }
        boolean result = $player.teleport(safeLocation);
        $callback.invoke(result);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lpl/syntaxdevteam/punisher/teleport/SafeTeleportService$Companion;", "", "<init>", "()V", "isLocationSafe", "", "location", "Lorg/bukkit/Location;", "isSafeBodyBlock", "block", "Lorg/bukkit/block/Block;", "allowSolid", "isSafeFloor", "PunisherX"})
    private static final class Companion {
        private Companion() {
        }

        public final boolean isLocationSafe(@NotNull Location location) {
            boolean allowSolidFeet;
            Intrinsics.checkNotNullParameter(location, "location");
            World world = location.getWorld();
            if (world == null) {
                return false;
            }
            World world2 = world;
            Block block = world2.getBlockAt(location);
            Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
            Block feetBlock = block;
            Block block2 = feetBlock.getRelative(BlockFace.UP);
            Intrinsics.checkNotNullExpressionValue(block2, "getRelative(...)");
            Block headBlock = block2;
            Block block3 = feetBlock.getRelative(BlockFace.DOWN);
            Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
            Block belowBlock = block3;
            double yOffset = location.getY() - (double)location.getBlockY();
            boolean bl = allowSolidFeet = Math.abs(yOffset) < 0.001;
            if (!this.isSafeBodyBlock(feetBlock, allowSolidFeet) || !this.isSafeBodyBlock(headBlock, false)) {
                return false;
            }
            return this.isSafeFloor(belowBlock);
        }

        public final boolean isSafeBodyBlock(@NotNull Block block, boolean allowSolid) {
            Intrinsics.checkNotNullParameter(block, "block");
            Material material = block.getType();
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
            Material type = material;
            if (type == Material.LAVA || type == Material.FIRE || type == Material.CACTUS || type == Material.SWEET_BERRY_BUSH || type == Material.CAMPFIRE || type == Material.SOUL_CAMPFIRE || type == Material.MAGMA_BLOCK || type == Material.WATER || type == Material.BUBBLE_COLUMN || type == Material.POWDER_SNOW) {
                return false;
            }
            if (block.isPassable() || type == Material.AIR) {
                return true;
            }
            return allowSolid && type.isSolid();
        }

        public final boolean isSafeFloor(@NotNull Block block) {
            Intrinsics.checkNotNullParameter(block, "block");
            Material material = block.getType();
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
            Material type = material;
            if (type == Material.AIR || !type.isSolid()) {
                return false;
            }
            return type != Material.LAVA && type != Material.FIRE && type != Material.WATER && type != Material.MAGMA_BLOCK && type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

